/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao;

import com.touchcomp.basementor.constants.enums.criteria.EnumConstBaseOrder;
import com.touchcomp.basementor.constants.enums.finder.BaseEnumFieldOption;
import com.touchcomp.basementor.model.vo.SearchClassField;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.constants.EnumConstantsCriteria;
import com.touchcomp.basementortools.tools.converter.CompRestrictionsFactory;
import com.touchcomp.basementortools.tools.converter.impl.OpFinder;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import contatocore.constants.ConstantsFinder;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.finder.BaseCriteria;
import mentorcore.finder.BaseFilter;
import mentorcore.finder.BaseOrder;
import mentorcore.finder.enums.BaseEnumType;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Junction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.proxy.HibernateProxy;

public abstract class CoreBaseDAO
implements ConstantsFinder {
    private TLogger logger = TLogger.get(CoreBaseDAO.class);

    public Object update(Object vo) throws ExceptionDatabase {
        try {
            Session s = this.getSession();
            vo = s.merge(vo);
            return vo;
        }
        catch (HibernateException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new ExceptionDatabase(e.getMessage(), e);
        }
    }

    public Object saveOrUpdate(Object vo) throws ExceptionDatabase {
        return this.update(vo);
    }

    public boolean delete(Object vo) throws ExceptionDatabase {
        try {
            Session s = this.getSession();
            s.delete(vo);
            return true;
        }
        catch (HibernateException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new ExceptionDatabase(e.getMessage(), e);
        }
    }

    public boolean deleteByKey(Object key) throws ExceptionDatabase {
        Object o = this.findByPrimaryKey(key);
        return this.delete(o);
    }

    public abstract Class getVOClass();

    public Object findByPrimaryKey(Object key) throws ExceptionDatabase {
        try {
            Session s = this.getSession();
            Object obj = s.get(this.getVOClass().newInstance().getClass(), (Serializable)key);
            return obj;
        }
        catch (HibernateException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new ExceptionDatabase(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new ExceptionDatabase(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new ExceptionDatabase(e.getMessage(), e);
        }
    }

    public Object findByPrimaryKeySearchRest(Object key, Map<String, Object> repoObjects, List<BaseFilter> myFilters) throws ExceptionDatabase, ExceptionReflection {
        String idProperty = CoreBdUtil.getInstance().getIdProperty(this.getVOClass());
        BaseCriteria base = BaseCriteria.create(this.getVOClass());
        base.and().equal(idProperty, key);
        for (SearchClassField fixedFilter : this.getFixedFilters(base.getVoClass())) {
            this.getExpressionSearchRest(base, fixedFilter, repoObjects);
        }
        if (myFilters != null) {
            base.and().getFilters().addAll(myFilters);
        }
        return this.executeSearchUniqueResult(base);
    }

    private void getExpressionSearchRest(BaseCriteria base, SearchClassField fixedFilter, Map<String, Object> repoObjects) throws ExceptionReflection {
        Object value = this.testConvertValue(fixedFilter, repoObjects);
        switch (fixedFilter.getDefaultCriteria()) {
            case -1: {
                base.and().between(fixedFilter.getPathField(), value, value);
                break;
            }
            case 0: {
                base.and().equal(fixedFilter.getPathField(), value);
                break;
            }
            case 8: {
                base.and().empty(fixedFilter.getPathField());
                break;
            }
            case 2: {
                base.and().greater(fixedFilter.getPathField(), value);
                break;
            }
            case 3: {
                base.and().greaterEqual(fixedFilter.getPathField(), value);
                break;
            }
            case 7: {
                base.and().isNotNull(fixedFilter.getPathField());
                break;
            }
            case 6: {
                base.and().isNull(fixedFilter.getPathField());
                break;
            }
            case 4: {
                base.and().less(fixedFilter.getPathField(), value);
                break;
            }
            case 5: {
                base.and().lessEqual(fixedFilter.getPathField(), value);
                break;
            }
            case 10: {
                base.and().like(fixedFilter.getPathField(), value);
                break;
            }
            case 12: {
                base.and().likeRight(fixedFilter.getPathField(), value);
                break;
            }
            case 13: {
                base.and().likeLeft(fixedFilter.getPathField(), value);
                break;
            }
            case 11: {
                base.and().ilike(fixedFilter.getPathField(), value);
                break;
            }
            case 14: {
                base.and().ilikeRight(fixedFilter.getPathField(), value);
                break;
            }
            case 15: {
                base.and().ilikeLeft(fixedFilter.getPathField(), value);
                break;
            }
            case 9: {
                base.and().notEmpty(fixedFilter.getPathField());
                break;
            }
            case 1: {
                base.and().notEqual(fixedFilter.getPathField(), value);
                break;
            }
            default: {
                base.and().equal(fixedFilter.getPathField(), value);
            }
        }
    }

    public Long getCountOfRegistersInternal(BaseCriteria baseCriteria) {
        String baseAlias = "aux";
        Criteria c = this.getSession().createCriteria(baseCriteria.getVoClass(), baseAlias);
        LinkedList<String> aliases = new LinkedList<String>();
        this.addRestrictions(c, baseCriteria.getBaseFilter(), baseAlias, aliases);
        this.addOrders(c, baseCriteria, baseAlias, aliases);
        if (baseCriteria.getResultTransformer() != null) {
            c.setResultTransformer(baseCriteria.getResultTransformer());
        }
        this.addFields(c, baseCriteria, aliases, baseAlias);
        c.setProjection(Projections.rowCount());
        Long res = (Long)c.uniqueResult();
        return res == null ? 0L : res;
    }

    private Object testConvertValue(SearchClassField fixedFilter, Map<String, Object> repoObjects) throws ExceptionReflection {
        Object ob = null;
        if (repoObjects != null) {
            ob = this.tryGoGetFromRepo(fixedFilter, repoObjects);
        }
        if (ob != null) {
            return ob;
        }
        OpFinder finder = CompRestrictionsFactory.getRestrictions((String)fixedFilter.getFieldClass());
        return finder.convertValue(fixedFilter.getDefaultValue());
    }

    private List<SearchClassField> getFixedFilters(String voClass) {
        Criteria c = this.getSession().createCriteria(SearchClassField.class);
        c.createAlias("searchClass", "s");
        c.add((Criterion)Restrictions.eq((String)"fieldTypeOpt", (Object)BaseEnumFieldOption.FIXED_FILTER_SYSTEM.value));
        c.add((Criterion)Restrictions.eq((String)"s.voClass", (Object)voClass));
        return c.list();
    }

    public Collection findAll() throws ExceptionDatabase {
        return this.findAll(null, true);
    }

    public Collection findAll(String orderBy) throws ExceptionDatabase {
        return this.findAll(orderBy, true);
    }

    public Collection findAll(String orderBy, boolean asc) throws ExceptionDatabase {
        try {
            Session s = this.getSession();
            Criteria crit = s.createCriteria(this.getVOClass());
            if (null != orderBy) {
                crit.addOrder(asc ? Order.asc((String)orderBy) : Order.desc((String)orderBy));
            }
            List list = crit.list();
            return list;
        }
        catch (HibernateException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new ExceptionDatabase(e.getMessage(), e);
        }
    }

    public Collection findByCriteria(String fieldName, Object value, int option) throws ExceptionDatabase {
        return this.findByCriteria(fieldName, value, option, null);
    }

    public Collection findByCriteria(String fieldName, Object value, int option, String orderBy) throws ExceptionDatabase {
        return this.findByCriteria(fieldName, value, option, orderBy, true);
    }

    public Collection findByCriteria(String fieldName, Object value, int option, String orderBy, boolean asc) throws ExceptionDatabase {
        try {
            Session s = this.getSession();
            Criteria crit = s.createCriteria(this.getVOClass());
            crit.add(this.getExpression(fieldName, value, null, option));
            if (null != orderBy) {
                crit.addOrder(asc ? Order.asc((String)orderBy) : Order.desc((String)orderBy));
            }
            List lista = crit.list();
            return lista;
        }
        catch (HibernateException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new ExceptionDatabase(e.getMessage(), e);
        }
    }

    public Object findByCriteriaUniqueResult(String fieldName, Object value, int option) throws ExceptionDatabase {
        try {
            Session s = this.getSession();
            Criteria crit = s.createCriteria(this.getVOClass());
            crit.add(this.getExpression(fieldName, value, null, option));
            crit.setMaxResults(1);
            return crit.uniqueResult();
        }
        catch (HibernateException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new ExceptionDatabase(e.getMessage(), e);
        }
    }

    public void lock(Object o, LockMode lock) throws ExceptionDatabase {
        try {
            if (o == null) {
                return;
            }
            this.getSession().lock(o, lock);
        }
        catch (Exception ex) {
            throw new ExceptionDatabase(ex.getMessage(), ex);
        }
    }

    public LinkedList saveOrUpdateCollection(Collection list) throws ExceptionDatabase {
        if (list == null) {
            return new LinkedList();
        }
        LinkedList<Object> aux = new LinkedList<Object>();
        for (Object vo : list) {
            aux.add(this.update(vo));
        }
        return aux;
    }

    public Criterion getExpression(String fieldName, Object value, Object value1, Integer option) {
        return this.getExpression(fieldName, new BaseFilter(fieldName, EnumConstantsCriteria.valueOfByValue((Integer)option), value, value1));
    }

    public Criterion getExpression(String fieldName, Object value, Object value1, Integer option, Integer size) {
        return this.getExpression(fieldName, new BaseFilter(fieldName, EnumConstantsCriteria.valueOfByValue((Integer)option), value, value1));
    }

    public void evict(Object obj) throws ExceptionDatabase {
        try {
            Session s = this.getSession();
            s.evict(obj);
        }
        catch (HibernateException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new ExceptionDatabase(e.getMessage(), e);
        }
    }

    protected Criteria createCriteria() {
        return this.getSession().createCriteria(this.getVOClass());
    }

    protected Session getSession() {
        return CoreBdUtil.getInstance().getSession();
    }

    public List executeSearch(BaseCriteria baseCriteria) {
        String baseAlias = "aux";
        Criteria c = this.getSession().createCriteria(baseCriteria.getVoClass(), baseAlias);
        LinkedList<String> aliases = new LinkedList<String>();
        this.addRestrictions(c, baseCriteria.getBaseFilter(), baseAlias, aliases);
        this.addOrders(c, baseCriteria, baseAlias, aliases);
        if (baseCriteria.getResultTransformer() != null) {
            c.setResultTransformer(baseCriteria.getResultTransformer());
        }
        this.addFields(c, baseCriteria, aliases, baseAlias);
        if (baseCriteria.getFirstResult() != null && baseCriteria.getFirstResult() >= 0) {
            c.setFirstResult(baseCriteria.getFirstResult().intValue());
        }
        if (baseCriteria.getMaxResults() != null && baseCriteria.getMaxResults() >= 0) {
            c.setMaxResults(baseCriteria.getMaxResults().intValue());
        }
        return c.list();
    }

    public List executeSearchRest(BaseCriteria base, Map<String, Object> repoObjects) throws ExceptionReflection {
        for (SearchClassField fixedFilter : this.getFixedFilters(base.getVoClass())) {
            this.getExpressionSearchRest(base, fixedFilter, repoObjects);
        }
        return this.executeSearch(base);
    }

    private void addOrders(Criteria c, BaseCriteria baseCriteria, String baseAlias, List<String> aliases) {
        for (BaseOrder order : baseCriteria.getOrders()) {
            String token = this.createAliases(c, order.getField(), baseAlias, aliases);
            if (order.getOrder() == EnumConstBaseOrder.ASCEND) {
                c.addOrder(Order.asc((String)token));
                continue;
            }
            c.addOrder(Order.desc((String)token));
        }
    }

    private void addRestrictions(Criteria c, BaseFilter base, String baseAlias, List<String> aliases) {
        if (base == null || base.getFilters().isEmpty()) {
            return;
        }
        Junction junction = this.createJunction(base);
        c.add((Criterion)junction);
        for (BaseFilter filter : base.getFilters()) {
            if (filter.getBaseEnumType() == BaseEnumType.RESTRICTION) {
                this.addRestriction(c, junction, filter, baseAlias, aliases);
                continue;
            }
            this.addRestrictions(c, filter, baseAlias, aliases);
        }
    }

    private void addRestriction(Criteria c, Junction junction, BaseFilter filter, String baseAlias, List<String> aliases) {
        String token = this.createAliases(c, filter.getField(), baseAlias, aliases);
        junction.add(this.getExpression(token, filter));
    }

    private String createAliases(Criteria c, String pathField, String baseAlias, List<String> aliases) {
        String token;
        StringTokenizer sk = new StringTokenizer(pathField, ".");
        int count = sk.countTokens();
        if (count > 1) {
            for (int i = 0; i < count - 1; ++i) {
                token = sk.nextToken();
                String alias = (String)baseAlias + "_" + i + "_" + token;
                if (!aliases.contains(alias)) {
                    c.createAlias((String)baseAlias + "." + token, alias);
                    aliases.add(alias);
                }
                baseAlias = alias;
            }
        }
        token = sk.nextToken();
        return (String)baseAlias + "." + token;
    }

    private Criterion getExpression(String string, BaseFilter filter) {
        return switch (filter.getOption()) {
            case EnumConstantsCriteria.BETWEEN -> Restrictions.between((String)string, (Object)filter.getValue1(), (Object)filter.getValue2());
            case EnumConstantsCriteria.EQUAL -> Restrictions.eq((String)string, (Object)filter.getValue1());
            case EnumConstantsCriteria.EMPTY -> Restrictions.isEmpty((String)string);
            case EnumConstantsCriteria.GREATER -> Restrictions.gt((String)string, (Object)filter.getValue1());
            case EnumConstantsCriteria.GREATER_EQUAL -> Restrictions.ge((String)string, (Object)filter.getValue1());
            case EnumConstantsCriteria.IS_NOT_NULL -> Restrictions.isNotNull((String)string);
            case EnumConstantsCriteria.IS_NULL -> Restrictions.isNull((String)string);
            case EnumConstantsCriteria.LESS -> Restrictions.lt((String)string, (Object)filter.getValue1());
            case EnumConstantsCriteria.LESS_EQUAL -> Restrictions.le((String)string, (Object)filter.getValue1());
            case EnumConstantsCriteria.LIKE -> Restrictions.like((String)string, (Object)("%" + String.valueOf(filter.getValue1()) + "%"));
            case EnumConstantsCriteria.LIKE_RIGHT -> Restrictions.like((String)string, (Object)(String.valueOf(filter.getValue1()) + "%"));
            case EnumConstantsCriteria.LIKE_LEFT -> Restrictions.like((String)string, (Object)("%" + String.valueOf(filter.getValue1())));
            case EnumConstantsCriteria.ILIKE -> Restrictions.ilike((String)string, (Object)("%" + String.valueOf(filter.getValue1()) + "%"));
            case EnumConstantsCriteria.ILIKE_RIGTH -> Restrictions.ilike((String)string, (Object)(String.valueOf(filter.getValue1()) + "%"));
            case EnumConstantsCriteria.ILIKE_LEFT -> Restrictions.ilike((String)string, (Object)("%" + String.valueOf(filter.getValue1())));
            case EnumConstantsCriteria.NOT_EMPTY -> Restrictions.isNotEmpty((String)string);
            case EnumConstantsCriteria.NOT_EQUAL -> Restrictions.ne((String)string, (Object)filter.getValue1());
            default -> Restrictions.eq((String)string, (Object)filter.getValue1());
        };
    }

    private Junction createJunction(BaseFilter query) {
        if (query.getBaseEnumType() == BaseEnumType.CONJUNCTION) {
            return Restrictions.conjunction();
        }
        return Restrictions.disjunction();
    }

    public Object executeSearchUniqueResult(BaseCriteria baseCriteria) {
        String baseAlias = "aux";
        Criteria c = this.getSession().createCriteria(baseCriteria.getVoClass(), baseAlias);
        LinkedList<String> aliases = new LinkedList<String>();
        this.addRestrictions(c, baseCriteria.getBaseFilter(), baseAlias, aliases);
        this.addOrders(c, baseCriteria, baseAlias, aliases);
        if (baseCriteria.getResultTransformer() != null) {
            c.setResultTransformer(baseCriteria.getResultTransformer());
        }
        this.addFields(c, baseCriteria, aliases, baseAlias);
        c.setMaxResults(1);
        return c.uniqueResult();
    }

    private void addFields(Criteria c, BaseCriteria baseCriteria, List aliases, String baseAlias) {
        if (baseCriteria.getFields().isEmpty()) {
            return;
        }
        ProjectionList list = Projections.projectionList();
        for (String field : baseCriteria.getFields()) {
            String ret = this.createAliases(c, field, baseAlias, aliases);
            list.add((Projection)Projections.property((String)ret));
        }
        c.setProjection((Projection)list);
    }

    private Object tryGoGetFromRepo(SearchClassField fixedFilter, Map<String, Object> repoObjects) throws ExceptionReflection {
        Set<String> keys = repoObjects.keySet();
        String path = fixedFilter.getDefaultValue();
        Optional<String> found = keys.stream().filter(i -> path.startsWith((String)i)).findFirst();
        if (!found.isPresent()) {
            return null;
        }
        String method = path.substring(found.get().length() + 1);
        Object obj = repoObjects.get(found.get());
        return ToolReflections.getFieldValueFromGetMethod((String)method, (Object)obj);
    }

    public Object reloadObject(Object obj) throws ExceptionDatabase {
        try {
            Hibernate.initialize((Object)obj);
            if (obj instanceof HibernateProxy) {
                obj = ((HibernateProxy)obj).getHibernateLazyInitializer().getImplementation();
            }
            return obj;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new ExceptionDatabase(e.getMessage(), e);
        }
    }
}

