/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoMedias;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.Ano13oSalario;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementor.model.vo.Salario13oColaborador;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import contatocore.util.ContatoFormatUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;
import mentorcore.tools.DateUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DAOAno13oSalario
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return Ano13oSalario.class;
    }

    public List findColaboradoresPagAddDecSalario(Integer ano, Long idEmpresa, Long codigoEventoAddDec, Date dataPagamento) {
        String hql = " from Colaborador c     where    (c.tipoColaborador.identificador != :autonomo     and     c.tipoColaborador.identificador != :autonomoFrete    and     c.tipoColaborador.identificador != :socioDiretor)     and     extract(year from c.dataAdmissao) <= :ano     and     c.ativo = 1     and     not exists (select mov.colaborador                 from MovimentoFolha mov                 inner join mov.itensMovimentoFolha item                 where                 mov.colaborador = c                 and                 item.eventoColaborador.tipoCalculoEvento.evento.codigo = :eventoAddDec                 and                 extract(year from mov.aberturaPeriodo.dataInicio) = :ano)   and   (c.dataDemissao is null or c.dataDemissao > :dataPagamento )     and    not exists (select af.colaborador              from AfastamentoColaborador af              where              af.dataAfastamento != null                and              ( af.dataAfastamento < :primeiroJaneiro and af.dataRetorno is null or af.dataRetorno > :dataPagamento )              and               af.colaborador = c               and               af.afastamentoSefip.codigo != :cod1              and               af.afastamentoSefip.codigo != :cod2              and               af.afastamentoSefip.codigo != :cod3) and  c.empresa.identificador = :idEmpresa";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("autonomo", EnumConstTipoColaborador.AUTONOMO.getValue()).setLong("autonomoFrete", EnumConstTipoColaborador.AUTONOMO_FRETE.getValue()).setLong("socioDiretor", EnumConstTipoColaborador.SOCIO_DIRETOR.getValue()).setInteger("ano", ano.intValue()).setLong("idEmpresa", idEmpresa.longValue()).setDate("dataPagamento", dataPagamento).setLong("eventoAddDec", codigoEventoAddDec.longValue()).setDate("primeiroJaneiro", DateUtil.intToDate(ano, 1, 1)).setString("cod1", "Z1").setString("cod2", "Q1").setString("cod3", "U1").list();
    }

    public List findColaboradoresPagamentoDecSalario(Integer ano, Long idEmpresa, Date dataPagamento) {
        String hql = " from Colaborador c  where  (c.tipoColaborador.identificador != :autonomoFrete  and  c.tipoColaborador.identificador  != :autonomo and  c.tipoColaborador.identificador != :socioDiretor)  and  extract(year from c.dataAdmissao) <= :ano  and  c.ativo = 1  and  (c.dataDemissao is null or c.dataDemissao > :dataPagamento )  and   not exists (select af.colaborador              from AfastamentoColaborador af              where             af.dataAfastamento != null             and               ( af.dataAfastamento < :primeiroJaneiro and (af.dataRetorno is null or af.dataRetorno > :dataPagamento ))              and               af.colaborador = c               and               af.afastamentoSefip.codigo != :cod1              and               af.afastamentoSefip.codigo != :cod2              and af.afastamentoSefip.codigo != :cod3)  and  c.empresa.identificador = :idEmpresa  and  not exists (select salario13.colaborador             from Salario13oColaborador salario13             where             salario13.ano13Salario.ano = :ano             and             salario13.ano13Salario.tipoCalculo = :pagDec            and             salario13.colaborador = c)";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("autonomo", EnumConstTipoColaborador.AUTONOMO.getValue()).setLong("autonomoFrete", EnumConstTipoColaborador.AUTONOMO_FRETE.getValue()).setLong("socioDiretor", EnumConstTipoColaborador.SOCIO_DIRETOR.getValue()).setShort("pagDec", (short)2).setInteger("ano", ano.intValue()).setDate("dataPagamento", dataPagamento).setDate("primeiroJaneiro", DateUtil.intToDate(ano, 1, 1)).setString("cod1", "Z1").setString("cod2", "Q1").setString("cod3", "U1").setLong("idEmpresa", idEmpresa.longValue()).list();
    }

    public List findMediaPagamentoDec(Colaborador colaborador, Integer ano) throws ExceptionService {
        String hql = " select  item.eventoColaborador.tipoCalculoEvento.identificador as ID_EVENTO,  sum(item.referencia) as REFERENCIA , sum(item.valor) as VALOR, item.eventoColaborador.tipoCalculoEvento.mediaFerias as TIPO_MEDIA, item.eventoColaborador.identificador as ID_EVENTO_COLABORADOR  from ItemMovimentoFolha item  where  (item.eventoColaborador.tipoCalculoEvento.media13Salario = :referencia  or item.eventoColaborador.tipoCalculoEvento.media13Salario = :valor) and  item.movimentoFolha.colaborador = :colaborador  and  (extract(year from item.movimentoFolha.aberturaPeriodo.dataInicio) = :ano)  group by item.eventoColaborador.tipoCalculoEvento.identificador, item.eventoColaborador.tipoCalculoEvento.mediaFerias,item.eventoColaborador.identificador ";
        List l = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setShort("referencia", EnumConstEventoMedias.MEDIA_REFERENCIA.getValue()).setShort("valor", EnumConstEventoMedias.MEDIA_VALOR.getValue()).setInteger("ano", ano.intValue()).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        ArrayList<HashMap> retorno = new ArrayList<HashMap>();
        for (Object obj : l) {
            HashMap h = (HashMap)obj;
            Long id = (Long)h.get("ID_EVENTO");
            TipoCalculoEvento tipo = (TipoCalculoEvento)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOTipoCalculoEvento(), "identificador", id, 0);
            h.put("tipoCalculo", tipo);
            retorno.add(h);
        }
        return retorno;
    }

    public Double getSalarioNominal(Salario13oColaborador vo) {
        Colaborador colaborador = vo.getColaborador();
        Integer codigo = new Integer(colaborador.getTipoSalario().getCodigo());
        Date periodoAbertura = vo.getDataPagamento();
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select c.valorSalario  from ColaboradorSalario c where c.periodo = (select max(cc.periodo)                     from ColaboradorSalario cc                    where (cc.periodo <= :periodo)                     and cc.colaborador.identificador = :colaborador) and  c.colaborador.identificador = :colaborador");
        q.setLong("colaborador", colaborador.getIdentificador().longValue());
        q.setDate("periodo", periodoAbertura);
        if (q.uniqueResult() == null) {
            return 0.0;
        }
        Double valorSalario = (Double)q.uniqueResult();
        switch (codigo) {
            case 1: {
                return valorSalario;
            }
            case 2: {
                return valorSalario;
            }
            case 3: {
                return valorSalario;
            }
            case 4: {
                valorSalario = valorSalario * colaborador.getDiasJornada();
                return valorSalario;
            }
            case 5: {
                valorSalario = valorSalario * colaborador.getDiasJornada() * colaborador.getHorasTrabDia();
                valorSalario = ContatoFormatUtil.arrredondarNumero((Double)valorSalario, (int)2);
                return valorSalario;
            }
            case 6: {
                return valorSalario;
            }
            case 7: {
                return valorSalario;
            }
        }
        return valorSalario;
    }

    public List findAfastamentosAnuaisPorColaborador(Colaborador colaborador, Integer ano) {
        List retorno = new ArrayList();
        String hql = " ";
        hql = " select af  from AfastamentoColaborador af  where  af.dataAfastamento != null  and  af.colaborador = :colaborador  and  ((extract(year from af.dataAfastamento) = :ano)  or  ((extract(year from af.dataRetorno)) = :ano )) and  af.afastamentoSefip.codigo != :cod1  and  af.afastamentoSefip.codigo != :cod3";
        retorno = CoreBdUtil.getInstance().getSession().createQuery(hql).setInteger("ano", ano.intValue()).setEntity("colaborador", (Object)colaborador).setString("cod1", "Q1").setString("cod3", "U1").list();
        return retorno;
    }

    public List findAfastamentosMaternidadePorColaborador(Colaborador colaborador, Integer ano) {
        List retorno = new ArrayList();
        String hql = " ";
        hql = " select af  from AfastamentoColaborador af  where  af.dataAfastamento != null  and  af.colaborador = :colaborador  and  ((extract(year from af.dataAfastamento) = :ano)  or  ((extract(year from af.dataRetorno)) = :ano )) and  af.afastamentoSefip.codigo = :cod1 ";
        retorno = CoreBdUtil.getInstance().getSession().createQuery(hql).setInteger("ano", ano.intValue()).setEntity("colaborador", (Object)colaborador).setString("cod1", "Q1").list();
        return retorno;
    }

    public List findAfastamentosAnuaisPorColaboradorFeminino(Colaborador colaborador, Integer ano) {
        List retorno = new ArrayList();
        String hql = " ";
        hql = " select af  from AfastamentoColaborador af  where  af.dataAfastamento != null  and  af.colaborador = :colaborador  and  ((extract(year from af.dataAfastamento) = :ano)  or  ((extract(year from af.dataRetorno)) = :ano )) and  af.afastamentoSefip.codigo != :cod3";
        retorno = CoreBdUtil.getInstance().getSession().createQuery(hql).setInteger("ano", ano.intValue()).setEntity("colaborador", (Object)colaborador).setString("cod3", "U1").list();
        return retorno;
    }

    public Integer verificarFaltasPorPeriodo(Salario13oColaborador vo, Integer ano) {
        Colaborador colaborador = vo.getColaborador();
        Short tipoFolha = EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue();
        String hql = " select count(m.identificador)  from MovimentoFolha m  where  (m.diasFolgas + m.diasFeriados + m.diasTrabalhados - m.diasFaltosos) < 15  and  m.diasFaltosos > 15  and  m.colaborador = :colaborador  and  m.empresa = :empresa  and  extract(year from m.aberturaPeriodo.dataFinal) = :ano  and  m.aberturaPeriodo.tipoCalculo.tipoFolha = :tipoFolha ";
        Long result = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setEntity("empresa", (Object)colaborador.getEmpresa()).setInteger("ano", ano.intValue()).setShort("tipoFolha", tipoFolha.shortValue()).uniqueResult();
        if (result == null) {
            return 0;
        }
        return result.intValue();
    }

    public Integer verificarFaltasPorPeriodoRecisao13(Recisao vo, TipoCalculoEvento tpFaltas) {
        Colaborador colaborador = vo.getColaborador();
        Short tipoFolha = EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue();
        String hql = " select count(m.identificador)  from MovimentoFolha m  inner join m.itensMovimentoFolha i  where  (m.aberturaPeriodo.numeroFolgas + m.aberturaPeriodo.numeroFeriados + m.aberturaPeriodo.numeroDiasUteis - i.referencia) < 15   and  i.referencia > 15  and  i.eventoColaborador.tipoCalculoEvento = :tpFaltas and  m.colaborador = :colaborador  and  m.empresa = :empresa  and  extract(year from m.aberturaPeriodo.dataFinal) = :ano  and  m.aberturaPeriodo.tipoCalculo.tipoFolha = :tipoFolha ";
        Long result = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("tpFaltas", (Object)tpFaltas).setEntity("colaborador", (Object)colaborador).setEntity("empresa", (Object)colaborador.getEmpresa()).setInteger("ano", DateUtil.yearFromDate(vo.getDataAfastamento()).intValue()).setShort("tipoFolha", tipoFolha.shortValue()).uniqueResult();
        if (result == null) {
            return 0;
        }
        return result.intValue();
    }
}

