/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.AgrupamentoValorIpi;
import com.touchcomp.basementor.model.vo.AjusteApuracaoIpi;
import com.touchcomp.basementor.model.vo.ApuracaoIPI;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.CodigoAjusteIpi;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IncidenciaIpi;
import com.touchcomp.basementor.model.vo.IndicadorOrigemIpi;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.service.CoreRequestContext;
import mentorcore.tools.DateUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DAOApuracaoIPI
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return ApuracaoIPI.class;
    }

    public Object validarApuracaoData(CoreRequestContext request) {
        Session s = CoreBdUtil.getInstance().getSession();
        Date d1 = (Date)request.getAttribute("dataInicial");
        Date d2 = (Date)request.getAttribute("dataFinal");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        Query q = s.createQuery("select count(a) from ApuracaoIPI a where a.dataInicial between :dataInicial and :dataFinal and a.empresa=:empresa ");
        q.setDate("dataInicial", d1);
        q.setDate("dataFinal", d2);
        q.setEntity("empresa", (Object)empresa);
        Long resultado = (Long)q.uniqueResult();
        if (resultado == null) {
            resultado = 0L;
        }
        if (resultado > 0L) {
            return false;
        }
        return true;
    }

    public Object validarApuracaoMesAnterior(CoreRequestContext request) {
        ApuracaoIPI apuracao = null;
        Session s = CoreBdUtil.getInstance().getSession();
        Date d = (Date)request.getAttribute("data");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        Query q = s.createQuery("select max(a.identificador)  from ApuracaoIPI a where a.anoMes < :data and a.empresa = :empresa");
        q.setDate("data", d);
        q.setEntity("empresa", (Object)empresa);
        Long identificador = (Long)q.uniqueResult();
        if (identificador != null) {
            q = s.createQuery("from ApuracaoIPI a where a.identificador = :identificador and a.empresa = :empresa");
            q.setLong("identificador", identificador.longValue());
            q.setEntity("empresa", (Object)empresa);
            apuracao = (ApuracaoIPI)q.uniqueResult();
            if (apuracao != null) {
                int diferenca;
                if (apuracao.getTipoApuracao() == 0 || apuracao.getTipoApuracao() == 1) {
                    return false;
                }
                if (apuracao.getTipoApuracao() == 3 && Math.abs(diferenca = DateUtil.getMesesEntreDatas(apuracao.getAnoMes(), d, false).intValue()) > 1) {
                    return false;
                }
            }
        }
        return true;
    }

    public Object validarApuracaoMensalMesAtual(Date data, Short tipoApuracao, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("from ApuracaoIPI a where a.anoMes = :data  and a.tipoApuracao = :mensal  and a.empresa = :empresa");
        q.setDate("data", data);
        q.setShort("mensal", (short)3);
        q.setEntity("empresa", (Object)empresa);
        ApuracaoIPI apuracao = (ApuracaoIPI)q.uniqueResult();
        if (apuracao != null) {
            return false;
        }
        return true;
    }

    public Object validarApuracaoDecendioMesAtual(Date data, Short tipoApuracao, Empresa empresa) {
        if (tipoApuracao == 1) {
            return this.validarDecendio2(data, empresa);
        }
        if (tipoApuracao == 2) {
            return this.validarDecendio3(data, empresa);
        }
        if (tipoApuracao == 3) {
            return this.validarMensal(data, empresa);
        }
        return true;
    }

    private Object validarDecendio2(Date data, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "from ApuracaoIPI a where a.anoMes = :data  and a.tipoApuracao = :tipoApuracao and a.empresa = :empresa";
        Query q = s.createQuery(hql);
        q.setDate("data", data);
        q.setShort("tipoApuracao", (short)0);
        q.setEntity("empresa", (Object)empresa);
        ApuracaoIPI apuracao = (ApuracaoIPI)q.uniqueResult();
        if (apuracao == null) {
            return false;
        }
        return true;
    }

    private Object validarDecendio3(Date data, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "from ApuracaoIPI a where a.anoMes = :data  and a.tipoApuracao = :tipoApuracao and a.empresa = :empresa";
        Query q = s.createQuery(hql);
        q.setDate("data", data);
        q.setShort("tipoApuracao", (short)1);
        q.setEntity("empresa", (Object)empresa);
        ApuracaoIPI apuracao = (ApuracaoIPI)q.uniqueResult();
        if (apuracao == null) {
            return false;
        }
        return true;
    }

    private Object validarMensal(Date data, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "from ApuracaoIPI a where a.anoMes = :data  and (a.tipoApuracao = :decendio1 or a.tipoApuracao = :decendio2 or a.tipoApuracao = :decendio3) and a.empresa = :empresa";
        Query q = s.createQuery(hql);
        q.setDate("data", data);
        q.setShort("decendio1", (short)0);
        q.setShort("decendio2", (short)1);
        q.setShort("decendio3", (short)2);
        q.setEntity("empresa", (Object)empresa);
        ApuracaoIPI apuracao = (ApuracaoIPI)q.uniqueResult();
        if (apuracao != null) {
            return false;
        }
        return true;
    }

    public Double saldoCredorAnterior(Date dataInicial, Short tipoApuracao, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select a.saldoCredor from ApuracaoIPI a where a.dataFinal=(select max(a1.dataFinal) from ApuracaoIPI a1 where a1.tipoApuracao=:tpApuracao and a1.dataFinal<:data and   a1.empresa = :empresa)  and a.tipoApuracao=:tpApuracao and a.empresa = :empresa");
        q.setShort("tpApuracao", tipoApuracao.shortValue());
        q.setDate("data", dataInicial);
        q.setEntity("empresa", (Object)empresa);
        Double resultado = (Double)q.uniqueResult();
        if (resultado == null) {
            resultado = 0.0;
        }
        return resultado;
    }

    public Object deletarApuracaoIpi(ApuracaoIPI vo) throws ExceptionDatabase, Exception {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("from ApuracaoIPI a where a.identificador > :idApuracao and a.empresa = :empresa");
        q.setLong("idApuracao", vo.getIdentificador().longValue());
        q.setEntity("empresa", (Object)vo.getEmpresa());
        List lista = q.list();
        if (lista != null && !lista.isEmpty()) {
            throw new Exception("N\u00e3o \u00e9 poss\u00edvel excluir essa Apura\u00e7\u00e3o IPI pois existem outras Apura\u00e7\u00f5es com datas superiores a esta.");
        }
        CoreDAOFactory.getInstance().getDAOApuracaoIPI().delete(vo);
        return null;
    }

    public Object validarUltimoRegistro(ApuracaoIPI vo) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select max(a.identificador) from ApuracaoIPI a where (select max(a1.identificador) from ApuracaoIPI a1 where a1.empresa = :empresa) = :idApuracao  and a.empresa=:empresa ");
        q.setLong("idApuracao", vo.getIdentificador().longValue());
        q.setEntity("empresa", (Object)vo.getEmpresa());
        Long resultado = (Long)q.uniqueResult();
        if (resultado == null) {
            resultado = 0L;
        }
        if (resultado > 0L) {
            return false;
        }
        return true;
    }

    public Object calcularValoresIpi(CoreRequestContext request) throws ExceptionDatabase {
        Date dataIn = (Date)request.getAttribute("dataIn");
        Date dataFim = (Date)request.getAttribute("dataFim");
        Short tpApuracao = (Short)request.getAttribute("tpApuracao");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        List toRet = this.getResumoSaida(dataIn, dataFim, tpApuracao, empresa);
        Double valorDebito = this.getValorDebito(dataIn, dataFim, empresa);
        Double valorCredito = this.getValorCredito(dataIn, dataFim, empresa);
        Double valorSaldoAnt = this.saldoCredorAnterior(dataIn, tpApuracao, empresa);
        List<AjusteApuracaoIpi> ajustesDebitos = this.getAjustesOutrosDebitos(dataIn, dataFim, empresa);
        List<AjusteApuracaoIpi> ajustesCreditos = this.getAjustesOutrosCreditos(dataIn, dataFim, empresa);
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("dados", toRet);
        h.put("valorDebito", valorDebito);
        h.put("valorCredito", valorCredito);
        h.put("valorSaldoAnt", valorSaldoAnt);
        h.put("ajustesDebitos", ajustesDebitos);
        h.put("ajustesCreditos", ajustesCreditos);
        return h;
    }

    private Double getValorDebito(Date dataIn, Date dataFim, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = "select sum(lv.valorIpiIndustria) from LivroFiscal lv where lv.empresa =:empresa and  lv.dataLivro between :dataIn and :dataFim and (lv.cancelado=0 or lv.cancelado is null)";
        query = (String)query + " and (lv.entradaSaidaNaturezaOp=:op1) and (lv.cfop.codigo like '5%' or lv.cfop.codigo like '6%')";
        Query q = s.createQuery((String)query);
        q.setEntity("empresa", (Object)empresa);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setShort("op1", (short)1);
        Double vlr = (Double)q.uniqueResult();
        if (vlr == null) {
            vlr = 0.0;
        }
        return vlr;
    }

    private List<AjusteApuracaoIpi> getAjustesOutrosDebitos(Date dataIn, Date dataFim, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = "select sum(lv.valorIpiDevolucao) as VALOR_IPI_DEVOLUCAO,  n.identificador as ID_NOTA, n.numeroNota as NUMERO_NOTA from NotaFiscalPropria n   inner join n.livrosFiscais lv where lv.empresa =:empresa and  lv.dataLivro between :dataIn and :dataFim and (lv.cancelado=0 or lv.cancelado is null)";
        query = (String)query + " and (lv.entradaSaidaNaturezaOp=:op1) and (lv.cfop.codigo like '5%' or lv.cfop.codigo like '6%') group by n.identificador, n.numeroNota having sum(lv.valorIpiDevolucao) > 0 ";
        Query q = s.createQuery((String)query);
        q.setEntity("empresa", (Object)empresa);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setShort("op1", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        IndicadorOrigemIpi indicadorOrigem = this.getIndicadorOrigemAPI("3");
        CodigoAjusteIpi codigoAjuste = this.getCodigoAjusteApi("101");
        ArrayList<AjusteApuracaoIpi> ajustes = new ArrayList<AjusteApuracaoIpi>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            Double valorIpiDevolvido = (Double)h.get("VALOR_IPI_DEVOLUCAO");
            Integer numeroNota = (Integer)h.get("NUMERO_NOTA");
            AjusteApuracaoIpi a = new AjusteApuracaoIpi();
            a.setValorAjuste(valorIpiDevolvido);
            a.setDescricao("Estorno Credito IPI. Nota nr: " + numeroNota.toString());
            a.setNumeroDoc(numeroNota.toString());
            a.setTipoAjuste(Short.valueOf((short)0));
            a.setIndicadorOrigemIpi(indicadorOrigem);
            a.setCodigoAjusteIpi(codigoAjuste);
            a.setGerado(Short.valueOf((short)1));
            ajustes.add(a);
        }
        return ajustes;
    }

    private List<AjusteApuracaoIpi> getAjustesOutrosCreditos(Date dataIn, Date dataFim, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = "select sum(lv.valorIpiDevolucao) as VALOR_IPI_DEVOLUCAO,  n.identificador as ID_NOTA, n.numeroNota as NUMERO_NOTA from NotaFiscalPropria n   inner join n.livrosFiscais lv where lv.empresa =:empresa and  lv.dataLivro between :dataIn and :dataFim and (lv.cancelado=0 or lv.cancelado is null)";
        query = (String)query + "  and (lv.entradaSaidaNaturezaOp=:op1 or lv.entradaSaidaNaturezaOp=:op2) and (lv.cfop.codigo like '1%' or lv.cfop.codigo like '2%' or lv.cfop.codigo like '3%') group by n.identificador, n.numeroNota having sum(lv.valorIpiDevolucao) > 0 ";
        Query q = s.createQuery((String)query);
        q.setEntity("empresa", (Object)empresa);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setShort("op1", (short)2);
        q.setShort("op2", (short)0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        IndicadorOrigemIpi indicadorOrigem = this.getIndicadorOrigemAPI("3");
        CodigoAjusteIpi codigoAjuste = this.getCodigoAjusteApi("001");
        ArrayList<AjusteApuracaoIpi> ajustes = new ArrayList<AjusteApuracaoIpi>();
        for (Object ob : ret) {
            HashMap h = (HashMap)ob;
            Double valorIpiDevolvido = (Double)h.get("VALOR_IPI_DEVOLUCAO");
            Integer numeroNota = (Integer)h.get("NUMERO_NOTA");
            AjusteApuracaoIpi a = new AjusteApuracaoIpi();
            a.setValorAjuste(valorIpiDevolvido);
            a.setDescricao("Estorno Debito IPI. Nota nr: " + numeroNota.toString());
            a.setNumeroDoc(numeroNota.toString());
            a.setTipoAjuste(Short.valueOf((short)1));
            a.setIndicadorOrigemIpi(indicadorOrigem);
            a.setCodigoAjusteIpi(codigoAjuste);
            a.setGerado(Short.valueOf((short)1));
            ajustes.add(a);
        }
        return ajustes;
    }

    private Double getValorCredito(Date dataIn, Date dataFim, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = "select sum(lv.valorIpiIndustria + lv.valorIpiComercio) from LivroFiscal lv where lv.empresa =:empresa and  lv.dataLivro between :dataIn and :dataFim and (lv.cancelado=0 or lv.cancelado is null)";
        query = (String)query + " and (lv.entradaSaidaNaturezaOp=:op1 or lv.entradaSaidaNaturezaOp=:op2) and (lv.cfop.codigo like '1%' or lv.cfop.codigo like '2%' or lv.cfop.codigo like '3%')";
        Query q = s.createQuery((String)query);
        q.setEntity("empresa", (Object)empresa);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setShort("op1", (short)2);
        q.setShort("op2", (short)0);
        Double vlr = (Double)q.uniqueResult();
        if (vlr == null) {
            vlr = 0.0;
        }
        return vlr;
    }

    private List getResumoSaida(Date dataIn, Date dataFim, Short tpApuracao, Empresa empresa) throws ExceptionDatabase {
        AgrupamentoValorIpi a;
        HashMap h;
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = "select sum(lv.valorIpiIndustria+lv.valorIpiComercio) as VLR_IPI_INDUSTRIA, sum(lv.valorTotal ) as VALOR_CONTABIL, sum(lv.valorIpiTributado) as BASE_CALCULO, lv.incidenciaIpi.identificador as ID_INCIDENCIA_IPI, lv.cfop.identificador as ID_CFOP from LivroFiscal lv where lv.empresa =:empresa and  lv.dataLivro between :dataIn and :dataFim and (lv.cancelado=0 or lv.cancelado is null)";
        query = (String)query + " group by lv.incidenciaIpi.identificador,lv.cfop.identificador having sum(lv.valorIpiIndustria+lv.valorIpiComercio)>0 ";
        Query q = s.createQuery((String)query);
        q.setEntity("empresa", (Object)empresa);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List dados = q.list();
        ArrayList<AgrupamentoValorIpi> toRet = new ArrayList<AgrupamentoValorIpi>();
        for (Object o : dados) {
            h = (HashMap)o;
            a = new AgrupamentoValorIpi();
            a.setIncidenciaIpi((IncidenciaIpi)CoreDAOFactory.getInstance().getDAOIncidenciaIpi().findByPrimaryKey((Long)h.get("ID_INCIDENCIA_IPI")));
            a.setCfop((Cfop)CoreDAOFactory.getInstance().getDAOCfop().findByPrimaryKey((Long)h.get("ID_CFOP")));
            a.setBaseCalculo((Double)h.get("BASE_CALCULO"));
            a.setValorIpi((Double)h.get("VLR_IPI_INDUSTRIA"));
            a.setValorContabil((Double)h.get("VALOR_CONTABIL"));
            toRet.add(a);
        }
        query = "select sum(lv.valorIpiDevolucao) as VLR_IPI_DEVOLUCAO, sum(lv.valorTotal ) as VALOR_CONTABIL, sum(lv.valorIpiTributado) as BASE_CALCULO, lv.incidenciaIpi.identificador as ID_INCIDENCIA_IPI, lv.cfop.identificador as ID_CFOP from LivroFiscal lv where lv.empresa =:empresa and  lv.dataLivro between :dataIn and :dataFim and (lv.cancelado=0 or lv.cancelado is null)";
        query = (String)query + " group by lv.incidenciaIpi.identificador,lv.cfop.identificador having sum(lv.valorIpiDevolucao)>0 ";
        q = s.createQuery((String)query);
        q.setEntity("empresa", (Object)empresa);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        dados = q.list();
        for (Object o : dados) {
            h = (HashMap)o;
            a = new AgrupamentoValorIpi();
            a.setIncidenciaIpi((IncidenciaIpi)CoreDAOFactory.getInstance().getDAOIncidenciaIpi().findByPrimaryKey((Long)h.get("ID_INCIDENCIA_IPI")));
            a.setCfop((Cfop)CoreDAOFactory.getInstance().getDAOCfop().findByPrimaryKey((Long)h.get("ID_CFOP")));
            a.setBaseCalculo((Double)h.get("BASE_CALCULO"));
            a.setValorIpi((Double)h.get("VLR_IPI_DEVOLUCAO"));
            a.setValorContabil((Double)h.get("VALOR_CONTABIL"));
            toRet.add(a);
        }
        return toRet;
    }

    public List<ApuracaoIPI> findApuracoesPorDataAndEmpresa(Date data, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct a from ApuracaoIPI a where a.dataInicial >= :data and a.empresa = :empresa order by a.dataInicial");
        q.setDate("data", data);
        q.setEntity("empresa", (Object)empresa);
        List lista = q.list();
        return lista;
    }

    private IndicadorOrigemIpi getIndicadorOrigemAPI(String codigo) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct a  from IndicadorOrigemIpi a where a.codigo = :codigo");
        q.setString("codigo", codigo);
        q.setMaxResults(1);
        return (IndicadorOrigemIpi)q.uniqueResult();
    }

    private CodigoAjusteIpi getCodigoAjusteApi(String codigo) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct a  from CodigoAjusteIpi a where a.codigo = :codigo");
        q.setString("codigo", codigo);
        q.setMaxResults(1);
        return (CodigoAjusteIpi)q.uniqueResult();
    }
}

