/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.GrupoDeBaixa;
import com.touchcomp.basementor.model.vo.RetornoCnabCobranca;
import com.touchcomp.basementor.model.vo.Titulo;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;

public class DAOArquivoRetornoCnab
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return RetornoCnabCobranca.class;
    }

    public List<RetornoCnabCobranca> pesquisarRetornoCnabCobrancaPorTitulo(Titulo titulo) {
        Criteria criteria = CoreBdUtil.getInstance().getSession().createCriteria(RetornoCnabCobranca.class);
        criteria = criteria.createAlias("grupoBaixa", "grupoBaixa");
        criteria = criteria.createAlias("grupoBaixa.grupoDeBaixaFormas", "grupoFormas");
        criteria = criteria.createAlias("grupoFormas.baixaTitulo", "baixaTitulo");
        criteria.add((Criterion)Restrictions.eq((String)"baixaTitulo.titulo", (Object)titulo));
        return criteria.list();
    }

    public List<GrupoDeBaixa> findBaixaTitulosAntecipado(Titulo titulo) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "select distinct gb.grupoDeBaixa  from GrupoDeBaixaFormas gb  inner join gb.baixaTitulosAntecipados ba where ba.titulo.identificador =:idTitulo";
        Query q = s.createQuery(query);
        q.setLong("idTitulo", titulo.getIdentificador().longValue());
        return q.list();
    }
}

