/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.ArquivoSerasa;
import com.touchcomp.basementor.model.vo.TituloArquivoSerasa;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class DAOArquivoSerasa
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return ArquivoSerasa.class;
    }

    public List<TituloArquivoSerasa> pesquisarTituloPagos(Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT DISTINCT new TituloArquivoSerasa(b) FROM       BaixaTitulo          b INNER JOIN b.grupoDeBaixaFormas gbf INNER JOIN gbf.grupoDeBaixa     g INNER JOIN b.titulo             t INNER JOIN t.pessoa             p INNER JOIN p.endereco           e INNER JOIN e.cidade             c INNER JOIN c.uf                 u WHERE t.pagRec = :pagRec AND t.provisao = :provisao AND t.antecipado = :antecipado AND NOT EXISTS(SELECT tas FROM TituloArquivoSerasa tas WHERE tas.baixaTitulo = b) AND g.dataLiquidacao BETWEEN :dataInicial AND :dataFinal AND u.sigla <> 'EX'");
        q.setShort("pagRec", (short)1);
        q.setShort("provisao", (short)1);
        q.setShort("antecipado", (short)0);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        return q.list();
    }

    public List<TituloArquivoSerasa> pesquisarTituloAlterados(Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT DISTINCT new TituloArquivoSerasa(l) FROM LogTitulos                  l LEFT JOIN l.titulo               t LEFT JOIN t.pessoa               p LEFT JOIN p.endereco             e LEFT JOIN e.cidade               c LEFT JOIN c.uf                   u INNER JOIN l.tipoAlteracaoTitulo a WHERE (l.titulo IS NULL OR t.pagRec = :pagRec AND t.provisao = :provisao AND t.antecipado = :antecipado) AND (a.codigo = :codigoDataVencimento OR a.codigo = :codigoValor OR a.codigo = :codigoExclusao) AND NOT EXISTS(SELECT tas FROM TituloArquivoSerasa tas WHERE tas.logTitulos = l) AND l.dataCadastro BETWEEN :dataInicial AND :dataFinal AND u.sigla <> 'EX'");
        q.setShort("pagRec", (short)1);
        q.setShort("provisao", (short)1);
        q.setShort("antecipado", (short)0);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setString("codigoDataVencimento", "00");
        q.setString("codigoValor", "01");
        q.setString("codigoExclusao", "03");
        return q.list();
    }

    public List<TituloArquivoSerasa> pesquisarTituloEmitidos(Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT DISTINCT new TituloArquivoSerasa(t) FROM       Titulo     t INNER JOIN t.pessoa   p INNER JOIN p.endereco e INNER JOIN e.cidade   c INNER JOIN c.uf       u WHERE t.pagRec = :pagRec AND t.provisao = :provisao AND t.antecipado = :antecipado AND NOT EXISTS(SELECT tas FROM TituloArquivoSerasa tas WHERE tas.titulo = t) AND t.dataEmissao BETWEEN :dataInicial AND :dataFinal AND u.sigla <> 'EX'");
        q.setShort("pagRec", (short)1);
        q.setShort("provisao", (short)1);
        q.setShort("antecipado", (short)0);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        return q.list();
    }

    public Long pesquisarTituloDoTituloExcluido(Long titulo) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT t.identificador FROM Titulo t WHERE t.identificador = :titulo");
        q.setLong("titulo", titulo.longValue());
        return (Long)q.uniqueResult();
    }

    public Object[] pesquisarBaixaDoTitulo(Long titulo, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT g.dataLiquidacao, t.carteiraCobranca.diasToleranciaVencimento FROM BaixaTitulo b INNER JOIN b.titulo t INNER JOIN b.grupoDeBaixaFormas gbf INNER JOIN gbf.grupoDeBaixa g WHERE t.identificador = :titulo AND g.dataLiquidacao <= :dataFinal ORDER BY b.identificador DESC");
        q.setLong("titulo", titulo.longValue());
        q.setDate("dataFinal", dataFinal);
        if (q.list() != null && q.list().size() > 0) {
            return (Object[])q.list().get(0);
        }
        return null;
    }
}

