/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.AverbacaoCte;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.EvtCTeCancelamento;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class DAOAverbacaoCte
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return AverbacaoCte.class;
    }

    public List<Cte> pesquisarCteAprovadosParaAverbar(Long idInicial) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct c FROM Cte c left JOIN c.averbacaoCte a WHERE c.identificador >= :idInicial AND (c.cteInfo.status = :aprovado) AND a.identificador is null AND c.gerarAverbacao = :gerarAverbacao order by c.identificador");
        q.setLong("idInicial", idInicial.longValue());
        q.setShort("aprovado", (short)100);
        q.setShort("gerarAverbacao", (short)1);
        q.setMaxResults(50);
        return q.list();
    }

    public List<EvtCTeCancelamento> pesquisarCteCanceladosParaAverbar(Long idInicial) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT DISTINCT e FROM EvtCTeCancelamento e inner join e.cte c left JOIN c.averbacaoCte a WHERE c.identificador >= :idInicial AND c.cteInfo.status = :cancelado and a.tipoAverbacao <> :averbacao_cancelada AND c.gerarAverbacao = :gerarAverbacao order by e.identificador");
        q.setLong("idInicial", idInicial.longValue());
        q.setShort("averbacao_cancelada", (short)1);
        q.setShort("cancelado", (short)101);
        q.setShort("gerarAverbacao", (short)1);
        q.setMaxResults(50);
        return q.list();
    }

    public Long pesquisarErroAverbacaoPorCte(Long identificador, Short tipoAverbacao) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT a.identificador FROM ErroAverbacaoCte a WHERE a.cte.identificador = :identificador AND a.tipoAverbacao = :tipoAverbacao");
        q.setLong("identificador", identificador.longValue());
        q.setShort("tipoAverbacao", tipoAverbacao.shortValue());
        return (Long)q.uniqueResult();
    }

    public void deleteErrosPorCte(Long identificador) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "DELETE FROM ErroAverbacaoCte e WHERE e.cte.identificador = :identificador ";
        Query q = s.createQuery(query);
        q.setLong("identificador", identificador.longValue());
        q.executeUpdate();
    }
}

