/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.BaixaBem;
import com.touchcomp.basementor.model.vo.Bem;
import com.touchcomp.basementor.model.vo.DepreciacaoBem;
import contatocore.util.ContatoDateUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DAOBaixaBem
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return BaixaBem.class;
    }

    public List<DepreciacaoBem> findDepreciacoesBem(Bem bem) {
        Session session = CoreBdUtil.getInstance().getSession();
        Criteria criteria = session.createCriteria(DepreciacaoBem.class);
        criteria = criteria.createAlias("bemTipoDepreciacao", "bemTipoDepreciacao");
        criteria = criteria.createAlias("bemTipoDepreciacao.bem", "bem");
        criteria.add((Criterion)Restrictions.eq((String)"bem.identificador", (Object)bem.getIdentificador()));
        criteria.addOrder(Order.asc((String)"identificador"));
        return criteria.list();
    }

    public Double getValorTotalDepreciacaoBem(Bem bem) {
        Session session = CoreBdUtil.getInstance().getSession();
        Criteria criteria = session.createCriteria(DepreciacaoBem.class);
        criteria = criteria.createAlias("bemTipoDepreciacao", "bemTipoDepreciacao");
        criteria = criteria.createAlias("bemTipoDepreciacao.bem", "bem");
        ProjectionList projection = Projections.projectionList();
        projection.add(Projections.sum((String)"valorDepreciacao").as("VALOR_DEPRECIACAO"));
        projection.add(Projections.sum((String)"valorDeprecAcelerada").as("VALOR_DEPRECIACAO_ACELERADA"));
        criteria.setProjection((Projection)projection);
        criteria.add((Criterion)Restrictions.eq((String)"bem.identificador", (Object)bem.getIdentificador()));
        criteria.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        Double valorTotal = 0.0;
        HashMap result = (HashMap)criteria.uniqueResult();
        if (result != null) {
            valorTotal = valorTotal + (Double)(result.get("VALOR_DEPRECIACAO") != null ? result.get("VALOR_DEPRECIACAO") : Double.valueOf(0.0));
            valorTotal = valorTotal + (Double)(result.get("VALOR_DEPRECIACAO_ACELERADA") != null ? result.get("VALOR_DEPRECIACAO_ACELERADA") : Double.valueOf(0.0));
        }
        return valorTotal;
    }

    public Double getSaldoBaixaDisponivel(Bem bem) {
        Session session = CoreBdUtil.getInstance().getSession();
        Criteria criteria = session.createCriteria(BaixaBem.class);
        criteria = criteria.createAlias("bem", "bem");
        criteria.setProjection((Projection)Projections.sum((String)"percentualBaixa"));
        criteria.add((Criterion)Restrictions.eq((String)"bem.identificador", (Object)bem.getIdentificador()));
        Double saldoBaixado = (Double)criteria.uniqueResult();
        return saldoBaixado != null ? 100.0 - saldoBaixado : 100.0;
    }

    public Double getSaldoBaixaDisponivel(Bem bem, Date periodo) {
        Session session = CoreBdUtil.getInstance().getSession();
        Criteria criteria = session.createCriteria(BaixaBem.class);
        criteria = criteria.createAlias("bem", "bem");
        criteria.setProjection((Projection)Projections.sum((String)"percentualBaixa"));
        criteria.add((Criterion)Restrictions.eq((String)"bem.identificador", (Object)bem.getIdentificador()));
        criteria.add((Criterion)Restrictions.le((String)"dataBaixa", (Object)ContatoDateUtil.nextPreviousDays((Date)periodo, (int)1)));
        Double saldoBaixado = (Double)criteria.uniqueResult();
        return saldoBaixado != null ? 100.0 - saldoBaixado : 100.0;
    }

    public List<BaixaBem> gerarListagemBaixasBens(Short filtrarDataBaixa, Date dataInicial, Date dataFinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short filtrarBem, Long bemInicial, Long bemFinal) {
        Session session = CoreBdUtil.getInstance().getSession();
        Criteria criteria = session.createCriteria(BaixaBem.class);
        criteria = criteria.createAlias("bem", "bem");
        criteria = criteria.createAlias("empresa", "empresa");
        criteria.add(Restrictions.isNull((String)"baixaBemPrincipal"));
        if (filtrarDataBaixa != null && filtrarDataBaixa == 1) {
            criteria.add(Restrictions.between((String)"dataBaixa", (Object)dataInicial, (Object)dataFinal));
        }
        if (filtrarEmpresa != null && filtrarEmpresa == 1) {
            criteria.add(Restrictions.between((String)"empresa.identificador", (Object)empresaInicial, (Object)empresaFinal));
        }
        if (filtrarBem != null && filtrarBem == 1) {
            criteria.add(Restrictions.between((String)"bem.identificador", (Object)bemInicial, (Object)bemFinal));
        }
        return criteria.list();
    }
}

