/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.BorderoPagamento;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.ItemBorderoPagamento;
import com.touchcomp.basementor.model.vo.Titulo;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class DAOBorderoPagamento
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return BorderoPagamento.class;
    }

    public List<Titulo> findTitulosByVencimento(Date dataVencInicial, Date dataVencFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "from Titulo t  where t.dataVencimento between :dataVencInicial  and :dataVencFinal  and t.pagRec    = :pagRec  and t.provisao  = :prov  and t not in (select b.titulo                from BaixaTitulo b                where b.titulo.pagRec = :pagRec                and b.titulo.provisao  = :prov                and b.titulo.dataVencimento between :dataVencInicial  and :dataVencFinal) ";
        Query q = s.createQuery(query);
        q.setDate("dataVencInicial", dataVencInicial);
        q.setDate("dataVencFinal", dataVencFinal);
        q.setShort("pagRec", (short)0);
        q.setShort("prov", (short)1);
        return q.list();
    }

    public void atualizarCarteiraTitBordero(BorderoPagamento borderoPagamento, CarteiraCobranca carteira) {
        Session s = CoreBdUtil.getInstance().getSession();
        String st = " update Titulo t  set t.carteiraCobranca=:carteira  where t = :titulo";
        Query q = s.createQuery(st);
        q.setEntity("carteira", (Object)carteira);
        for (ItemBorderoPagamento item : borderoPagamento.getItemBordero()) {
            Titulo tit = null;
            tit = item.getItemLiberacao() != null ? item.getItemLiberacao().getTitulo() : item.getTitulo();
            q.setEntity("titulo", (Object)tit);
            q.executeUpdate();
        }
    }

    public List<BorderoPagamento> getItensBorderoPagamento(Titulo titulo) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = " select distinct bp  from BorderoPagamento bp  inner join bp.itemBordero item  left join item.titulo tt  left join item.itemLiberacao il  where (il.titulo = :titulo or tt = :titulo) ";
        Query q = s.createQuery(query);
        q.setEntity("titulo", (Object)titulo);
        return q.list();
    }

    public BorderoPagamento salvarBorderoPagamento(List<Titulo> titulosRemovidos, BorderoPagamento bordero) throws ExceptionService {
        if (titulosRemovidos != null && !titulosRemovidos.isEmpty()) {
            CoreService.simpleSaveCollection(CoreDAOFactory.getInstance().getDAOTitulo(), titulosRemovidos);
        }
        return (BorderoPagamento)CoreService.simpleSave(CoreDAOFactory.getInstance().getDAOBorderoPagamento(), bordero);
    }
}

