/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.CadastroConvencaoColetiva;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Sindicato;
import com.touchcomp.basementor.model.vo.SindicatoConvecaoColetiva;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class DAOCadastroConvencaoColetiva
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return CadastroConvencaoColetiva.class;
    }

    public CadastroConvencaoColetiva lastConvencaoColetivaPorSindicato(Sindicato sindicato, Date data) {
        String hql = " select convencao  from CadastroConvencaoColetiva convencao  inner join convencao.sindicatoConvencao sind  where  sind.sindicato.identificador = :sindicato  and  convencao.dataLiberacao = ( select max(conv.dataLiberacao)                              from CadastroConvencaoColetiva conv                               inner join conv.sindicatoConvencao s                              where                              s.sindicato = sind.sindicato                                )";
        return (CadastroConvencaoColetiva)CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("sindicato", sindicato.getIdentificador().longValue()).setMaxResults(1).uniqueResult();
    }

    public List findFuncaoPorConvencao(List sindicatos, Empresa empresa, Date data) {
        Object hql = " select distinct c.funcao  from ColaboradorSalario c where  c.colaborador.ativo = :sim  and  (c.colaborador.dataDemissao is null or c.colaborador.dataDemissao > :data) and c.periodo = (select max(cc.periodo)                     from ColaboradorSalario cc                    where (cc.periodo <= :data) and cc.colaborador.identificador = c.colaborador.identificador)  and ( ";
        Integer count = 1;
        Integer tam = sindicatos.size();
        for (Object obj : sindicatos) {
            SindicatoConvecaoColetiva sindicato = (SindicatoConvecaoColetiva)obj;
            hql = (String)hql + " c.colaborador.sindicato.identificador = :idSindicato" + count;
            if (count < tam) {
                hql = (String)hql + " or ";
            }
            count = count + 1;
        }
        hql = (String)hql + " )";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery((String)hql);
        q.setDate("data", data);
        q.setShort("sim", (short)1);
        count = 1;
        for (Object obj : sindicatos) {
            SindicatoConvecaoColetiva sindicato = (SindicatoConvecaoColetiva)obj;
            q.setLong("idSindicato" + count.toString(), sindicato.getSindicato().getIdentificador().longValue());
        }
        return q.list();
    }

    public List findColaboradoresAtSalarialConvencao(List sindicatos, Empresa empresa, Date data) {
        Object hql = " select distinct c  from ColaboradorSalario c where  c.colaborador.ativo = :sim  and  (c.colaborador.dataDemissao is null or c.colaborador.dataDemissao > :data) and c.periodo = (select max(cc.periodo)                     from ColaboradorSalario cc                    where (cc.periodo <= :data) and cc.colaborador.identificador = c.colaborador.identificador)  and ( ";
        Integer count = 1;
        Integer tam = sindicatos.size();
        for (Object obj : sindicatos) {
            SindicatoConvecaoColetiva sindicato = (SindicatoConvecaoColetiva)obj;
            hql = (String)hql + " c.colaborador.sindicato.identificador = :idSindicato" + count;
            if (count < tam) {
                hql = (String)hql + " or ";
            }
            count = count + 1;
        }
        hql = (String)hql + " )";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery((String)hql);
        q.setDate("data", data);
        q.setShort("sim", (short)1);
        count = 1;
        for (Object obj : sindicatos) {
            SindicatoConvecaoColetiva sindicato = (SindicatoConvecaoColetiva)obj;
            q.setLong("idSindicato" + count.toString(), sindicato.getSindicato().getIdentificador().longValue());
        }
        return q.list();
    }
}

