/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.CadastroEventoConsignado;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DAOCadastroEventoConsignado
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return CadastroEventoConsignado.class;
    }

    public Double findReferenciaAnteriorConsignado(MovimentoFolha mov) {
        Colaborador c = mov.getColaborador();
        Date periodoInicial = mov.getAberturaPeriodo().getDataInicio();
        Date periodoFinal = mov.getAberturaPeriodo().getDataFinal();
        String hql = " select item.referencia as referencia , max(item.movimentoFolha.aberturaPeriodo.dataPagamento) as maxData  from ItemMovimentoFolha item  where  item.movimentoFolha.colaborador.identificador = :colaborador  and  item.eventoColaborador.tipoCalculoEvento in  (select consignado.eventoConsignado                                               from CadastroEventoConsignado consignado                                               where                                               consignado.colaborador.identificador = :colaborador                                               and                                               ((consignado.dataInicioDesconto >= :periodoInicial                                               and                                               consignado.dataFinalDesconto <= :periodoFinal)                                                or                                               (consignado.dataInicioDesconto <= :periodoInicial                                               and                                               consignado.dataFinalDesconto >= :periodoFinal)))  group by item.referencia, item.movimentoFolha.aberturaPeriodo.dataPagamento";
        List lista = CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("colaborador", c.getIdentificador().longValue()).setDate("periodoInicial", periodoInicial).setDate("periodoFinal", periodoFinal).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        if (lista == null || lista.isEmpty()) {
            return this.getPrimeiraReferencia(c, periodoInicial, periodoFinal);
        }
        HashMap h = (HashMap)lista.get(lista.size() - 1);
        Double referencia = (Double)h.get("referencia");
        return referencia > 0.0 ? referencia + 1.0 : this.getPrimeiraReferencia(c, periodoInicial, periodoFinal);
    }

    private Double getPrimeiraReferencia(Colaborador c, Date periodoInicial, Date periodoFinal) {
        String hql = "   select consignado.dataInicioDesconto as iniParcela , consignado.nrParcelas as nrParcela       from CadastroEventoConsignado consignado       where       consignado.colaborador = :colaborador       and       ((consignado.dataInicioDesconto >= :periodoInicial       and       consignado.dataFinalDesconto <= :periodoFinal)        or       (consignado.dataInicioDesconto <= :periodoInicial       and       consignado.dataFinalDesconto >= :periodoFinal)) ";
        HashMap h = (HashMap)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)c).setDate("periodoInicial", periodoInicial).setDate("periodoFinal", periodoFinal).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).uniqueResult();
        if (h != null) {
            Integer fim = (Integer)h.get("nrParcela");
            Object fi = fim < 10 ? "0" + fim.toString() : fim.toString();
            String aux = "1." + (String)fi;
            return Double.valueOf(aux);
        }
        return 0.0;
    }
}

