/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoMedias;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.CalculoComplementoSalario;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Sindicato;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DAOCalculoComplementoSalario
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return CalculoComplementoSalario.class;
    }

    public List findTipoCalculoIncideInss(Date dataInicial, Date dataFinal) {
        List ret = new ArrayList();
        String hql = " from TipoCalculoEvento tp  where  tp.compoeDissidioColetivo = :sim  and  exists(select item.identificador         from ItemMovimentoFolha item         where         item.movimentoFolha.aberturaPeriodo.dataInicio between :dataInicio and :dataFinal        and         item.movimentoFolha.statusFolha.codigo = :folhaNormal         and         item.eventoColaborador.tipoCalculoEvento = tp         and         (item.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento         or         item.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :decimoTerceiro))";
        ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("sim", (short)1).setDate("dataInicio", dataInicial).setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).setShort("decimoTerceiro", EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue().shortValue()).setDate("dataFinal", dataFinal).setShort("folhaNormal", (short)1).list();
        return ret;
    }

    public List findEventosInicidentes13(Date dataInicial, Date dataFinal) {
        String hql = " from TipoCalculoEvento tp  where  (tp.media13Salario = :valor or tp.media13Salario = :referencia )  and  exists(select item.identificador         from ItemMovimentoFolha item         where         item.movimentoFolha.aberturaPeriodo.dataInicio between :dataInicio and :dataFinal        and         item.movimentoFolha.statusFolha.codigo = :folhaNormal         and         item.eventoColaborador.tipoCalculoEvento = tp         and         item.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento)";
        List ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("valor", EnumConstEventoMedias.MEDIA_VALOR.getValue()).setShort("referencia", EnumConstEventoMedias.MEDIA_REFERENCIA.getValue()).setDate("dataInicio", dataInicial).setDate("dataFinal", dataFinal).setShort("folhaNormal", (short)1).setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).list();
        return ret;
    }

    public List findColaboradoresComFolhaNoPeriodo(Long idEmpresa, Date periodoFinal, Short filtrarSindicato, Sindicato sindicato) {
        List colaboradores = new ArrayList();
        if (sindicato != null) {
            String hql = " select c  from Colaborador c  where  c.ativo = :sim  and  c.dataAdmissao < :dataFinal   and  c.empresa.identificador between :idEmpresaInicial and :idEmpresaFinal  and  c.dataDemissao is null  and  (:filtrarSindicato = 0 or c.sindicato = :sindicato) ";
            colaboradores = CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("dataFinal", periodoFinal).setLong("idEmpresaInicial", idEmpresa.longValue()).setLong("idEmpresaFinal", idEmpresa.longValue()).setShort("sim", (short)1).setShort("filtrarSindicato", filtrarSindicato.shortValue()).setEntity("sindicato", (Object)sindicato).list();
        } else {
            String hql = " select c  from Colaborador c  where  c.ativo = :sim  and  c.dataAdmissao < :dataFinal   and  c.empresa.identificador between :idEmpresaInicial and :idEmpresaFinal  and  c.dataDemissao is null ";
            colaboradores = CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("dataFinal", periodoFinal).setLong("idEmpresaInicial", idEmpresa.longValue()).setLong("idEmpresaFinal", idEmpresa.longValue()).setShort("sim", (short)1).list();
        }
        return colaboradores;
    }

    public List getEventosCompoemComplementoDecimoTerceiro(TipoCalculoEvento tipoCalculo, Date periodoInicial, Date periodoFinal) {
        List ret = new ArrayList();
        String hql = " select  item.valor as valor ,  item.eventoColaborador.colaborador.identificador as idColaborador,  item.movimentoFolha.aberturaPeriodo.dataInicio as periodo  from ItemMovimentoFolha item  where  item.eventoColaborador.tipoCalculoEvento = :tipoCalculo  and  item.eventoColaborador.eventoFixo = :nao  and  item.movimentoFolha.aberturaPeriodo.dataInicio between :periodoInicio and :periodoFinal  and  item.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento ";
        ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("nao", (short)0).setEntity("tipoCalculo", (Object)tipoCalculo).setDate("periodoInicio", periodoInicial).setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).setDate("periodoFinal", periodoFinal).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        return ret;
    }

    public List findEventoComplementosSalarioPorPeriodo(CalculoComplementoSalario vo, Short filtrarCentroCusto, String codCentroCustoInicial, String codCentroCustoFinal) {
        String hql = " select  item.colaborador.pessoa.nome as Colaborador,  item.colaborador.centroCusto.nome as centroCusto,  item.colaborador.dataAdmissao as DATA_ADMISSAO , item.colaborador.numeroRegistro as Registro,  item.itemEvento.tipoCalculo.evento.descricao as evento,  item.itemEvento.tipoCalculo.evento.codigo as codigoEvento, item.itemEvento.tipoCalculo.evento.tipoEvento as TIPO_EVENTO,  item.periodo as periodo,  item.valorEvento as valorEvento,  item.valorComplemento as valorComplemento,  cast(item.percAumento as double) as percAumento , item.avos as avos , item.itemEvento.complementoSalario.tipoCalculoFolha.tipoFolha as tipoFolha  from ItemCompSalarioEventoPeriodo item  where item.itemEvento.complementoSalario = :complementoSalario  and (:filtrarCentroCusto <> 1 OR item.colaborador.centroCusto.codigo BETWEEN :codCentroCustoInicial and :codCentroCustoFinal)  order by item.colaborador.pessoa.nome , item.periodo ,item.itemEvento.tipoCalculo.evento.codigo";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("complementoSalario", (Object)vo).setShort("filtrarCentroCusto", filtrarCentroCusto.shortValue()).setString("codCentroCustoInicial", codCentroCustoInicial).setString("codCentroCustoFinal", codCentroCustoFinal).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
    }

    public List getItensComplementoSalario(Date dataPagamento, Colaborador colaborador) {
        String hql = " from FolhaComplementarPeriodo folhaComp  where  folhaComp.pagamentoComplementar.colaborador = :colaborador  and  folhaComp.pagamentoComplementar.calculoComplementoSalario.dataPagamento = :dataPagamento  and  folhaComp.pagamentoComplementar.calculoComplementoSalario.tipoCalculoFolha.tipoFolha = :complementoSalario";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setShort("complementoSalario", EnumConstTipoCalculoEvento.CALCULO_FOLHA_COMPLEMENTAR.getValue().shortValue()).setDate("dataPagamento", dataPagamento).list();
    }

    public List getItensComplementoDecimoTerceiro(Date dataPagamento, Colaborador colaborador) {
        String hql = " from ItemCompSalarioEventoPeriodo item  where  item.colaborador = :colaborador  and  item.itemEvento.complementoSalario.dataPagamento = :dataPagamento  and  item.itemEvento.complementoSalario.tipoCalculoFolha.tipoFolha = :complementoDec ";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setShort("complementoDec", EnumConstTipoCalculoEvento.CALCULO_FOLHA_COMPLEMENTAR_DEC.getValue().shortValue()).setDate("dataPagamento", dataPagamento).list();
    }

    public List getEventosCompoemComplementoDecimoTerceiro(TipoCalculoEvento tipoCalculo, Integer ano, Date periodoInicial, Date periodoFinal) {
        List ret = new ArrayList();
        String hql = " select  item.valor as valor ,  item.eventoColaborador.colaborador.identificador as idColaborador,  item.movimentoFolha.aberturaPeriodo.dataInicio as periodo  from ItemMovimentoFolha item  where  item.eventoColaborador.tipoCalculoEvento = :tipoCalculo  and  extract(year from item.movimentoFolha.aberturaPeriodo.dataInicio) = :ano  and  item.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaDec ";
        ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("folhaDec", EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue().shortValue()).setEntity("tipoCalculo", (Object)tipoCalculo).setInteger("ano", ano.intValue()).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        return ret;
    }

    public List getEventosCompoemComplementoSalario(TipoCalculoEvento tipoCalculo, Date periodoInicial, Date periodoFinal) {
        List eventosNormais = new ArrayList();
        ArrayList eventos = new ArrayList();
        List eventosFerias = new ArrayList();
        String hqlEventosNormais = "  select  item.valor as valor ,  item.eventoColaborador.colaborador.identificador as idColaborador,  item.movimentoFolha.aberturaPeriodo.dataInicio as periodo  from ItemMovimentoFolha item  left join  item.itemFeriasFolha iferias  left join  iferias.itemFerias itemferias  left join itemferias.ferias f  where  item.eventoColaborador.tipoCalculoEvento = :tipoCalculo  and  item.movimentoFolha.aberturaPeriodo.dataInicio between :periodoInicio and :periodoFinal  and  item.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento  and  (iferias is null  or  f.dataPagamento < :periodoInicio  or  (f.dataGozoInicial >= :periodoInicio and f.dataGozoFinal <= :periodoFinal ) ) ";
        eventosNormais = CoreBdUtil.getInstance().getSession().createQuery(hqlEventosNormais).setEntity("tipoCalculo", (Object)tipoCalculo).setDate("periodoInicio", periodoInicial).setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).setDate("periodoFinal", periodoFinal).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        String hqlEventosFerias = " select  item.itemFeriasFolha.itemFerias.valor as valor ,  item.eventoColaborador.colaborador.identificador as idColaborador,  item.movimentoFolha.aberturaPeriodo.dataInicio as periodo  from ItemMovimentoFolha item  where  item.eventoColaborador.tipoCalculoEvento = :tipoCalculo  and  item.movimentoFolha.aberturaPeriodo.dataInicio between :periodoInicio and :periodoFinal  and  item.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento  and  item.itemFeriasFolha is not null  and   item.itemFeriasFolha.itemFerias.ferias.dataPagamento >= :periodoInicio  and  item.itemFeriasFolha.itemFerias.ferias.dataGozoInicial < :periodoFinal  and  item.itemFeriasFolha.itemFerias.ferias.dataGozoFinal > :periodoFinal ";
        eventosFerias = CoreBdUtil.getInstance().getSession().createQuery(hqlEventosFerias).setEntity("tipoCalculo", (Object)tipoCalculo).setDate("periodoInicio", periodoInicial).setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).setDate("periodoFinal", periodoFinal).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        if (!eventosNormais.isEmpty()) {
            eventos.addAll(eventosNormais);
        }
        if (!eventosFerias.isEmpty()) {
            eventos.addAll(eventosFerias);
        }
        return eventos;
    }
}

