/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.ChequeTerceiros;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.CoreRequestContext;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class DAOChequeDeTerceiros
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return ChequeTerceiros.class;
    }

    public List verificarDadosCheque(CoreRequestContext request) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("from ChequeTerceiros c where c.numero = :numero and c.agencia = :agencia  and c.contaCorrente = :conta and c.banco = :banco");
        q.setInteger("numero", ((Integer)request.getAttribute("numero")).intValue());
        q.setString("agencia", (String)request.getAttribute("agencia"));
        q.setString("conta", (String)request.getAttribute("conta"));
        q.setString("banco", (String)request.getAttribute("banco"));
        return q.list();
    }

    public List verificaBordero(CoreRequestContext request) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "select distinct b from BorderoChequeTerceirosMovBancario b inner join b.chequeTerceiros c where c.identificador = :id";
        Query q = s.createQuery(query);
        q.setLong("id", ((Long)request.getAttribute("idChequeTerceiros")).longValue());
        return q.list();
    }

    public List verificarChequeTerceiros(Pessoa pessoa, Date dataInicial, Date dataFinal, Empresa empresa, Short pedidosGrupoPessoa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "SELECT  distinct c FROM ChequeTerceiros c INNER JOIN c.pessoa p left join p.grupoPessoas gp WHERE ((0 = :pedidosGrupoPessoa and p.identificador = :pessoa) ";
        hql = pessoa.getGrupoPessoas() != null && pedidosGrupoPessoa == 1 ? (String)hql + " or (1 = :pedidosGrupoPessoa and gp.identificador = :grupoPessoa))" : (pessoa.getGrupoPessoas() == null && pedidosGrupoPessoa == 1 ? (String)hql + " or (1 = :pedidosGrupoPessoa and  p.identificador = :pessoa))" : (String)hql + " )");
        hql = (String)hql + " AND c.dataEntrada BETWEEN :dataInicial AND :dataFinal AND c.empresa = :empresa";
        Query q = s.createQuery((String)hql);
        q.setShort("pedidosGrupoPessoa", pedidosGrupoPessoa.shortValue());
        q.setEntity("pessoa", (Object)pessoa);
        if (pessoa.getGrupoPessoas() != null && pedidosGrupoPessoa == 1) {
            q.setEntity("grupoPessoa", (Object)pessoa.getGrupoPessoas());
        }
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        return q.list();
    }

    public List findChequeTerceiros(Long idChequeTerceiros) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("FROM ChequeTerceiros c WHERE c.identificador = :idChequeTerceiros");
        q.setLong("idChequeTerceiros", idChequeTerceiros.longValue());
        return q.list();
    }

    public Double saldoChequesNaoCompensados(Long idPessoa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT  sum(c.valor) FROM ChequeTerceiros c INNER JOIN c.pessoa p left JOIN c.grupoDeBaixaFormasPag g left JOIN c.compensacaoCheque cc left JOIN cc.tipoCompensacaoChTerceiros tc left JOIN c.baixaChequeTerceiros dv WHERE p.identificador = :pessoa AND cc is null AND g is null and ( tc is null or tc.codigo != :tipoCompensacao)");
        q.setLong("pessoa", idPessoa.longValue());
        q.setShort("tipoCompensacao", (short)2);
        Double ret = (Double)q.uniqueResult();
        ret = ret == null ? 0.0 : ret;
        return ret;
    }

    public Double saldoChequesNaoCompensadosGrupoPessoa(Long idGrupoPessoa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT  sum(c.valor) FROM ChequeTerceiros c INNER JOIN c.pessoa p inner join p.grupoPessoas g left JOIN c.grupoDeBaixaFormasPag g left JOIN c.compensacaoCheque cc left JOIN cc.tipoCompensacaoChTerceiros tc left JOIN c.baixaChequeTerceiros dv WHERE g.identificador = :pessoa AND cc is null AND g is null and tc.codigo != :tipoCompensacao");
        q.setLong("pessoa", idGrupoPessoa.longValue());
        q.setShort("tipoCompensacao", (short)2);
        Double ret = (Double)q.uniqueResult();
        ret = ret == null ? 0.0 : ret;
        return ret;
    }

    public Double saldoChequesDevolvidosGrupoPessoas(Long idGrupoPessoa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT  sum(c.valor) FROM ChequeTerceiros c inner JOIN c.compensacaoCheque cc inner JOIN cc.tipoCompensacaoChTerceiros t inner JOIN c.pessoa p inner JOIN p.grupoPessoas g left JOIN c.baixaChequeTerceiros dv WHERE g.identificador = :pessoa AND (t.codigo = :devolvido) and dv is null and cc.titulo is null");
        q.setLong("pessoa", idGrupoPessoa.longValue());
        q.setShort("devolvido", (short)2);
        Double ret = (Double)q.uniqueResult();
        ret = ret == null ? 0.0 : ret;
        return ret;
    }

    public Double saldoChequesDevolvidos(Long idPessoa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT  sum(c.valor) FROM ChequeTerceiros c inner JOIN c.compensacaoCheque cc inner JOIN cc.tipoCompensacaoChTerceiros t inner JOIN c.pessoa p left JOIN c.baixaChequeTerceiros dv WHERE p.identificador = :pessoa AND (t.codigo = :devolvido) and dv is null and cc.titulo is null");
        q.setLong("pessoa", idPessoa.longValue());
        q.setShort("devolvido", (short)2);
        Double ret = (Double)q.uniqueResult();
        ret = ret == null ? 0.0 : ret;
        return ret;
    }

    public List findChquesTerceirosNaoCompByDataVenc(Date dataVencimentoInicial, Date dataVencimentoFinal, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct ch FROM ChequeTerceiros ch left JOIN ch.grupoDeBaixaFormasPag g left JOIN ch.compensacaoCheque cc left JOIN cc.tipoCompensacaoChTerceiros t left JOIN ch.baixaChequeTerceiros dv WHERE ch.dataVencimento BETWEEN :dataVencimentoInicial AND :dataVencimentoFinal AND (cc is null) AND (g is null) AND (dv is null) AND ch.empresa = :empresa");
        q.setDate("dataVencimentoInicial", dataVencimentoInicial);
        q.setDate("dataVencimentoFinal", dataVencimentoFinal);
        q.setEntity("empresa", (Object)empresa);
        return q.list();
    }

    public void deleteChequeTerceirosueTerceiros(ChequeTerceiros c) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("UPDATE ChequeTerceiros c SET c.grupoDeBaixaFormasRec = NULL WHERE c = :cheque");
        q.setEntity("cheque", (Object)c);
        q.executeUpdate();
    }

    public void deleteChequeTerceirosueTerceirosPag(ChequeTerceiros c) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("UPDATE ChequeTerceiros c SET c.grupoDeBaixaFormasPag = NULL WHERE c = :cheque");
        q.setEntity("cheque", (Object)c);
        q.executeUpdate();
    }
}

