/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DAOCidade
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return Cidade.class;
    }

    public Cidade findCidadeCodMunicipio(String codigoMunicipio) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("FROM Cidade c WHERE c.codIbgeCompleto = :codigoMunicipio");
        q.setString("codigoMunicipio", codigoMunicipio);
        q.setMaxResults(1);
        return (Cidade)q.uniqueResult();
    }

    public List findCidade(UnidadeFederativa uf) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "from Cidade c where c.uf = :uf order by c.descricao";
        Query q = s.createQuery(hql);
        q.setEntity("uf", (Object)uf);
        return q.list();
    }

    public Cidade buscarCidade(String cep) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("FROM Cidade c WHERE c.cep = :cep");
        q.setString("cep", cep);
        return (Cidade)q.uniqueResult();
    }

    public Object findCidadesSincronizacaoDadosCupom(Timestamp ultimaSincronizacao) {
        Object hql = "select un.identificador as ID_CIDADE, un.codIbge as COD_IBGE, un.descricao as DESCRICAO, un.uf.identificador as ID_UF from Cidade un ";
        if (ultimaSincronizacao != null) {
            hql = (String)hql + " where un.dataAtualizacao >= :ultimaSincronizacao";
        }
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
        if (ultimaSincronizacao != null) {
            q.setTimestamp("ultimaSincronizacao", (Date)ultimaSincronizacao);
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public Cidade findCidadePorId(Integer idCidade) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select c from Cidade c where c.identificador = :idCidade").setInteger("idCidade", idCidade.intValue());
        return (Cidade)q.uniqueResult();
    }

    public Object findCidadePorCodigoIBGE(String codigoIBGE, Long idCidade) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = "FROM Cidade u WHERE u.codIbgeCompleto = :codIBGE";
        if (idCidade != null) {
            query = (String)query + " and u.identificador <> :idCidade";
        }
        Query q = s.createQuery((String)query);
        q.setString("codIBGE", codigoIBGE);
        if (idCidade != null) {
            q.setLong("idCidade", idCidade.longValue());
        }
        q.setMaxResults(1);
        return q.uniqueResult();
    }
}

