/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoCidadesCidade;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.RegiaoTabPrecoDinamica;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.TabelaCalculoFrete;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementor.model.vo.TransportadorRedespacho;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorlogger.TLogger;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.service.CoreRequestContext;
import mentorcore.tools.DateUtil;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DAOCliente
extends CoreBaseDAO {
    private static final TLogger logger = TLogger.get(DAOCliente.class);

    @Override
    public Class getVOClass() {
        return Cliente.class;
    }

    public Object findByDescricao(String texto) {
        Long idCliente = 0L;
        try {
            idCliente = new Long(texto);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Object query = " select c.identificador, p.nome, p.complemento.cnpj, u.identificador,  p.complemento.inscEst, p.nomeFantasia from UnidadeFatCliente u inner join u.cliente c  inner join c.pessoa cp  inner join u.pessoa p where p.ativo = :sim  and c.ativo=:sim and cp.ativo=:sim and (upper(p.nome) like :nome or p.complemento.cnpj like :cnpj or upper(c.codigoCliente) like :codigoCliente";
        if (idCliente > 0L) {
            query = (String)query + " or c.identificador = :idCliente";
        }
        query = (String)query + ")";
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)query);
        q.setString("nome", "%" + texto.toUpperCase() + "%");
        q.setString("codigoCliente", "%" + texto.toUpperCase() + "%");
        q.setString("cnpj", "%" + texto + "%");
        if (idCliente > 0L) {
            q.setLong("idCliente", idCliente.longValue());
        }
        q.setShort("sim", (short)1);
        return q.list();
    }

    public List findProdutosSemGiroCliente(Long idCliente, Integer numeroDias, Long idEmpresa, Integer nrMaxReg, Long idEspecie, Long idSubespecie) {
        String query = "select distinct pr.identificador as ID_PRODUTO,pr.codigoAuxiliar as CODIGO_AUXILIAR,  pr.nome as PRODUTO, i.quantidadeTotal as QUANTIDADE_TOTAL, i.valorTotal as VALOR_TOTAL,p.dataEmissao as DATA_EMISSAO from Pedido p inner join p.itemPedido i inner join i.produto pr inner join pr.especie esp inner join pr.subEspecie sub inner join p.unidadeFatCliente u inner join u.cliente c inner join p.empresa e where c.identificador = :idCliente and p.dataEmissao <= :dataBase and e.identificador = :idEmp and (:idEspecie = 0 or esp.identificador = :idEspecie) and (:idSubespecie = 0 or sub.identificador = :idSubespecie) and not exists( select p1.identificador from Pedido p1 inner join p1.itemPedido i1 inner join p1.unidadeFatCliente u1 inner join p1.empresa e1 where i1.produto = i.produto and u1.cliente=u.cliente and p.dataEmissao>:dataBase and e1.identificador =:idEmp ) and p.dataEmissao = ( select max(p2.dataEmissao) from Pedido p2 inner join p2.itemPedido i2 inner join p2.unidadeFatCliente u2 inner join p2.empresa e2 where i2.produto = i.produto and u2.cliente=u.cliente and p.dataEmissao<=:dataBase and e2.identificador =:idEmp ) order by p.dataEmissao desc,pr.nome asc";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(query);
        q.setLong("idCliente", idCliente.longValue());
        q.setLong("idEmp", idEmpresa.longValue());
        q.setLong("idEspecie", idEspecie.longValue());
        q.setLong("idSubespecie", idSubespecie.longValue());
        q.setMaxResults(nrMaxReg.intValue());
        q.setDate("dataBase", DateUtil.previousDays(new Date(), numeroDias));
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public List<HashMap> findProdutosNuncaCompradosCliente(Long idCliente, Long idEmpresa, Integer nrMaxReg, Long idEspecie, Long idSubespecie) {
        String query = "select distinct pr.identificador as ID_PRODUTO,pr.codigoAuxiliar as CODIGO_AUXILIAR,  pr.nome as PRODUTO from TabelaPrecoBase t inner join t.produtos tp inner join tp.produto pr inner join pr.especie esp inner join pr.subEspecie sub inner join t.empresa e where not exists(select p1.identificador from Pedido p1 inner join p1.itemPedido i1 inner join p1.unidadeFatCliente u1 inner join u1.cliente c1 inner join p1.empresa e1 where i1.produto = pr and c1.identificador=:idCliente and e1.identificador = :idEmp) and (t.dataFinal is null or :dataBase < t.dataFinal) and e.identificador =:idEmp  and (:idEspecie = 0 or esp.identificador = :idEspecie) and (:idSubespecie = 0 or sub.identificador = :idSubespecie) order by pr.nome asc";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(query);
        q.setLong("idCliente", idCliente.longValue());
        q.setLong("idEmp", idEmpresa.longValue());
        q.setLong("idEspecie", idEspecie.longValue());
        q.setLong("idSubespecie", idSubespecie.longValue());
        q.setMaxResults(nrMaxReg.intValue());
        q.setDate("dataBase", new Date());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public Object findClienteFaturamento(Long pessoa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("FROM ClienteFaturamento c WHERE c.cliente.pessoa = :pessoa");
        q.setLong("pessoa", pessoa.longValue());
        return q.uniqueResult();
    }

    public String sincRegTabPRClienteGrCidadesO() throws ExceptionDatabase {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct c from Cliente c inner join c.faturamento f  where f.regiaoTabPrecoDinamica is null");
        List clientes = q.list();
        List regs = (List)CoreDAOFactory.getInstance().getDAORegiaoTabPrecoDinamica().findAll();
        StringBuilder sb = new StringBuilder();
        for (Cliente u1 : clientes) {
            RegiaoTabPrecoDinamica r = null;
            for (RegiaoTabPrecoDinamica reg : regs) {
                Optional<GrupoCidadesCidade> found = reg.getGrupoCidades().getCidades().stream().filter(cid -> cid.getCidade().equals((Object)u1.getPessoa().getEndereco().getCidade())).findFirst();
                if (!found.isPresent() || found.get().getAtivo() != 1) continue;
                r = reg;
                break;
            }
            if (r != null) {
                u1.getFaturamento().setRegiaoTabPrecoDinamica(r);
                sb.append("Cliente adicionado a rota: " + u1.getPessoa().getNome() + " -> " + r.getDescricao() + "\n");
            } else {
                sb.append("(Cidade nao encontrada) Cliente n\u00e3o adicionado a rota: " + u1.getPessoa().getNome() + " -> " + u1.getPessoa().getEndereco().getCidade().getDescricao() + "\n");
            }
            r = null;
        }
        this.saveOrUpdateCollection(clientes);
        return sb.toString();
    }

    public void atualizarTransportadorRedespachoRepresentanteCliente(Integer tipo, Transportador transportadorAtual, Transportador transportadorNova, TransportadorRedespacho redespachoAtual, TransportadorRedespacho redespachoNova, Representante representanteAtual, Representante representanteNova, List<UnidadeFederativa> listaUf, TabelaCalculoFrete tabelaFrete) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "UPDATE ClienteFaturamento c";
        if (transportadorNova != null) {
            hql = (String)hql + " SET c.transportadora = :transportadorNova";
            hql = transportadorAtual != null ? (String)hql + " WHERE c.transportadora = :transportadorAtual" : (String)hql + " WHERE c.transportadora IS NULL";
        } else if (redespachoNova != null) {
            hql = (String)hql + " SET c.transportadoraRedespacho = :redespachoNova";
            hql = redespachoAtual != null ? (String)hql + " WHERE c.transportadoraRedespacho = :redespachoAtual" : (String)hql + " WHERE c.transportadoraRedespacho IS NULL";
        } else {
            hql = (String)hql + " SET c.representante = :representanteNova";
            hql = representanteAtual != null ? (String)hql + " WHERE c.representante = :representanteAtual" : (String)hql + " WHERE c.representante IS NULL";
        }
        if (tipo.equals(0)) {
            hql = (String)hql + " AND (";
            for (i = 0; i < listaUf.size(); ++i) {
                if (i > 0) {
                    hql = (String)hql + " OR";
                }
                hql = (String)hql + " (SELECT u FROM Cliente          l INNER JOIN l.pessoa   p INNER JOIN p.endereco e INNER JOIN e.cidade   i INNER JOIN i.uf       u WHERE l.faturamento.idCliente = c.idCliente) = :unidadeFederativa" + i;
            }
            hql = (String)hql + ")";
        } else if (tipo.equals(1)) {
            hql = (String)hql + " AND (";
            for (i = 0; i < tabelaFrete.getCidadesDestino().size(); ++i) {
                if (i > 0) {
                    hql = (String)hql + " OR";
                }
                hql = (String)hql + " (SELECT i FROM Cliente          l INNER JOIN l.pessoa   p INNER JOIN p.endereco e INNER JOIN e.cidade   i WHERE l.faturamento.idCliente = c.idCliente) = :cidade" + i;
            }
            hql = (String)hql + ")";
        }
        Query q = s.createQuery((String)hql);
        if (transportadorNova != null) {
            q.setEntity("transportadorNova", (Object)transportadorNova);
            if (transportadorAtual != null) {
                q.setEntity("transportadorAtual", (Object)transportadorAtual);
            }
        } else if (redespachoNova != null) {
            q.setEntity("redespachoNova", (Object)redespachoNova);
            if (redespachoAtual != null) {
                q.setEntity("redespachoAtual", (Object)redespachoAtual);
            }
        } else {
            q.setEntity("representanteNova", (Object)representanteNova);
            if (representanteAtual != null) {
                q.setEntity("representanteAtual", (Object)representanteAtual);
            }
        }
        if (tipo.equals(0)) {
            for (int i = 0; i < listaUf.size(); ++i) {
                q.setEntity("unidadeFederativa" + i, (Object)listaUf.get(i));
            }
        } else if (tipo.equals(1)) {
            for (int i = 0; i < tabelaFrete.getCidadesDestino().size(); ++i) {
                q.setEntity("cidade" + i, tabelaFrete.getCidadesDestino().get(i));
            }
        }
        q.executeUpdate();
    }

    public Collection findCnpjCpf(String num, Empresa emp) throws ExceptionDatabase {
        try {
            Session s = null;
            Query q = null;
            s = CoreBdUtil.getInstance().getSession();
            q = s.createQuery("from Cliente P where (P.fichaFinanceira.cpfSocio = :codigo or P.fichaFinanceira.cpfSocio2 = :codigo or P.fichaFinanceira.cpfSocio3 = :codigo) and P.empresa = :emp").setParameter("codigo", (Object)num).setParameter("emp", (Object)emp);
            return q.list();
        }
        catch (HibernateException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExceptionDatabase(e.getMessage(), e);
        }
    }

    public Boolean atualizarPlanoConta(CoreRequestContext request) {
        String hql = "update Cliente c inner join cliente.pessoa p on set p.contasPessoa.planoContaAtivo =:nova where c.identificador =:id";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setParameter("id", (Object)((Long)request.getAttribute("id")));
        q.setParameter("nova", (Object)((PlanoConta)request.getAttribute("planoConta")));
        q.executeUpdate();
        return true;
    }

    public List preencheCliente(CoreRequestContext request) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select c.identificador as CODN, p.nome as NOME, p.nomeFantasia as FANT, e.logradouro as END, e.numero as NUMERO, e.complemento as COMPL, e.bairro as BAIR, ci.descricao as CID, u.sigla as UF, e.cep as CEP, ce.logradouro as ENDCOBR, ce.numero as NUMCOBR, ce.complemento as COMPCOBR, ce.bairro as BAIRCOBR, cid.descricao as CIDACOBR, ciuf.sigla as UFCOBR, ce.cep as CEPCOBR, co.fone1 as FONE, co.fax1 as FAX, co.cel1 as CELULAR, c.dataCadastro as CADASTRO, co.cnpj as CPF, co.rg as DOC, co.dataEmissaoRG as DATEXPDOC, co.orgaoEmissor as ORGEXPDOC, co.dataNascimento as NASC, pe.nome as REPRES, co.inscEst as INSC, fi.limiteCredito as VLRLIMCRE from Cliente c inner join c.pessoa p inner join p.endereco e inner join e.cidade ci inner join ci.uf u inner join p.complemento co inner join c.faturamento f inner join f.representante r inner join r.pessoa pe inner join c.financeiro fi left join c.pessoa.enderecoCobranca ce left join ce.cidade cid left join cid.uf ciuf");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public List findClientesParaExportacao() {
        Session s = CoreBdUtil.getInstance().getSession();
        NativeQuery q = s.createSQLQuery(" SELECT C.ID_CLIENTE                     AS CODIGO,         CP.CNPJ                          AS CPF_CNPJ,         CP.INSCRICAO_ESTADUAL            AS INSCRICAO_IDENT,         P.NOME                           AS NOME_RAZAO_SOCIAL,         E.LOGRADOURO || ' ' || E.NUMERO  AS ENDERECO,         E.BAIRRO                         AS BAIRRO,         E.CEP                            AS CEP,         CI.DESCRICAO                     AS CIDADE,         U.SIGLA                          AS ESTADO,         '  '                             AS BRANCOS,         CP.FONE1                         AS TELEFONE,         '                              ' AS BRANCOS_2,         'N'                              AS BLOQUEADO,         '0000000000'                     AS SALDO_LIMITE,         '0000000000'                     AS VALOR_LIMITE  FROM       CLIENTE            C  INNER JOIN PESSOA             P  ON P.ID_PESSOA       = C.ID_PESSOA  INNER JOIN COMPLEMENTO        CP ON CP.ID_COMPLEMENTO = P.ID_COMPLEMENTO  INNER JOIN ENDERECO           E  ON E.ID_ENDERECO     = P.ID_ENDERECO  INNER JOIN CIDADE             CI ON CI.ID_CIDADE      = E.ID_CIDADE  INNER JOIN UF                 U  ON U.ID_UF           = CI.ID_UF  INNER JOIN CLIENTE_FINANCEIRO CF ON C.ID_CLIENTE      = CF.ID_CLIENTE ");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }
}

