/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ColaboradorSalario;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Funcao;
import com.touchcomp.basementor.model.vo.Sindicato;
import com.touchcomp.basementor.model.vo.TipoColaborador;
import com.touchcomp.basementor.model.vo.TipoEventoEsocial;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DAOColaborador
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return Colaborador.class;
    }

    public List buscarAtSindical(Colaborador colaborador) {
        String hql = " from AtualizacaoContribuicaoSindical at  where at.colaborador = :colaborador  order by at.dataPagamento ";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).list();
    }

    public List buscarAtualizacaoFeriasAnterior(Colaborador colaborador) {
        String hql = " from ColaboradorDadosFerias dadosFerias  where   dadosFerias.colaborador = :colaborador  order by dadosFerias.inicioGozoFerias ";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).list();
    }

    public List buscarAfastamentos(Colaborador colaborador) {
        String hql = " from AfastamentoColaborador afastamento  where  afastamento.dataAfastamento != null  and  afastamento.colaborador = :colaborador  order by afastamento.dataAfastamento ";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).list();
    }

    public List buscarTransferenciasEntreEmpresas(Colaborador colaborador) {
        String hql = " from TransferenciaColaborador t where t.colaborador = :colaborador  order by t.dataTransferencia ";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).list();
    }

    public Integer buscarProximoNumeroRegistro(Long idEmpresa, Long tipo) {
        String hql = " select max(cast(c.numeroRegistro as integer))+1  from Colaborador c  where c.empresa.identificador = :idEmpresa and c.tipoColaborador.identificador = :tipo";
        return (Integer)CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("tipo", tipo.longValue()).setLong("idEmpresa", idEmpresa.longValue()).uniqueResult();
    }

    public Integer buscarProximoNumeroRegistroSemVinculo(Long idEmpresa, Long tipo) {
        String hql = " select max(cast(c.numeroRegistro as integer))+1  from Colaborador c  where c.empresa.identificador = :idEmpresa and c.tipoColaborador.compoe2200 = :nao";
        return (Integer)CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("nao", (Object)0).setLong("idEmpresa", idEmpresa.longValue()).uniqueResult();
    }

    public void atualizaArquivoDocumento(Colaborador colaborador) {
        Query q = CoreBdUtil.getInstance().getSession().createQuery("update Colaborador c set c.arquivamentoDoc = null where l = :colaborador");
        q.setEntity("colaborador", (Object)colaborador);
        q.executeUpdate();
    }

    public Colaborador findColaboradorEmpresaIdentificador(Long identificador, Empresa empresa) {
        Query q = CoreBdUtil.getInstance().getSession().createQuery("select c from Colaborador c where c.identificador=:id and c.empresa = :empresa");
        q.setEntity("empresa", (Object)empresa);
        q.setLong("id", identificador.longValue());
        return (Colaborador)q.uniqueResult();
    }

    public ColaboradorSalario findColaboradorSalario(Colaborador colaborador, Date periodo) {
        String hql = " select c  from ColaboradorSalario c where c.periodo = (select max(cc.periodo)                     from ColaboradorSalario cc                    where (cc.periodo <= :periodo)                     and                     cc.colaborador.identificador = :colaborador) and  c.colaborador.identificador = :colaborador";
        return (ColaboradorSalario)CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("colaborador", colaborador.getIdentificador().longValue()).setDate("periodo", periodo).uniqueResult();
    }

    public List buscarColaboradoresEmpresa(Empresa empresa) {
        String hql = " select c  from Colaborador c  where  c.dataDemissao is null  and  c.ativo = :sim  and  c.empresa.identificador = :empresa ";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("sim", (short)1).setLong("empresa", empresa.getIdentificador().longValue()).list();
    }

    public List findSalarioPorFuncao(Funcao funcao, Date periodo) {
        String hql = " select distinct(c.valorSalario) as VALOR_SALARIO  from ColaboradorSalario c where  c.funcao = :funcao and  c.colaborador.ativo = :sim  and  c.colaborador.dataDemissao is null and  c.periodo = (select max(cc.periodo )              from ColaboradorSalario cc               where               cc.colaborador = c.colaborador               and               cc.periodo <= :periodo )";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("funcao", (Object)funcao).setDate("periodo", periodo).setShort("sim", (short)1).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
    }

    public List findSalarioPorSindicatoHorasMes(Sindicato sindicato, Double horasMes) {
        String hql = " select distinct item.valorSalario as VALOR_SALARIO  from ItemFuncaoSindicato item  where  item.sindicato = :sindicato  and  item.cargaHoraria = :horasMes ";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("sindicato", (Object)sindicato).setDouble("horasMes", horasMes.doubleValue()).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
    }

    public String verificarSituacaoColaborador(Colaborador colaborador) {
        if (colaborador.getAtivo().equals((short)0)) {
            return " COLABORADOR DESATIVADO MANUALMENTE ";
        }
        String hql = " from AfastamentoColaborador af  where  af.dataAfastamento != null  and  af.colaborador = :colaborador  and  (af.dataRetorno is null or af.dataRetorno > :current_date ) ";
        List l = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setDate("current_date", new Date()).list();
        if (l != null && !l.isEmpty()) {
            return " COLABORADOR EST\u00c1 AFASTADO ";
        }
        if (colaborador.getDataDemissao() == null && colaborador.getAtivo().equals((short)1)) {
            return " COLABORADOR ATIVO ";
        }
        if (colaborador.getDataDemissao() != null) {
            return " COLABORADOR DESLIGADO ";
        }
        return " SITUA\u00c7\u00c3O ENCONTRADA ";
    }

    public List<Colaborador> findColaboradoresByTipoColaboradorEsoc(TipoEventoEsocial tp, Empresa empresa, Date dataInicial, Date dataFinal) {
        if (tp.getIdentificador().equals(ConstantsESocial.REGISTRO_2200)) {
            Object hql = "from Colaborador c  where  (c.tipoColaborador.identificador = :empregado or c.tipoColaborador.identificador = :menor)  and  c.dataDemissao is null  and c.ativo = :sim  and not exists(select item.identificador                  from ItemSaneamentoDadosColaborador item                  where item.colaborador.identificador = c.identificador                  and item.liberado = :sim )  and c.empresa.empresaDados.grupoEmpresa.identificador = :grupoEmpresa";
            if (dataInicial != null && dataFinal != null) {
                hql = (String)hql + " and c.dataAdmissao between :dataInicial and :dataFinal";
            }
            Query q = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
            q.setShort("sim", (short)1);
            q.setLong("empregado", EnumConstTipoColaborador.EMPREGADO.getValue());
            q.setLong("menor", EnumConstTipoColaborador.MENOR_APRENDIZ.getValue());
            if (dataInicial != null && dataFinal != null) {
                q.setDate("dataInicial", dataInicial);
                q.setDate("dataFinal", dataFinal);
            }
            q.setLong("grupoEmpresa", empresa.getEmpresaDados().getGrupoEmpresa().getIdentificador().longValue());
            return q.list();
        }
        Object hql = "from Colaborador c  where c.dataDemissao is null  and (c.tipoColaborador.identificador = :autonomo or c.tipoColaborador.identificador = :autonomoFrete or c.tipoColaborador.identificador = :socio or c.tipoColaborador.identificador = :estagiario) and c.ativo = :sim  and not exists(select item.identificador                  from ItemSaneamentoDadosColaborador item                  where item.colaborador.identificador = c.identificador                  and item.liberado = :sim )  and c.empresa.empresaDados.grupoEmpresa.identificador = :grupoEmpresa";
        if (dataInicial != null && dataFinal != null) {
            hql = (String)hql + " and c.dataAdmissao between :dataInicial and :dataFinal";
        }
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
        q.setShort("sim", (short)1);
        q.setLong("autonomoFrete", EnumConstTipoColaborador.AUTONOMO.getValue());
        q.setLong("autonomo", EnumConstTipoColaborador.AUTONOMO_FRETE.getValue());
        q.setLong("socio", EnumConstTipoColaborador.SOCIO_DIRETOR.getValue());
        q.setLong("estagiario", EnumConstTipoColaborador.ESTAGIARIO.getValue());
        if (dataInicial != null && dataFinal != null) {
            q.setDate("dataInicial", dataInicial);
            q.setDate("dataFinal", dataFinal);
        }
        q.setLong("grupoEmpresa", empresa.getEmpresaDados().getGrupoEmpresa().getIdentificador().longValue());
        return q.list();
    }

    public List<Colaborador> revalidarColaboradoresByTipoColaboradorS2200Esoc(TipoColaborador tp, Empresa empresa, Date dataInicial, Date dataFinal) {
        Object hql = "from Colaborador c  where c.dataDemissao is null  and c.tipoColaborador = :tipoColaborador  and c.ativo = :sim  and exists(select item.identificador                  from ItemSaneamentoDadosColaborador item                  where item.colaborador.identificador = c.identificador                  and item.liberado = :sim )  and c.empresa.empresaDados.grupoEmpresa.identificador = :grupoEmpresa";
        if (dataInicial != null && dataFinal != null) {
            hql = (String)hql + " and c.dataAdmissao between :dataInicial and :dataFinal";
        }
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
        q.setShort("sim", (short)1);
        q.setEntity("tipoColaborador", (Object)tp);
        if (dataInicial != null && dataFinal != null) {
            q.setDate("dataInicial", dataInicial);
            q.setDate("dataFinal", dataFinal);
        }
        q.setLong("grupoEmpresa", empresa.getEmpresaDados().getGrupoEmpresa().getIdentificador().longValue());
        return q.list();
    }
}

