/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.Coleta;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.TipoPontoControle;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class DAOColeta
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return Coleta.class;
    }

    public List<Coleta> findColetasPorEquipamento(Equipamento equipamento) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "FROM Coleta c WHERE c.ativo.identificador = :idEquipamento ORDER BY c.numeroColeta";
        Query q = s.createQuery(query);
        q.setLong("idEquipamento", equipamento.getIdentificador().longValue());
        return q.list();
    }

    public List<Coleta> findColetasPorEquipamentoTipoPonto(Equipamento equipamento, TipoPontoControle tipoPontoControle) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "FROM Coleta c WHERE c.ativo.identificador = :idEquipamento AND c.tipoPontoControle.identificador = :idTipoPontoControle ORDER BY c.numeroColeta ";
        Query q = s.createQuery(query);
        q.setLong("idEquipamento", equipamento.getIdentificador().longValue());
        q.setLong("idTipoPontoControle", tipoPontoControle.getIdentificador().longValue());
        return q.list();
    }

    public List<Coleta> getColetasEntreDatas(Equipamento equipamento, TipoPontoControle tipoPontoControle, Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "FROM Coleta c WHERE c.ativo.identificador = :idEquipamento AND c.tipoPontoControle.identificador = :idTipoPontoControle AND c.dataHoraColeta BETWEEN :dataInicial AND :dataFinal ORDER BY c.numeroColeta ";
        Query q = s.createQuery(query);
        q.setLong("idEquipamento", equipamento.getIdentificador().longValue());
        q.setLong("idTipoPontoControle", tipoPontoControle.getIdentificador().longValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        return q.list();
    }

    public Coleta findColetaPorPlacaPosterior(String placa, Date dataConsumo) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("FROM Coleta ca WHERE ca.identificador = (SELECT MIN(ca2.identificador) FROM Coleta ca2 WHERE ca2.ativo.codigo = :placa AND ca2.dataHoraColeta > :dataConsumo)");
        q.setString("placa", placa);
        q.setDate("dataConsumo", dataConsumo);
        return (Coleta)q.uniqueResult();
    }
}

