/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.ConsumoAtivo;
import com.touchcomp.basementor.model.vo.FechamentoOrdemServico;
import com.touchcomp.basementor.model.vo.GradeItemConsumoAtivo;
import com.touchcomp.basementor.model.vo.Produto;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DAOConsumoAtivo
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return ConsumoAtivo.class;
    }

    public ConsumoAtivo findUltimoHodometroAtivoPorPlacaPosterior(String placa, Date dataConsumo) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("FROM ConsumoAtivo ca WHERE ca.identificador = (SELECT MIN(ca2.identificador) FROM ConsumoAtivo ca2 WHERE ca2.equipamento.codigo = :placa AND ca2.dataConsumo > :dataConsumo)");
        q.setString("placa", placa);
        q.setDate("dataConsumo", dataConsumo);
        return (ConsumoAtivo)q.uniqueResult();
    }

    public List<ConsumoAtivo> findConsumosPorNrDocOrigem(Long numDocOrigem) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("FROM ConsumoAtivo ca WHERE ca.nrDocOrigem = :numDocOrigem");
        q.setLong("numDocOrigem", numDocOrigem.longValue());
        return q.list();
    }

    public FechamentoOrdemServico existeFechamentoComConsumo(ConsumoAtivo consumoAtivo) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT p.procedimento.servicoProcedimento.fechamentoOrdemServico FROM ProdutoPrevManutencao p WHERE p.itemConsumoAtivo.consumoAtivo.identificador = :idConsumoAtivo");
        q.setLong("idConsumoAtivo", consumoAtivo.getIdentificador().longValue());
        return (FechamentoOrdemServico)q.uniqueResult();
    }

    public List getConsumosNaoAtribuidosAoAgregado(Short filtrarData, Date dataInicial, Date dataFinal, Short filtrarPlaca, String placa, Short filtrarProduto, Long idProdutoInicial, Long idProdutoFinal) {
        Object hql = "SELECT c.identificador    AS ID_CONSUMO, c.dataMovimentacao          AS DATA_MOVIMENTACAO, c.equipamento.veiculo.placa AS PLACA, i.produto.identificador     AS ID_PRODUTO, i.produto.nome              AS PRODUTO, i.valorUnitario             AS VALOR_UNITARIO, i.valorDesconto             AS VALOR_DESCONTO, i.valorTotal                AS VALOR_TOTAL FROM ConsumoAtivo c INNER JOIN c.itemConsumoAtivo i  WHERE NOT EXISTS( SELECT item.itemConsumoAtivo.identificador FROM PagtoTranspAgregado p  INNER JOIN p.itemConsumoPagtoTranspAgregado item WHERE i.identificador = item.itemConsumoAtivo.identificador)";
        if (filtrarData == 1) {
            hql = (String)hql + " AND c.dataMovimentacao BETWEEN :dataInicial AND :dataFinal";
        }
        if (filtrarPlaca == 1) {
            hql = (String)hql + " AND c.equipamento.codigo = :placa";
        }
        if (filtrarProduto == 1) {
            hql = (String)hql + " AND i.produto.identificador BETWEEN :idProdutoInicial AND :idProdutoFinal";
        }
        hql = (String)hql + " ORDER BY c.equipamento.veiculo.placa";
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
        if (filtrarData == 1) {
            q.setDate("dataInicial", dataInicial);
            q.setDate("dataFinal", dataFinal);
        }
        if (filtrarPlaca == 1) {
            q.setString("placa", placa);
        }
        if (filtrarProduto == 1) {
            q.setLong("idProdutoInicial", idProdutoInicial.longValue());
            q.setLong("idProdutoFinal", idProdutoFinal.longValue());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public Double pesquisarHodometroAnterior(String placa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT c.hodometro FROM ConsumoAtivo c WHERE c.identificador = (SELECT MAX(a.identificador) FROM ConsumoAtivo a WHERE a.equipamento.codigo = :placa)");
        q.setString("placa", placa.toUpperCase());
        return (Double)q.uniqueResult();
    }

    public List<GradeItemConsumoAtivo> pesquisarGradeItemConsumo(Produto produto) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT NEW com.touchcomp.basementor.model.vo.GradeItemConsumoAtivo(g) FROM GradeCor g WHERE g.produtoGrade.produto = :produto AND g.ativo = :ativo");
        q.setEntity("produto", (Object)produto);
        q.setShort("ativo", (short)1);
        return q.list();
    }
}

