/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.ContratoLocacao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.GrupoContrLocacao;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class DAOContratoLocacaoCore
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return ContratoLocacao.class;
    }

    public static ContratoLocacao getOutroContratoComAtivo(Equipamento ativo, Date dataInicial, Date dataFinal, Long idContratoLocacao) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = "SELECT c.itemContratoLocacao.contratoLocacao FROM ContratoLocacaoBem c WHERE c.ativo.identificador = :idAtivo AND (       (:dataInicial BETWEEN c.itemContratoLocacao.contratoLocacao.dataInicialVigencia AND c.itemContratoLocacao.contratoLocacao.dataFinalVigencia)    OR (:dataFinal   BETWEEN c.itemContratoLocacao.contratoLocacao.dataInicialVigencia AND c.itemContratoLocacao.contratoLocacao.dataFinalVigencia)     )   AND c.itemContratoLocacao.contratoLocacao.fechamentoContratoLocacao.identificador is  null ";
        if (idContratoLocacao != null && idContratoLocacao != 0L) {
            query = (String)query + "AND c.itemContratoLocacao.contratoLocacao.identificador != :idContratoLocacao";
        }
        Query q = s.createQuery((String)query);
        q.setLong("idAtivo", ativo.getIdentificador().longValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        if (idContratoLocacao != null && idContratoLocacao != 0L) {
            q.setLong("idContratoLocacao", idContratoLocacao.longValue());
        }
        return (ContratoLocacao)q.uniqueResult();
    }

    public static List<ContratoLocacao> findContratosPorPeriodo(Date dataApuracao, GrupoContrLocacao grupoContrLocacao, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "select distinct c FROM ContratoLocacao c  left join c.fechamentoContratoLocacao f left join c.grupoContrLocacao g WHERE f.identificador is null AND c.tipoContrato.tipoContrato = :tipoContrato  AND c.empresa = :empresa  AND c.preContrato = :isPreContrato  AND (:grupoContrLocacao =0 or g.identificador = :grupoContrLocacao)  AND CAST(c.dataInicialVigencia AS date)<=:dataApuracao  AND NOT EXISTS(SELECT contrato      FROM ContratoLocacao contrato      WHERE c.identificador=contrato.identificador      AND :dataApuracao<=(SELECT max(a.dataApuracao)          FROM ApuracaoLocacao a          INNER JOIN a.apuracaoLocacaoContrato ac          WHERE ac.contratoLocacao.identificador=c.identificador)) AND NOT EXISTS(SELECT contrato      FROM ContratoLocacao contrato      WHERE c.identificador=contrato.identificador      AND CAST(c.dataFinalVigencia AS date)<=(SELECT max(a.dataApuracao)          FROM ApuracaoLocacao a          INNER JOIN a.apuracaoLocacaoContrato ac          WHERE ac.contratoLocacao.identificador=c.identificador)) ";
        Query q = s.createQuery(query);
        q.setShort("tipoContrato", (short)0);
        q.setShort("isPreContrato", (short)0);
        q.setDate("dataApuracao", dataApuracao);
        q.setEntity("empresa", (Object)empresa);
        if (grupoContrLocacao != null) {
            q.setLong("grupoContrLocacao", grupoContrLocacao.getIdentificador().longValue());
        } else {
            q.setLong("grupoContrLocacao", 0L);
        }
        return q.list();
    }

    private static Integer getMonthFromDate(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(2);
    }

    public ContratoLocacao getContratoAbertoAtivo(Equipamento ativo, Long idContrato) {
        Session session = CoreBdUtil.getInstance().getSession();
        Object hql = "select c from ContratoLocacao c inner join c.itensContratoLocacao i inner join i.contratoLocacaoBem cb inner join cb.ativo ativo left join c.fechamentoContratoLocacao f where ativo=:ativo and f.identificador is null ";
        if (idContrato != null && idContrato > 0L) {
            hql = (String)hql + "and c.identificador!=:idContrato";
        }
        Query query = session.createQuery((String)hql);
        query.setEntity("ativo", (Object)ativo);
        if (idContrato != null && idContrato > 0L) {
            query.setLong("idContrato", idContrato.longValue());
        }
        query.setMaxResults(1);
        return (ContratoLocacao)query.uniqueResult();
    }

    public List<ContratoLocacao> getContratoLocacaoByAtivo(Long idAtivo) {
        String hql = "select distinct(contrato) from ContratoLocacao contrato inner jooin contrato.itemContratoLocacao iteminner join item.contratoLocacaoBem contratoBem where contratoBem.ativo.identificador=:idAtivo ";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setLong("idAtivo", idAtivo.longValue());
        return q.list();
    }
}

