/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.CotacaoVendas;
import com.touchcomp.basementor.model.vo.SituacaoCotacaoVendas;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class DAOCotacaoVendas
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return CotacaoVendas.class;
    }

    public void atualizarSituacaoCotacaoVendas(CotacaoVendas cotacaoVendas, SituacaoCotacaoVendas sit) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("update CotacaoVendas c set c.situacaoCotacaoVendas = :sit where c.identificador = :idCotacao");
        q.setEntity("sit", (Object)sit);
        q.setLong("idCotacao", cotacaoVendas.getIdentificador().longValue());
        q.executeUpdate();
    }

    public List findMotivoDesistencia(Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "SELECT DISTINCT(n.motivoDesistencia) FROM CotacaoVendas n WHERE (n.dataEmissao BETWEEN :dataInicial AND :dataFinal ) ";
        Query q = s.createQuery(hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        return q.list();
    }

    public void atualizaArquivoDocumento(CotacaoVendas cv) {
        Query q = CoreBdUtil.getInstance().getSession().createQuery("update CotacaoVendas cv set cv.arquivoDoc = null where t = :cotacaoVendas");
        q.setEntity("cotacaoVendas", (Object)cv);
        q.executeUpdate();
    }

    public List<CotacaoVendas> buscarCotacoesRevisao(CotacaoVendas cotacao) {
        Query q = CoreBdUtil.getInstance().getSession().createQuery("   from CotacaoVendas cv  where cv.cotacaoVendasPai.identificador = :cotacaoVendasPai");
        q.setLong("cotacaoVendasPai", cotacao.getIdentificador().longValue());
        return q.list();
    }
}

