/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.Bem;
import com.touchcomp.basementor.model.vo.DepreciacaoCiap;
import com.touchcomp.basementor.model.vo.Empresa;
import java.util.Date;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.tools.DateUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class DAODepreciacaoCiap
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return DepreciacaoCiap.class;
    }

    public Boolean verificarDeprPeriodo(Date periodo, Empresa empresa, Long identificador) {
        Long count;
        Session s = CoreBdUtil.getInstance().getSession();
        Object querie = "select count(p) from DepreciacaoCiap p where p.periodo=:periodo and p.empresa=:empresa";
        if (identificador != null && identificador > 0L) {
            querie = (String)querie + " and p.identificador<>:identificador";
        }
        Query q = s.createQuery((String)querie);
        q.setDate("periodo", periodo);
        q.setEntity("empresa", (Object)empresa);
        if (identificador != null && identificador > 0L) {
            q.setLong("identificador", identificador.longValue());
        }
        return (count = (Long)q.uniqueResult()) == null || count <= 0L;
    }

    public Date getUltimoPeriodoDepr(Date periodo, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select max(p.periodo) from DepreciacaoCiap p where p.periodo<:periodo and p.empresa=:empresa");
        q.setDate("periodo", periodo);
        q.setEntity("empresa", (Object)empresa);
        Date d = (Date)q.uniqueResult();
        return d;
    }

    public Short getNextNumeroParcelaCiap(Bem b, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select max(p.numeroParcela)+1 from CiapBem p where p.bem=:bem and p.depreciacaoCiap.empresa=:empresa");
        q.setEntity("bem", (Object)b);
        q.setEntity("empresa", (Object)empresa);
        Integer parc = (Integer)q.uniqueResult();
        if (parc == null) {
            parc = b.getNrParcelaIcmsInicial() == null || b.getNrParcelaIcmsInicial() == 0 ? Integer.valueOf(1) : Integer.valueOf(b.getNrParcelaIcmsInicial().intValue());
        }
        return parc.shortValue();
    }

    public Double getValorApropriadoBem(Bem b, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select coalesce(sum(p.vrIcms+p.vrIcmsSt+p.vrIcmsFrete+p.vrIcmsDifAliq),0) from CiapBem p where p.bem=:bem and p.depreciacaoCiap.empresa=:empresa");
        q.setEntity("bem", (Object)b);
        q.setEntity("empresa", (Object)empresa);
        Double parc = (Double)q.uniqueResult();
        return parc;
    }

    public Boolean existeDepreciacaoPorPeridoAndBem(Date periodo, Empresa empresa, Bem bem) {
        Session s = CoreBdUtil.getInstance().getSession();
        String querie = "select count(p)  from DepreciacaoBem d   inner join d.itemCiapDepreciacaoBaixaBem.depreciacaoCiap p  where extract(month from p.periodo) = :mes   and  extract(year from p.periodo) = :ano   and p.empresa=:empresa  and d.bemTipoDepreciacao.bem = :bem";
        Query q = s.createQuery(querie);
        q.setInteger("mes", DateUtil.monthFromDate(periodo).intValue());
        q.setInteger("ano", DateUtil.yearFromDate(periodo).intValue());
        q.setEntity("empresa", (Object)empresa);
        q.setEntity("bem", (Object)bem);
        q.setMaxResults(1);
        Long count = (Long)q.uniqueResult();
        return count == null || count <= 0L;
    }
}

