/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.DevolucaoVendas;
import com.touchcomp.basementor.model.vo.DevolucaoVendasItens;
import com.touchcomp.basementor.model.vo.DevolucaoVendasNFPropria;
import com.touchcomp.basementor.model.vo.DevolucaoVendasNFTerceiros;
import com.touchcomp.basementor.model.vo.GradeItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.GradeItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.GradeItemPedido;
import com.touchcomp.basementor.model.vo.NFCeItem;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class DAODevolucaoVendas
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return DevolucaoVendas.class;
    }

    public DevolucaoVendasNFPropria existeNFPropriaDevolvida(NotaFiscalPropria n) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("from DevolucaoVendasNFPropria d where d.notaFiscalPropria = :notaPropria");
        q.setEntity("notaPropria", (Object)n);
        q.setMaxResults(1);
        return (DevolucaoVendasNFPropria)q.uniqueResult();
    }

    public DevolucaoVendasNFTerceiros existeNFTerceirosDevolvida(NotaFiscalTerceiros n) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("from DevolucaoVendasNFTerceiros d where d.notaFiscalTerceiros = :notaTerceiros");
        q.setEntity("notaTerceiros", (Object)n);
        q.setMaxResults(1);
        return (DevolucaoVendasNFTerceiros)q.uniqueResult();
    }

    public Double findSaldoGradeNotaPropriaDevolucao(GradeItemNotaFiscalPropria g) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct d from DevolucaoVendasItens d where d.gradeItemNotaPropria = :grade");
        q.setEntity("grade", (Object)g);
        List lista = q.list();
        Double qtdeUtilizada = 0.0;
        for (DevolucaoVendasItens d : lista) {
            NotaFiscalPropria n;
            if (d.getDevolucaoVendas().getNotaPropriaGerada() == null && d.getDevolucaoVendas().getNotaTerceirosGerada() == null || d.getDevolucaoVendas().getNotaPropriaGerada() != null && ((n = d.getDevolucaoVendas().getNotaPropriaGerada()).getSituacaoDocumento().getCodigo().equals("02") || n.getSituacaoDocumento().getCodigo().equals("03") || n.getSituacaoDocumento().getCodigo().equals("04"))) continue;
            qtdeUtilizada = qtdeUtilizada + d.getQtdeDevolver();
        }
        Double saldo = g.getQuantidade() - qtdeUtilizada;
        if (saldo < 0.0) {
            saldo = 0.0;
        }
        return saldo;
    }

    public Double findSaldoGradeNotaTerceirosDevolucao(GradeItemNotaTerceiros g) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct d from DevolucaoVendasItens d where d.gradeItemNotaTerceiros = :grade");
        q.setEntity("grade", (Object)g);
        List lista = q.list();
        Double qtdeUtilizada = 0.0;
        for (DevolucaoVendasItens d : lista) {
            NotaFiscalPropria n;
            if (d.getDevolucaoVendas().getNotaPropriaGerada() == null && d.getDevolucaoVendas().getNotaTerceirosGerada() == null || d.getDevolucaoVendas().getNotaPropriaGerada() != null && ((n = d.getDevolucaoVendas().getNotaPropriaGerada()).getSituacaoDocumento().getCodigo().equals("02") || n.getSituacaoDocumento().getCodigo().equals("03") || n.getSituacaoDocumento().getCodigo().equals("04"))) continue;
            qtdeUtilizada = qtdeUtilizada + d.getQtdeDevolver();
        }
        Double saldo = g.getQuantidade() * g.getFatorConversao() - qtdeUtilizada;
        if (saldo < 0.0) {
            saldo = 0.0;
        }
        return saldo;
    }

    public Double findSaldoGradeNFCeDevolucao(NFCeItem g) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct d from DevolucaoVendasItens d where d.itemNFCe = :grade");
        q.setEntity("grade", (Object)g);
        List lista = q.list();
        Double qtdeUtilizada = 0.0;
        for (DevolucaoVendasItens d : lista) {
            NotaFiscalPropria n;
            if (d.getDevolucaoVendas().getNotaPropriaGerada() == null && d.getDevolucaoVendas().getNotaTerceirosGerada() == null || d.getDevolucaoVendas().getNotaPropriaGerada() != null && ((n = d.getDevolucaoVendas().getNotaPropriaGerada()).getSituacaoDocumento().getCodigo().equals("02") || n.getSituacaoDocumento().getCodigo().equals("03") || n.getSituacaoDocumento().getCodigo().equals("04"))) continue;
            qtdeUtilizada = qtdeUtilizada + d.getQtdeDevolver();
        }
        Double saldo = g.getQuantidadeComercial() - qtdeUtilizada;
        if (saldo < 0.0) {
            saldo = 0.0;
        }
        return saldo;
    }

    public Double findSaldoGradePedidoDevolucao(GradeItemPedido g) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct d from DevolucaoVendasItens d where d.gradeItemPedido = :grade");
        q.setEntity("grade", (Object)g);
        List lista = q.list();
        Double qtdeUtilizada = 0.0;
        for (DevolucaoVendasItens d : lista) {
            NotaFiscalPropria n;
            if (d.getDevolucaoVendas().getNotaPropriaGerada() == null && d.getDevolucaoVendas().getNotaTerceirosGerada() == null || d.getDevolucaoVendas().getNotaPropriaGerada() != null && ((n = d.getDevolucaoVendas().getNotaPropriaGerada()).getSituacaoDocumento().getCodigo().equals("02") || n.getSituacaoDocumento().getCodigo().equals("03") || n.getSituacaoDocumento().getCodigo().equals("04"))) continue;
            qtdeUtilizada = qtdeUtilizada + d.getQtdeDevolver();
        }
        Double saldo = g.getQuantidade() - qtdeUtilizada;
        if (saldo < 0.0) {
            saldo = 0.0;
        }
        return saldo;
    }
}

