/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaDados;
import com.touchcomp.basementorlogger.TLogger;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DAOEmpresa
extends CoreBaseDAO {
    private static final TLogger logger = TLogger.get(DAOEmpresa.class);

    @Override
    public Class getVOClass() {
        return Empresa.class;
    }

    @Override
    public Collection findByCriteria(String fieldName, Object value, int option) throws ExceptionDatabase {
        Collection list = super.findByCriteria(fieldName, value, option);
        Hibernate.initialize((Object)list);
        return list;
    }

    @Override
    public Collection findAll(String orderBy, boolean asc) throws ExceptionDatabase {
        Collection list = super.findAll(orderBy, asc);
        Hibernate.initialize((Object)list);
        return list;
    }

    public Object findEmpresaPorCnpj(String cnpj) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = " from Empresa e where e.pessoa.complemento.cnpj = :cnpj";
        Query q = s.createQuery(query);
        q.setString("cnpj", cnpj);
        return q.uniqueResult();
    }

    public List findListaEmpresa() {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("from Empresa");
        return q.list();
    }

    public Object findEmpresasSincronizacaoDadosCupom(Timestamp ultimaSincronizacao) {
        Object hql = "select un.identificador as ID_EMPRESA, un.pessoa.identificador as ID_PESSOA from Empresa un ";
        if (ultimaSincronizacao != null) {
            hql = (String)hql + " where un.dataAtualizacao >= :ultimaSincronizacao";
        }
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
        if (ultimaSincronizacao != null) {
            q.setTimestamp("ultimaSincronizacao", (Date)ultimaSincronizacao);
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public List findEmpresaAtivoOrdenado() {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select new mentor.model.impl.EmpresaLogin(e.identificador,e.pessoa.nome,e.pessoa.nomeFantasia)  from Empresa e where  e.empresaDados.ativo = :ativo and e.pessoa.ativo = :ativo order by e.empresaDados.matriz desc, e.pessoa.nome asc");
        q.setShort("ativo", (short)1);
        return q.list();
    }

    public Object findEmpresaFromEmpresaDados(EmpresaDados empresaDados) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("from Empresa ewhere e.empresaDados.identificador = :idEmpresaDados");
        q.setLong("idEmpresaDados", empresaDados.getIdentificador().longValue());
        return q.uniqueResult();
    }
}

