/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.impl.SaldoEstoqueGeralTerceiros;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EstoqueTerceiros;
import com.touchcomp.basementor.model.vo.TipoMovimento;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DAOEstoqueTerceiros
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return EstoqueTerceiros.class;
    }

    public List findSaldoProdutoMaior0Terceiros(Date dataInventario, Empresa empresa, Integer tpEstoque, List<TipoMovimento> listNaoTipoMovimento) {
        int i;
        Session s = CoreBdUtil.getInstance().getSession();
        Object sql = "select sum(s.qtd_saldo) as sum_quantidade,sum(s.qtd_saldo * cast(ip.valor_unitario / ip.fator_conversao as numeric(18,6))) as sum_valor,cast(cast(sum(s.qtd_saldo * cast(ip.valor_unitario / ip.fator_conversao as numeric(18,6))) as numeric(12,2))/ sum(s.qtd_saldo) as numeric(12,2)) as valor_medio,s.id_pessoa as id_pessoa, ip.id_produto as id_produto, comp.inscricao_estadual as inscricao, comp.cnpj as cnpj, uni.sigla as sigla  from saldo_estoque_terceiros(0,99999999,:tipoEstoque,:dataInventario,:empresa, 0) s inner join grade_item_nota_propria gip on gip.id_grade_item_nota_propria = s.id_grade_item_nota_propria inner join item_nota_propria        ip on ip.id_item_nota_propria        = gip.id_item_nota_fiscal_propria inner join estoque_terceiros         e on e.id_grade_item_nota_propria   = gip.id_grade_item_nota_propria inner join pessoa                  pes on pes.id_pessoa                  = e.id_pessoa_parceiro inner join complemento            comp on comp.id_complemento            = pes.id_complemento inner join endereco               ende on ende.id_endereco               = pes.id_endereco inner join cidade                  cid on cid.id_cidade                  = ende.id_cidade  inner join uf                      uni on uni.id_uf                      = cid.id_uf inner join nota_propria              n on n.id_nota_propria              = ip.id_nota_fiscal_propria inner join natureza_operacao        ns on ns.id_natureza_operacao        = n.id_natureza_operacao";
        for (i = 1; i <= listNaoTipoMovimento.size(); ++i) {
            sql = i == 1 ? (String)sql + " WHERE ns.id_tipo_movimento <> :tipoMovimento" + i : (String)sql + " AND ns.id_tipo_movimento <> :tipoMovimento" + i;
        }
        sql = (String)sql + " group by s.id_pessoa, ip.id_produto,inscricao,cnpj,sigla union all select sum(s.qtd_saldo) as sum_quantidade, sum(s.qtd_saldo * cast(it.valor_unitario / it.fator_conversao as numeric(18,6))) as sum_valor, cast(cast(sum(s.qtd_saldo * cast(it.valor_unitario / it.fator_conversao as numeric(18,6))) as numeric(12,2)) / sum(s.qtd_saldo) as numeric(12,2)) as valor_medio, s.id_pessoa as id_pessoa, it.id_produto as id_produto, comp.inscricao_estadual as inscricao, comp.cnpj as cnpj, uni.sigla as sigla  from saldo_estoque_terceiros(0,99999999,:tipoEstoque,:dataInventario,:empresa, 0) s inner join grade_item_nota_terceiros git on git.id_grade_item_nota_terceiros = s.id_grade_item_nota_terceiros  inner join item_nota_terceiros        it on it.id_item_nota_terceiros        = git.id_item_nota_terceiros inner join estoque_terceiros           e on e.id_grade_item_nota_terceiros   = git.id_grade_item_nota_terceiros inner join pessoa                    pes on pes.id_pessoa                    = e.id_pessoa_parceiro inner join complemento              comp on comp.id_complemento              = pes.id_complemento inner join endereco                 ende on ende.id_endereco                 = pes.id_endereco inner join cidade                    cid on cid.id_cidade                    = ende.id_cidade  inner join uf                         uni on uni.id_uf                       = cid.id_uf inner join natureza_operacao           na on na.id_natureza_operacao         = it.id_natureza_operacao";
        for (i = 1; i <= listNaoTipoMovimento.size(); ++i) {
            sql = i == 1 ? (String)sql + " WHERE na.id_tipo_movimento <> :tipoMovimento" + i : (String)sql + " AND na.id_tipo_movimento <> :tipoMovimento" + i;
        }
        sql = (String)sql + " group by s.id_pessoa, it.id_produto,inscricao,cnpj,sigla";
        NativeQuery q = s.createSQLQuery((String)sql);
        q.setInteger("tipoEstoque", tpEstoque.intValue());
        q.setInteger("empresa", empresa.getIdentificador().intValue());
        q.setDate("dataInventario", dataInventario);
        int i2 = 1;
        for (TipoMovimento t : listNaoTipoMovimento) {
            q.setLong("tipoMovimento" + i2, t.getIdentificador().longValue());
            ++i2;
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List l = q.list();
        return this.converterSaldo(l, empresa.getIdentificador().intValue(), dataInventario);
    }

    private List converterSaldo(List l, Integer idEmpresa, Date dataSaldo) {
        ArrayList<SaldoEstoqueGeralTerceiros> toRet = new ArrayList<SaldoEstoqueGeralTerceiros>();
        for (Object o : l) {
            HashMap m = (HashMap)o;
            Double qtd = (BigDecimal)m.get("SUM_QUANTIDADE") == null ? 0.0 : ((BigDecimal)m.get("SUM_QUANTIDADE")).doubleValue();
            Double valor = (BigDecimal)m.get("SUM_VALOR") == null ? 0.0 : ((BigDecimal)m.get("SUM_VALOR")).doubleValue();
            Double precoMedio = (BigDecimal)m.get("VALOR_MEDIO") == null ? 0.0 : ((BigDecimal)m.get("VALOR_MEDIO")).doubleValue();
            String cnpj = (String)m.get("CNPJ");
            String sigla = (String)m.get("SIGLA");
            String inscEst = (String)m.get("inscricao");
            if (inscEst == null) {
                inscEst = "ISENTO";
            }
            Integer idEmp = idEmpresa;
            Integer idProd = (Integer)m.get("ID_PRODUTO");
            SaldoEstoqueGeralTerceiros s = new SaldoEstoqueGeralTerceiros();
            s.setCnpj(cnpj);
            s.setInscricaoEst(inscEst);
            s.setSigla(sigla);
            s.setIdEmpresa(Long.valueOf(idEmp.longValue()));
            s.setDataSaldo(dataSaldo);
            s.setIdProduto(Long.valueOf(idProd.longValue()));
            s.setQuantidade(qtd);
            s.setValorTotal(valor);
            s.setValorMedio(precoMedio);
            toRet.add(s);
        }
        return toRet;
    }
}

