/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.Executante;
import com.touchcomp.basementor.model.vo.FechamentoOrdemServico;
import com.touchcomp.basementor.model.vo.OrdemServico;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class DAOFechamentoOrdemServicoCore
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return FechamentoOrdemServico.class;
    }

    public FechamentoOrdemServico findFechamentoOSPorOS(OrdemServico ordemServico) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "FROM FechamentoOrdemServico f where f.ordemServico = :idOs";
        Query q = s.createQuery(query);
        q.setLong("idOs", ordemServico.getIdentificador().longValue());
        return (FechamentoOrdemServico)q.uniqueResult();
    }

    public Timestamp getDataFinalizacaoOrdemServico(OrdemServico ordemServico) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "SELECT MAX(e.dataHoraFinal) FROM Executante e WHERE e.fechamentoOrdemServico.ordemServico.identificador = :idOrdemServico AND e.fechamentoOrdemServico.osFechada = 1 ";
        Query q = s.createQuery(query);
        q.setLong("idOrdemServico", ordemServico.getIdentificador().longValue());
        return (Timestamp)q.uniqueResult();
    }

    public List<FechamentoOrdemServico> findFechamentoOSporExecutanteOcupado(Executante executante, FechamentoOrdemServico fechamentoOrdemServico) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = "SELECT f FROM FechamentoOrdemServico f INNER JOIN f.executantes e WHERE e.pessoa.identificador = :idPessoa ";
        query = fechamentoOrdemServico == null || fechamentoOrdemServico.getIdentificador() == null ? (String)query + "AND f.identificador IS NOT NULL " : (String)query + "AND f.identificador != :idFechamentoOrdemServico ";
        query = (String)query + "AND (:dataHoraInicial  BETWEEN e.dataHoraInicio AND e.dataHoraFinal   OR :dataHoraFinal   BETWEEN e.dataHoraInicio AND e.dataHoraFinal   OR e.dataHoraInicio BETWEEN :dataHoraInicial AND :dataHoraFinal   OR e.dataHoraFinal  BETWEEN :dataHoraInicial AND :dataHoraFinal ) ";
        Query q = s.createQuery((String)query);
        q.setLong("idPessoa", executante.getPessoa().getIdentificador().longValue());
        if (fechamentoOrdemServico != null && fechamentoOrdemServico.getIdentificador() != null) {
            q.setLong("idFechamentoOrdemServico", fechamentoOrdemServico.getIdentificador().longValue());
        }
        q.setDate("dataHoraInicial", (Date)executante.getDataHoraInicio());
        q.setDate("dataHoraFinal", (Date)executante.getDataHoraFinal());
        return q.list();
    }

    public FechamentoOrdemServico getUltimaManutencao(Equipamento ativo) {
        if (ativo == null) {
            return null;
        }
        String query = "FROM FechamentoOrdemServico fechamento WHERE fechamento.osFechada                = 1 AND fechamento.ordemServico.equipamento.identificador = :idAtivo AND fechamento.dataFechamento             = ( SELECT MAX(f2.dataFechamento) FROM FechamentoOrdemServico f2 WHERE f2.ordemServico.equipamento.identificador = :idAtivo AND f2.osFechada                          = 1                                              ) ";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(query);
        q.setLong("idAtivo", ativo.getIdentificador().longValue());
        List result = q.list();
        return result.isEmpty() ? null : result.get(0);
    }

    public FechamentoOrdemServico getFechamentoGerado(Long idFechamento) {
        String query = " select f    from FechamentoOrdemServico f    WHERE f.fechamentoOrigem.identificador=:idFechamento";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(query);
        q.setLong("idFechamento", idFechamento.longValue());
        return (FechamentoOrdemServico)q.uniqueResult();
    }
}

