/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Feriado;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.tools.DateUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class DAOFeriado
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return Feriado.class;
    }

    public Boolean findFeriadoPorData(Integer dia, Integer mes, Integer ano, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "SELECT count(fa) FROM Feriado fa INNER JOIN fa.anos a INNER JOIN fa.empresas e WHERE a.ano = :ano AND fa.dia = :dia AND fa.mes = :mes AND e = :empresa";
        Query q = s.createQuery(query);
        q.setInteger("dia", dia.intValue());
        q.setInteger("mes", mes.intValue());
        q.setInteger("ano", ano.intValue());
        q.setEntity("empresa", (Object)empresa);
        Long l = (Long)q.uniqueResult();
        return l > 0L;
    }

    public List findFeriadosNacionalPorPeriodo(Date periodoInicial, Date periodoFinal, Long idEmpresa) {
        Integer mes = DateUtil.monthFromDate(periodoFinal);
        Integer ano = DateUtil.yearFromDate(periodoFinal);
        Integer diaFinal = DateUtil.dayFromDate(periodoFinal);
        Integer diaInicial = DateUtil.dayFromDate(periodoInicial);
        String hql = " select distinct f  from Feriado f  where  (f.mes = :mesParametro  and  f.todoAno = :sim  and  f.dia >= :diaInicial  and  f.dia <= :diaFinal) or  (exists( select fAno           from FeriadoAno fAno           where           fAno.ano = :anoParametro           and           fAno.feriado.mes = :mesParametro           and           fAno.feriado.identificador = f.identificador ) and  exists (select fEmpresa          from FeriadoEmpresa fEmpresa          where          fEmpresa.empresa.identificador = :idEmpresa          and          fEmpresa.feriado.identificador = f.identificador))";
        List ret = new ArrayList();
        ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setInteger("mesParametro", mes.intValue()).setInteger("anoParametro", ano.intValue()).setLong("idEmpresa", idEmpresa.longValue()).setInteger("diaFinal", diaFinal.intValue()).setInteger("diaInicial", diaInicial.intValue()).setShort("sim", (short)1).list();
        return ret;
    }

    public List findFeriadosNacionalPorPeriodoPonto(Date periodoInicial, Date periodoFinal, Long idEmpresa) {
        Integer mes = DateUtil.monthFromDate(periodoInicial);
        Integer ano = DateUtil.yearFromDate(periodoInicial);
        Integer diaFinal = ToolDate.getLastDayOnMonth((Date)periodoInicial);
        Integer diaInicial = ToolDate.dayFromDate((Date)periodoInicial);
        Integer mesInicial = DateUtil.monthFromDate(periodoFinal);
        Integer anoInicial = DateUtil.yearFromDate(periodoFinal);
        Integer diaFinalInicial = ToolDate.dayFromDate((Date)periodoFinal);
        Integer diaInicialInicial = ToolDate.dayFromDate((Date)ToolDate.getFirtDateOnMonth((Date)periodoInicial));
        String hql = " select distinct f  from Feriado f  where  ((f.mes = :mesParametro  and  f.todoAno = :sim  and  f.dia >= :diaInicial  and  f.dia <= :diaFinal) or  (exists( select fAno           from FeriadoAno fAno           where           fAno.ano = :anoParametro           and           fAno.feriado.mes = :mesParametro           and           fAno.feriado.identificador = f.identificador ) and  exists (select fEmpresa          from FeriadoEmpresa fEmpresa          where          fEmpresa.empresa.identificador = :idEmpresa          and          fEmpresa.feriado.identificador = f.identificador))) or ( (f.mes = :mesParametroInicial  and  f.todoAno = :sim  and  f.dia >= :diaInicialInicial  and  f.dia <= :diaFinalInicial) or  (exists( select fAno           from FeriadoAno fAno           where           fAno.ano = :anoParametroInicial           and           fAno.feriado.mes = :mesParametroInicial           and           fAno.feriado.identificador = f.identificador ) and  exists (select fEmpresa          from FeriadoEmpresa fEmpresa          where          fEmpresa.empresa.identificador = :idEmpresa          and          fEmpresa.feriado.identificador = f.identificador)))";
        List ret = new ArrayList();
        ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setInteger("mesParametro", mes.intValue()).setInteger("anoParametroInicial", anoInicial.intValue()).setInteger("mesParametroInicial", mesInicial.intValue()).setInteger("anoParametro", ano.intValue()).setLong("idEmpresa", idEmpresa.longValue()).setInteger("diaFinal", diaFinal.intValue()).setInteger("diaInicial", diaInicial.intValue()).setInteger("diaFinalInicial", diaFinalInicial.intValue()).setInteger("diaInicialInicial", diaInicialInicial.intValue()).setShort("sim", (short)1).list();
        return ret;
    }
}

