/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.AfastamentoColaborador;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.FeriasColaborador;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.StatusFolhaPagamento;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;
import mentorcore.service.impl.rh.calculofolha.UtilCalculoEventosFeriasFolha;
import mentorcore.tools.DateUtil;

public class DAOFeriasColaborador
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return FeriasColaborador.class;
    }

    public void getDiasTrabalhadosFerias(Date dataInicial, Date dataFinal, MovimentoFolha mov, Short tipoCalculo, EmpresaRh empresaRh) throws ExceptionService {
        FeriasColaborador f = null;
        ArrayList<FeriasColaborador> fersCol = new ArrayList<FeriasColaborador>();
        System.err.println(mov.getColaborador().toString());
        String hql = " select ferias  from FeriasColaborador ferias  where  ferias.periodoAqFeriasColab.colaborador = :colaborador  and  ((extract(year from ferias.dataGozoInicial) = :anoAbertura  and  extract(month from ferias.dataGozoInicial) = :mesAbertura )  or  (extract(year from ferias.dataGozoFinal) = :anoAbertura  and  extract(month from ferias.dataGozoFinal) = :mesAbertura ) )";
        List feriasColaboradores = CoreBdUtil.getInstance().getSession().createQuery(hql).setInteger("anoAbertura", this.getAnoMesAbertura(dataFinal, 1)).setInteger("mesAbertura", this.getAnoMesAbertura(dataFinal, 2) + 1).setEntity("colaborador", (Object)mov.getColaborador()).list();
        if (feriasColaboradores.size() > 1) {
            for (Object object : feriasColaboradores) {
                FeriasColaborador ff = (FeriasColaborador)object;
                fersCol.add(ff);
            }
        } else if (feriasColaboradores.size() == 1) {
            f = (FeriasColaborador)feriasColaboradores.get(0);
            fersCol.add(f);
        }
        if (fersCol.isEmpty()) {
            if (tipoCalculo.equals(EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue())) {
                this.verificarQuitaoUmTerco(mov, dataInicial, dataFinal);
            }
        } else {
            if (fersCol.size() == 1) {
                f = (FeriasColaborador)fersCol.get(0);
                this.getDiasFerias(f, mov, dataInicial, dataFinal);
                this.verificarAfastamentoComFerias(mov, dataInicial, dataFinal);
                if (tipoCalculo.equals(EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue())) {
                    this.setarEventosFerias(mov, dataInicial, dataFinal, f, empresaRh);
                }
            }
            if (fersCol.size() == 2) {
                f = (FeriasColaborador)fersCol.get(0);
                this.getDiasFerias(f, mov, dataInicial, dataFinal);
                this.verificarAfastamentoComFerias(mov, dataInicial, dataFinal);
                if (tipoCalculo.equals(EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue())) {
                    this.setarEventosFerias(mov, dataInicial, dataFinal, f, empresaRh);
                }
                f = (FeriasColaborador)fersCol.get(1);
                this.getDiasSegundaFerias(f, mov, dataInicial, dataFinal);
                if (tipoCalculo.equals(EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue())) {
                    this.setarEventosSegundaFerias(mov, dataInicial, dataFinal, f, empresaRh);
                }
            }
            if (fersCol.size() == 3) {
                f = (FeriasColaborador)fersCol.get(0);
                this.getDiasFerias(f, mov, dataInicial, dataFinal);
                this.verificarAfastamentoComFerias(mov, dataInicial, dataFinal);
                if (tipoCalculo.equals(EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue())) {
                    this.setarEventosFerias(mov, dataInicial, dataFinal, f, empresaRh);
                }
                f = (FeriasColaborador)fersCol.get(1);
                this.getDiasSegundaFerias(f, mov, dataInicial, dataFinal);
                if (tipoCalculo.equals(EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue())) {
                    this.setarEventosSegundaFerias(mov, dataInicial, dataFinal, f, empresaRh);
                }
                f = (FeriasColaborador)fersCol.get(2);
                this.getDiasTerceiraFerias(f, mov, dataInicial, dataFinal);
                if (tipoCalculo.equals(EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue())) {
                    this.setarEventosSegundaFerias(mov, dataInicial, dataFinal, f, empresaRh);
                }
            }
        }
        if (tipoCalculo.equals(EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue())) {
            // empty if block
        }
    }

    private void getDiasFerias(FeriasColaborador ferias, MovimentoFolha vo, Date dataInicialAbertura, Date dataFinalAbertura) throws ExceptionService {
        GregorianCalendar g = new GregorianCalendar();
        Colaborador c = vo.getColaborador();
        if (this.verificarIgualdadeMesAno(ferias.getDataGozoInicial(), dataFinalAbertura) && this.verificarIgualdadeMesAno(ferias.getDataGozoFinal(), dataFinalAbertura)) {
            if (!ferias.getDataGozoInicial().equals(dataInicialAbertura) && !ferias.getDataGozoFinal().equals(dataFinalAbertura)) {
                Integer diasFerias = DateUtil.diferenceDayBetweenDates(ferias.getDataGozoInicial(), ferias.getDataGozoFinal()) + 1;
                vo.setDiasFerias(Double.valueOf(diasFerias.doubleValue()));
                vo.setDataInicialFerias(ferias.getDataGozoInicial());
                vo.setDataFinalFerias(ferias.getDataGozoFinal());
                return;
            }
            if (ferias.getDataGozoInicial().equals(dataInicialAbertura) && !ferias.getDataGozoFinal().equals(dataFinalAbertura)) {
                Integer diasFerias = DateUtil.diferenceDayBetweenDates(ferias.getDataGozoInicial(), ferias.getDataGozoFinal()) + 1;
                vo.setDiasFerias(Double.valueOf(diasFerias.doubleValue()));
                vo.setDataInicialFerias(ferias.getDataGozoInicial());
                vo.setDataFinalFerias(ferias.getDataGozoFinal());
                return;
            }
            if (!ferias.getDataGozoInicial().equals(dataInicialAbertura) && ferias.getDataGozoFinal().equals(dataFinalAbertura)) {
                Integer diasFerias = DateUtil.diferenceDayBetweenDates(ferias.getDataGozoInicial(), ferias.getDataGozoFinal()) + 1;
                vo.setDiasFerias(Double.valueOf(diasFerias.doubleValue()));
                vo.setDataInicialFerias(ferias.getDataGozoInicial());
                vo.setDataFinalFerias(ferias.getDataGozoFinal());
                return;
            }
            if (ferias.getDataGozoInicial().equals(dataInicialAbertura) && ferias.getDataGozoFinal().equals(dataFinalAbertura)) {
                Integer diasFerias = DateUtil.diferenceDayBetweenDates(ferias.getDataGozoInicial(), ferias.getDataGozoFinal()) + 1;
                vo.setDiasFerias(Double.valueOf(diasFerias.doubleValue()));
                vo.setDataInicialFerias(ferias.getDataGozoInicial());
                vo.setDataFinalFerias(ferias.getDataGozoFinal());
                return;
            }
        } else if (this.verificarIgualdadeMesAno(ferias.getDataGozoInicial(), dataFinalAbertura)) {
            g.setTime(ferias.getDataGozoInicial());
            Integer diasFerias = g.getActualMaximum(5) - g.get(5) + 1;
            vo.setDiasFerias(Double.valueOf(diasFerias.doubleValue()));
            vo.setDataInicialFerias(ferias.getDataGozoInicial());
            vo.setDataFinalFerias(dataFinalAbertura);
        } else {
            if (this.verificarIgualdadeMesAno(ferias.getDataGozoFinal(), dataFinalAbertura)) {
                g.setTime(ferias.getDataGozoFinal());
                if (!DateUtil.dayFromDate(ferias.getDataGozoFinal()).equals(DateUtil.dayFromDate(dataFinalAbertura))) {
                    g.add(5, 1);
                } else {
                    g.set(5, DateUtil.dayFromDate(ferias.getDataGozoFinal()));
                }
                Integer diasFerias = g.get(5) - g.getActualMinimum(5);
                vo.setDiasFerias(Double.valueOf(diasFerias.doubleValue()));
                vo.setDataInicialFerias(dataInicialAbertura);
                vo.setDataFinalFerias(ferias.getDataGozoFinal());
                return;
            }
            return;
        }
    }

    private boolean verificarIgualdadeMesAno(Date datt1, Date datt2) {
        GregorianCalendar dat2 = new GregorianCalendar();
        GregorianCalendar dat1 = new GregorianCalendar();
        dat1.setTime(datt1);
        dat2.setTime(datt2);
        return dat1.get(1) == dat2.get(1) && dat1.get(2) == dat2.get(2);
    }

    private int getAnoMesAbertura(Date dataAbertura, int i) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(dataAbertura);
        if (i == 1) {
            return g.get(1);
        }
        return g.get(2);
    }

    private void verificarAfastamentoComFerias(MovimentoFolha mov, Date dataInicial, Date dataFinal) throws ExceptionService {
        System.err.println(mov.getColaborador().getPessoa().getNome());
        AfastamentoColaborador afastamento = null;
        List l = new ArrayList();
        String hql = " select af from AfastamentoColaborador af  where  af.dataAfastamento != null  and  (af.afastamentoSefip.codigo = :cod1  or  af.afastamentoSefip.codigo = :cod2 ) and  extract(month from af.dataAfastamento) = :mes  and  extract(year from af.dataAfastamento) = :ano  and  af.colaborador = :colaborador ";
        l = CoreBdUtil.getInstance().getSession().createQuery(hql).setInteger("ano", DateUtil.yearFromDate(dataFinal).intValue()).setInteger("mes", DateUtil.monthFromDate(dataFinal).intValue()).setEntity("colaborador", (Object)mov.getColaborador()).setString("cod1", "Q1").setString("cod2", "Z1").list();
        if (!l.isEmpty()) {
            afastamento = (AfastamentoColaborador)l.get(0);
        }
        if (afastamento != null) {
            mov.setDataInicialMaternidade(afastamento.getDataAfastamento());
            mov.setDataFinalMaternidade(dataFinal);
            this.calcularDiasSaidaAfastamento(afastamento, dataInicial, dataFinal, mov);
            mov.setStatusFolha(this.getStatusFolha((short)13));
            return;
        }
        l = new ArrayList();
        hql = " select af from AfastamentoColaborador af  where  af.dataAfastamento != null  and  (af.afastamentoSefip.codigo = :cod1  or  af.afastamentoSefip.codigo = :cod2 ) and  extract(month from af.dataRetorno) = :mes  and  extract(year from af.dataRetorno) = :ano  and  af.colaborador = :colaborador ";
        l = CoreBdUtil.getInstance().getSession().createQuery(hql).setInteger("ano", DateUtil.yearFromDate(dataFinal).intValue()).setInteger("mes", DateUtil.monthFromDate(dataFinal).intValue()).setEntity("colaborador", (Object)mov.getColaborador()).setString("cod1", "Q1").setString("cod2", "Z1").list();
        if (!l.isEmpty()) {
            afastamento = (AfastamentoColaborador)l.get(0);
        }
        if (afastamento != null) {
            if (!dataInicial.equals(afastamento.getDataRetorno())) {
                mov.setDataInicialMaternidade(dataInicial);
                mov.setDataFinalMaternidade(DateUtil.nextDays(afastamento.getDataRetorno(), -1));
                this.calcularDiasRetornoAfastamento(afastamento, dataInicial, dataFinal, mov);
                mov.setStatusFolha(this.getStatusFolha((short)14));
            }
            return;
        }
    }

    private void calcularDiasSaidaAfastamento(AfastamentoColaborador afastamento, Date dataInicial, Date dataFinal, MovimentoFolha mov) {
        Integer diasAfastamento = DateUtil.diferenceDayBetweenDates(afastamento.getDataAfastamento(), dataFinal) + 1;
        mov.setDiasAfastamentoMaternidade(Double.valueOf(diasAfastamento.doubleValue()));
        mov.setDiasTrabalhados(Double.valueOf(0.0));
        mov.setDiasFolgas(Double.valueOf(0.0));
        mov.setDiasFeriados(Double.valueOf(0.0));
        mov.setBcAfastamento(afastamento.getBaseCalculoPagamento());
    }

    private void calcularDiasRetornoAfastamento(AfastamentoColaborador afastamento, Date dataInicial, Date dataFinal, MovimentoFolha mov) {
        Integer diasAfastamento = 0;
        diasAfastamento = afastamento.getDataRetorno() != null && afastamento.getDataAfastamento().before(dataInicial) ? Integer.valueOf(DateUtil.dayFromDate(afastamento.getDataRetorno()) - 1) : Integer.valueOf(DateUtil.diferenceDayBetweenDates(afastamento.getDataAfastamento(), afastamento.getDataRetorno()) + 1);
        mov.setDiasAfastamentoMaternidade(Double.valueOf(diasAfastamento.doubleValue()));
        mov.setDiasTrabalhados(Double.valueOf(0.0));
        mov.setDiasFolgas(Double.valueOf(0.0));
        mov.setDiasFeriados(Double.valueOf(0.0));
        mov.setBcAfastamento(afastamento.getBaseCalculoPagamento());
    }

    private void setarEventosFerias(MovimentoFolha mov, Date dataInicial, Date dataFinal, FeriasColaborador ferias, EmpresaRh empresaRh) throws ExceptionService {
        new UtilCalculoEventosFeriasFolha().buscarEventosFeriasPorColaborador(mov, ferias, dataInicial, dataFinal, empresaRh);
    }

    private void getDiasSegundaFerias(FeriasColaborador ferias, MovimentoFolha vo, Date dataInicialAbertura, Date dataFinalAbertura) {
        GregorianCalendar g = new GregorianCalendar();
        Colaborador c = vo.getColaborador();
        if (this.verificarIgualdadeMesAno(ferias.getDataGozoInicial(), dataFinalAbertura) && this.verificarIgualdadeMesAno(ferias.getDataGozoFinal(), dataFinalAbertura)) {
            if (!ferias.getDataGozoInicial().equals(dataInicialAbertura) && !ferias.getDataGozoFinal().equals(dataFinalAbertura)) {
                Integer diasFerias = DateUtil.diferenceDayBetweenDates(ferias.getDataGozoInicial(), ferias.getDataGozoFinal()) + 1;
                vo.setDiasFerias(Double.valueOf(vo.getDiasFerias() + diasFerias.doubleValue()));
                vo.setDataInicialSegundaFerias(ferias.getDataGozoInicial());
                vo.setDataFinalSegundaFerias(ferias.getDataGozoFinal());
                return;
            }
            if (ferias.getDataGozoInicial().equals(dataInicialAbertura) && !ferias.getDataGozoFinal().equals(dataFinalAbertura)) {
                Integer diasFerias = DateUtil.diferenceDayBetweenDates(ferias.getDataGozoInicial(), ferias.getDataGozoFinal()) + 1;
                vo.setDiasFerias(Double.valueOf(diasFerias.doubleValue() + vo.getDiasFerias()));
                vo.setDataInicialSegundaFerias(ferias.getDataGozoInicial());
                vo.setDataFinalSegundaFerias(ferias.getDataGozoFinal());
                return;
            }
            if (!ferias.getDataGozoInicial().equals(dataInicialAbertura) && ferias.getDataGozoFinal().equals(dataFinalAbertura)) {
                Integer diasFerias = DateUtil.diferenceDayBetweenDates(ferias.getDataGozoInicial(), ferias.getDataGozoFinal()) + 1;
                vo.setDiasFerias(Double.valueOf(diasFerias.doubleValue() + vo.getDiasFerias()));
                vo.setDataInicialSegundaFerias(ferias.getDataGozoInicial());
                vo.setDataFinalSegundaFerias(ferias.getDataGozoFinal());
                return;
            }
            if (ferias.getDataGozoInicial().equals(dataInicialAbertura) && ferias.getDataGozoFinal().equals(dataFinalAbertura)) {
                Integer diasFerias = DateUtil.diferenceDayBetweenDates(ferias.getDataGozoInicial(), ferias.getDataGozoFinal()) + 1;
                vo.setDiasFerias(Double.valueOf(diasFerias.doubleValue() + vo.getDiasFerias()));
                vo.setDataInicialSegundaFerias(ferias.getDataGozoInicial());
                vo.setDataFinalSegundaFerias(ferias.getDataGozoFinal());
                return;
            }
        } else if (this.verificarIgualdadeMesAno(ferias.getDataGozoInicial(), dataFinalAbertura)) {
            g.setTime(ferias.getDataGozoInicial());
            Integer diasFerias = g.getActualMaximum(5) - g.get(5) + 1;
            vo.setDiasFerias(Double.valueOf(diasFerias.doubleValue() + vo.getDiasFerias()));
            vo.setDataInicialSegundaFerias(ferias.getDataGozoInicial());
            vo.setDataFinalSegundaFerias(dataFinalAbertura);
        } else {
            if (this.verificarIgualdadeMesAno(ferias.getDataGozoFinal(), dataFinalAbertura)) {
                g.setTime(ferias.getDataGozoFinal());
                if (!DateUtil.dayFromDate(ferias.getDataGozoFinal()).equals(DateUtil.dayFromDate(dataFinalAbertura))) {
                    g.add(5, 1);
                } else {
                    g.set(5, DateUtil.dayFromDate(ferias.getDataGozoFinal()));
                }
                Integer diasFerias = g.get(5) - g.getActualMinimum(5);
                vo.setDiasFerias(Double.valueOf(diasFerias.doubleValue() + vo.getDiasFerias()));
                vo.setDataInicialSegundaFerias(dataInicialAbertura);
                vo.setDataFinalSegundaFerias(ferias.getDataGozoFinal());
                return;
            }
            return;
        }
    }

    private void getDiasTerceiraFerias(FeriasColaborador ferias, MovimentoFolha vo, Date dataInicialAbertura, Date dataFinalAbertura) {
        GregorianCalendar g = new GregorianCalendar();
        Colaborador c = vo.getColaborador();
        if (this.verificarIgualdadeMesAno(ferias.getDataGozoInicial(), dataFinalAbertura) && this.verificarIgualdadeMesAno(ferias.getDataGozoFinal(), dataFinalAbertura)) {
            if (!ferias.getDataGozoInicial().equals(dataInicialAbertura) && !ferias.getDataGozoFinal().equals(dataFinalAbertura)) {
                Integer diasFerias = DateUtil.diferenceDayBetweenDates(ferias.getDataGozoInicial(), ferias.getDataGozoFinal()) + 1;
                vo.setDiasFerias(Double.valueOf(vo.getDiasFerias() + diasFerias.doubleValue()));
                vo.setDataInicialTerceiraFerias(ferias.getDataGozoInicial());
                vo.setDataFinalTerceirasFerias(ferias.getDataGozoFinal());
                return;
            }
            if (ferias.getDataGozoInicial().equals(dataInicialAbertura) && !ferias.getDataGozoFinal().equals(dataFinalAbertura)) {
                Integer diasFerias = DateUtil.diferenceDayBetweenDates(ferias.getDataGozoInicial(), ferias.getDataGozoFinal()) + 1;
                vo.setDiasFerias(Double.valueOf(diasFerias.doubleValue() + vo.getDiasFerias()));
                vo.setDataInicialTerceiraFerias(ferias.getDataGozoInicial());
                vo.setDataFinalTerceirasFerias(ferias.getDataGozoFinal());
                return;
            }
            if (!ferias.getDataGozoInicial().equals(dataInicialAbertura) && ferias.getDataGozoFinal().equals(dataFinalAbertura)) {
                Integer diasFerias = DateUtil.diferenceDayBetweenDates(ferias.getDataGozoInicial(), ferias.getDataGozoFinal()) + 1;
                vo.setDiasFerias(Double.valueOf(diasFerias.doubleValue() + vo.getDiasFerias()));
                vo.setDataInicialTerceiraFerias(ferias.getDataGozoInicial());
                vo.setDataFinalTerceirasFerias(ferias.getDataGozoFinal());
                return;
            }
            if (ferias.getDataGozoInicial().equals(dataInicialAbertura) && ferias.getDataGozoFinal().equals(dataFinalAbertura)) {
                Integer diasFerias = DateUtil.diferenceDayBetweenDates(ferias.getDataGozoInicial(), ferias.getDataGozoFinal()) + 1;
                vo.setDiasFerias(Double.valueOf(diasFerias.doubleValue() + vo.getDiasFerias()));
                vo.setDataInicialTerceiraFerias(ferias.getDataGozoInicial());
                vo.setDataFinalTerceirasFerias(ferias.getDataGozoFinal());
                return;
            }
        } else if (this.verificarIgualdadeMesAno(ferias.getDataGozoInicial(), dataFinalAbertura)) {
            g.setTime(ferias.getDataGozoInicial());
            Integer diasFerias = g.getActualMaximum(5) - g.get(5) + 1;
            vo.setDiasFerias(Double.valueOf(diasFerias.doubleValue() + vo.getDiasFerias()));
            vo.setDataInicialTerceiraFerias(ferias.getDataGozoInicial());
            vo.setDataFinalTerceirasFerias(dataFinalAbertura);
        } else {
            if (this.verificarIgualdadeMesAno(ferias.getDataGozoFinal(), dataFinalAbertura)) {
                g.setTime(ferias.getDataGozoFinal());
                if (!DateUtil.dayFromDate(ferias.getDataGozoFinal()).equals(DateUtil.dayFromDate(dataFinalAbertura))) {
                    g.add(5, 1);
                } else {
                    g.set(5, DateUtil.dayFromDate(ferias.getDataGozoFinal()));
                }
                Integer diasFerias = g.get(5) - g.getActualMinimum(5);
                vo.setDiasFerias(Double.valueOf(diasFerias.doubleValue() + vo.getDiasFerias()));
                vo.setDataInicialTerceiraFerias(dataInicialAbertura);
                vo.setDataFinalTerceirasFerias(ferias.getDataGozoFinal());
                return;
            }
            return;
        }
    }

    private void setarEventosSegundaFerias(MovimentoFolha mov, Date dataInicial, Date dataFinal, FeriasColaborador f, EmpresaRh empresaRh) throws ExceptionService {
        new UtilCalculoEventosFeriasFolha().buscarEventosSegundaFeriasPorColaborador(mov, f, dataInicial, dataFinal, empresaRh);
    }

    private StatusFolhaPagamento getStatusFolha(Short status) throws ExceptionService {
        return (StatusFolhaPagamento)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOStatusFolhaPagamento(), "codigo", status, 0);
    }

    private void verificarQuitaoUmTerco(MovimentoFolha mov, Date dataInicial, Date dataFinal) {
        String hql = " select distinct ferias  from FeriasColaborador ferias  inner join ferias.quitacao q  where  ferias.periodoAqFeriasColab.colaborador = :colaborador  and  q is not null  and  ferias.dataPagamento between :dataInicial and :dataFinal ";
        List ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)mov.getColaborador()).setDate("dataInicial", dataInicial).setDate("dataFinal", dataFinal).list();
        if (ret != null) {
            new UtilCalculoEventosFeriasFolha().integrarQuitacaoUmTerco(mov, ret);
        }
    }
}

