/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.DapiRessarcimentoST;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GeracaoDapi;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DAOGeracaoDapi
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return GeracaoDapi.class;
    }

    public Object calcularRegistrosLinha70(Date dataInicial, Date dataFinal, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "select sum(lv.valorIcmsSt) as VALOR, np.numeroNota as NUMERO_NOTA, np.serie as SERIE_NOTA, np.dataEmissaoNota as DATA_EMISSAO  from NotaFiscalPropria np inner join np.livrosFiscais lv   inner join lv.cfop cf where lv.empresa =:empresa   and (lv.cancelado<>:cancelado or lv.cancelado is null)  and (lv.dataLivro between :dataIn and :dataFim) and (cf.codigo='1.603' or cf.codigo='2.603') group by np.numeroNota, np.serie, np.dataEmissaoNota";
        Query q = s.createQuery(query);
        q.setEntity("empresa", (Object)empresa);
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setShort("cancelado", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        ArrayList<DapiRessarcimentoST> retorno = new ArrayList<DapiRessarcimentoST>();
        for (HashMap h : lista) {
            Integer numeroNota = (Integer)h.get("NUMERO_NOTA");
            String serieNota = (String)h.get("SERIE_NOTA");
            Date dataEmissao = (Date)h.get("DATA_EMISSAO");
            Double valor = (Double)h.get("VALOR");
            if (!(valor > 0.0)) continue;
            DapiRessarcimentoST vo = new DapiRessarcimentoST();
            vo.setDataEmissaoNota(dataEmissao);
            vo.setDataVisto(dataEmissao);
            vo.setNumeroNota(numeroNota);
            vo.setSerieNota(serieNota);
            vo.setValor(valor);
            retorno.add(vo);
        }
        return retorno;
    }
}

