/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.GeracaoReciboRpa;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DAOGeracaoReciboRPS
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return GeracaoReciboRpa.class;
    }

    public List findReciboRPSAnterior(Colaborador colaborador, Date periodoFolha, Long id, Date dataPagamento) {
        String hql = "   from GeracaoReciboRpa rpa  where  rpa.identificador != :id  and  rpa.colaborador = :colaborador  and  extract(year from rpa.dataPagamento) = :ano   and  extract(month from rpa.dataPagamento) = :mes  and  rpa.dataPagamento <= :dataPagamento ";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("id", id.longValue()).setEntity("colaborador", (Object)colaborador).setInteger("ano", ToolDate.yearFromDate((Object)dataPagamento).intValue()).setInteger("mes", ToolDate.monthFromDate((Date)dataPagamento).intValue()).setDate("dataPagamento", dataPagamento).list();
    }

    public List findReciboRPSAnteriorInss(Colaborador colaborador, Date periodoFolha, Long id, Date dataPagamento) {
        String hql = "   from GeracaoReciboRpa rpa  where  rpa.identificador != :id  and  rpa.colaborador = :colaborador  and  extract(year from rpa.periodoFolha) = :ano   and  extract(month from rpa.periodoFolha) = :mes     ";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("id", id.longValue()).setEntity("colaborador", (Object)colaborador).setInteger("ano", ToolDate.yearFromDate((Object)periodoFolha).intValue()).setInteger("mes", ToolDate.monthFromDate((Date)periodoFolha).intValue()).list();
    }

    public Integer existeReciboPosterior(Colaborador colaborador, Date periodoFolha, Long id, Date dataPagamento) {
        String hql = " select count(rpa.identificador)  from GeracaoReciboRpa rpa  where  rpa.identificador != :id and  rpa.colaborador = :colaborador and rpa.periodoFolha = :periodoFolha and rpa.dataPagamento > :dataPagamento";
        Long ids = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("id", id.longValue()).setEntity("colaborador", (Object)colaborador).setDate("periodoFolha", periodoFolha).setDate("dataPagamento", dataPagamento).uniqueResult();
        if (ids == null || ids == 0L) {
            return 0;
        }
        return 1;
    }

    public List getValorPorRPAAutonomo(Colaborador c, Date dataInicio) {
        String hql = " select  rpa.valorRpa as VALOR_RPA , rpa.tipoCalculoEvento.identificador as EVENTO ,  rpa.identificador as RPA  from GeracaoReciboRpa rpa  left join rpa.itemFolhaAutonomo item  where  item = null  and  rpa.colaborador = :colaborador  and  rpa.periodoFolha =:dataInicio  ";
        List l = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)c).setDate("dataInicio", dataInicio).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        return l;
    }

    public List deleteMovimentoFolhaRPA(Colaborador c, Date dataInicio) {
        String hql = "   from GeracaoReciboRpa rpa  where  (rpa.lancado = 1) and  rpa.colaborador = :colaborador  and  rpa.periodoFolha =:dataInicio  ";
        List l = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)c).setDate("dataInicio", dataInicio).list();
        return l;
    }
}

