/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.Produto;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class DAOGradeCor
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return GradeCor.class;
    }

    public Object findPrimeiraGradeCor(Produto pro) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("from GradeCor g where g.produtoGrade.produto=:produto and g.ativo = :ativo");
        q.setEntity("produto", (Object)pro);
        q.setShort("ativo", (short)1);
        q.setMaxResults(1);
        return q.uniqueResult();
    }

    public List findGradeCor(Long idProduto) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("FROM GradeCor g WHERE g.produtoGrade.produto.identificador = :idProduto and g.ativo =:ativo");
        q.setLong("idProduto", idProduto.longValue());
        q.setShort("ativo", (short)1);
        return q.list();
    }

    public GradeCor findGradeCorCodigoBarras(String codBarras) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("FROM GradeCor g WHERE g.codigoBarras = :codBarras and g.ativo = :ativo");
        q.setString("codBarras", codBarras);
        q.setShort("ativo", (short)1);
        return (GradeCor)q.uniqueResult();
    }

    public GradeCor findfirstGradeCorCodBarrasProduto(String codBarras) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct g FROM GradeCor g inner join g.produtoGrade pg inner join pg.produto p inner join p.codigoBarras c WHERE c.codigoBarras = :codBarras and g.ativo = :ativo");
        q.setString("codBarras", codBarras);
        q.setShort("ativo", (short)1);
        q.setMaxResults(1);
        return (GradeCor)q.uniqueResult();
    }

    public Object existeGradeCorAtivaInativa(Produto pro) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("from GradeCor g where g.produtoGrade.produto=:produto");
        q.setEntity("produto", (Object)pro);
        q.setMaxResults(1);
        return q.uniqueResult();
    }
}

