/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GrupoAnaliseEstoqueGC;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;

public class DAOGrupoAnaliseEstoqueGC
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return GrupoAnaliseEstoqueGC.class;
    }

    public boolean verificarExistenciaAnaliseEstoqueGradeCor(List empresas, GradeCor gc, Long identificador) {
        Session s = CoreBdUtil.getInstance().getSession();
        Criteria c = s.createCriteria(this.getVOClass());
        c.createAlias("grupoAnaliseEstoque", "g");
        c.createAlias("g.empresas", "e");
        c.add((Criterion)Restrictions.eq((String)"gradeCor", (Object)gc));
        for (Object o : empresas) {
            c.add((Criterion)Restrictions.eq((String)"e.identificador", (Object)((Empresa)o).getIdentificador()));
        }
        if (identificador != null) {
            c.add((Criterion)Restrictions.ne((String)"identificador", (Object)identificador));
        }
        c.setProjection(Projections.rowCount());
        Long found = (Long)c.uniqueResult();
        return found > 0L;
    }

    public GrupoAnaliseEstoqueGC findGrupoAnaliseEstoquePorGradeCor(GradeCor gc) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "from GrupoAnaliseEstoqueGC g  where g.gradeCor = :gradeCor  and     exists         (select max(gg.dataAnalise)          from GrupoAnaliseEstoque gg          where gg.identificador = g.grupoAnaliseEstoque.identificador)";
        Query q = s.createQuery(hql);
        q.setEntity("gradeCor", (Object)gc);
        q.setMaxResults(1);
        return (GrupoAnaliseEstoqueGC)q.uniqueResult();
    }
}

