/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.LeadTimeFornProduto;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DAOLeadTimeFornProduto
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return LeadTimeFornProduto.class;
    }

    public List findLeadTimeProduto(GradeCor gradeCor, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select l from LeadTimeFornProduto l inner join l.leadTimeFornecedor lf inner join lf.leadTimeFornEmpresa le where l.gradeCor = :gradeCor and le.empresa =:empresa");
        q.setEntity("gradeCor", (Object)gradeCor);
        q.setEntity("empresa", (Object)empresa);
        return q.list();
    }

    public List findLeadTimeProdutoHash(Long idGradeCor, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select l.identificador           AS ID_LEAD_PRODUTO, u.identificador           AS ID_UNID_FORNECEDOR, f.identificador           AS ID_FORNECEDOR, p.nome                    AS FORNECEDOR, c.descricao               AS CIDADE, un.sigla                  AS SIGLA_UF, l.leadTime                AS LEAD_TIME, l.leadTimeEmissao         AS LEAD_TIME_EMISSAO, l.leadTimePrevFaturamento AS LEAD_TIME_PREV_FATURAMENTO, l.leadTimePrevChegada     AS LEAD_TIME_PREV_CHEGADA, l.ultimaEntrada           AS ULTIMA_ENTRADA from LeadTimeFornProduto l inner join l.leadTimeFornecedor lf inner join lf.unidadeFatFornecedor u inner join u.fornecedor f inner join f.pessoa p inner join p.endereco e inner join e.cidade c inner join c.uf un inner join lf.leadTimeFornEmpresa le where l.gradeCor.identificador = :idGradeCor and le.empresa =:empresa");
        q.setLong("idGradeCor", idGradeCor.longValue());
        q.setEntity("empresa", (Object)empresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public List findLeadTimeProdutoHomologado(GradeCor gradeCor, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select l from LeadTimeFornProduto l inner join l.leadTimeFornecedor lf inner join lf.leadTimeFornEmpresa le where l.gradeCor = :gradeCor and l.homologado = :homologado\n and le.empresa =:empresa");
        q.setEntity("gradeCor", (Object)gradeCor);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("homologado", (short)1);
        return q.list();
    }

    public Integer getLeadTimeMinimo(GradeCor gradeCor, List<Empresa> empresas) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select min(l.leadTime) from LeadTimeFornProduto l inner join l.leadTimeFornecedor f inner join f.leadTimeFornEmpresa le where l.gradeCor = :gradeCor and le.empresa IN(:empresas)");
        q.setEntity("gradeCor", (Object)gradeCor);
        q.setParameterList("empresas", empresas);
        return (Integer)q.uniqueResult();
    }

    public Double getLeadTimeMedio(GradeCor gradeCor, List<Empresa> empresas) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select avg(cast(l.leadTime as double)) from LeadTimeFornProduto l inner join l.leadTimeFornecedor f inner join f.leadTimeFornEmpresa le where l.gradeCor = :gradeCor and le.empresa IN(:empresas)");
        q.setEntity("gradeCor", (Object)gradeCor);
        q.setParameterList("empresas", empresas);
        Double n = (Double)q.uniqueResult();
        return n;
    }

    public Integer getLeadTimeMaximo(GradeCor gradeCor, List<Empresa> empresas) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select max(l.leadTime) from LeadTimeFornProduto l inner join l.leadTimeFornecedor f inner join f.leadTimeFornEmpresa le where l.gradeCor = :gradeCor and le.empresa IN(:empresas)");
        q.setEntity("gradeCor", (Object)gradeCor);
        q.setParameterList("empresas", empresas);
        return (Integer)q.uniqueResult();
    }
}

