/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DAOLoteFabricacao
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return LoteFabricacao.class;
    }

    public void updateLoteFabricacao(Long idLoteFabricacao, String loteFabricacao, Date dataFabricacao, Date dataValidade) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("update LoteFabricacao l set l.loteFabricacao = :loteFabricacao, l.dataFabricacao = :dataFabricacao, l.dataValidade = :dataValidade where l.identificador = :idLoteFabricacao");
        q.setLong("idLoteFabricacao", idLoteFabricacao.longValue());
        q.setString("loteFabricacao", loteFabricacao);
        q.setDate("dataFabricacao", dataFabricacao);
        q.setDate("dataValidade", dataValidade);
        q.executeUpdate();
    }

    public Collection gerarRastLoteFaturamento(Date dataInicial, Date dataFinal, Long idLote, Short tipoEstoque, Integer filtrarProduto, Integer produtoInicial, Integer produtoFinal) {
        ArrayList rastreabilidade = new ArrayList();
        if (tipoEstoque.equals((short)0)) {
            rastreabilidade.addAll(this.getRastreabilidadeEntradas(dataInicial, dataFinal, idLote, tipoEstoque, filtrarProduto, produtoInicial, produtoFinal));
        } else if (tipoEstoque.equals((short)1)) {
            rastreabilidade.addAll(this.getRastreabilidadeSaidas(dataInicial, dataFinal, idLote, tipoEstoque, filtrarProduto, produtoInicial, produtoFinal));
        } else if (tipoEstoque.equals((short)2)) {
            rastreabilidade.addAll(this.getRastreabilidadeEntradas(dataInicial, dataFinal, idLote, tipoEstoque, filtrarProduto, produtoInicial, produtoFinal));
            rastreabilidade.addAll(this.getRastreabilidadeSaidas(dataInicial, dataFinal, idLote, tipoEstoque, filtrarProduto, produtoInicial, produtoFinal));
        }
        return this.getListaOrdencada(rastreabilidade);
    }

    private Collection getRastreabilidadeEntradas(Date dataInicial, Date dataFinal, Long idLote, Short tipoEstoque, Integer filtrarProduto, Integer produtoInicial, Integer produtoFinal) {
        ArrayList entradas = new ArrayList();
        entradas.addAll(this.getRastreabilidadeNotaTerceiros(dataInicial, dataFinal, idLote, filtrarProduto, produtoInicial, produtoFinal));
        entradas.addAll(this.getRastreabilidadeComunicadoProducao(dataInicial, dataFinal, idLote, filtrarProduto, produtoInicial, produtoFinal));
        entradas.addAll(this.getRastreabilidadeImplantacaoSaldo(dataInicial, dataFinal, idLote, filtrarProduto, produtoInicial, produtoFinal));
        return entradas;
    }

    private Collection getRastreabilidadeNotaTerceiros(Date dataInicial, Date dataFinal, Long idLote, Integer filtrarProduto, Integer produtoInicial, Integer produtoFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select  g.itemNotaTerceiros.notaFiscalTerceiros.identificador as identificador,  g.quantidade as quantidade,  g.loteFabricacao.loteFabricacao as loteFabricacao,  g.itemNotaTerceiros.notaFiscalTerceiros.dataEmissao as dataEmissao,  g.itemNotaTerceiros.notaFiscalTerceiros.dataEntrada as dataEntradaSaida,  g.gradeCor.produtoGrade.produto.identificador as idProduto,  g.gradeCor.produtoGrade.produto.nome as nomeProduto,  g.gradeCor.cor.nome as nomeCor  from GradeItemNotaTerceiros g  where g.itemNotaTerceiros.notaFiscalTerceiros.identificador in  (select  nt.identificador  from NotaFiscalTerceiros nt)  and g.loteFabricacao.identificador = :idLote  and g.itemNotaTerceiros.notaFiscalTerceiros.dataEntrada between :dataInicial and :dataFinal  and (:filtrarProduto <> 1 or g.gradeCor.produtoGrade.produto.identificador between :produtoInicial and :produtoFinal) ");
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setLong("idLote", idLote.longValue());
        q.setInteger("filtrarProduto", filtrarProduto.intValue());
        if (filtrarProduto == 1) {
            q.setInteger("produtoInicial", produtoInicial.intValue());
            q.setInteger("produtoFinal", produtoFinal.intValue());
        } else {
            q.setInteger("produtoInicial", 0);
            q.setInteger("produtoFinal", 999999999);
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List gradesGeais = q.list();
        ArrayList<HashMap> entradasNotaTerceiros = new ArrayList<HashMap>();
        for (Object o : gradesGeais) {
            HashMap hash = (HashMap)o;
            Long identificador = (Long)hash.get("identificador");
            Query q2 = s.createQuery("select nt.serie as serie,  nt.numeroNota as numeroNota  from NotaFiscalTerceiros nt  where nt.identificador = :identificador ");
            q2.setLong("identificador", identificador.longValue());
            q2.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List notas = q2.list();
            for (Object ob : notas) {
                HashMap map = (HashMap)ob;
                hash.put("numeroNota", map.get("numeroNota"));
                hash.put("serie", map.get("serie"));
                hash.put("tipoDoc", "Nota Terceiros");
            }
            entradasNotaTerceiros.add(hash);
        }
        return entradasNotaTerceiros;
    }

    private Collection getRastreabilidadeComunicadoProducao(Date dataInicial, Date dataFinal, Long idLote, Integer filtrarProduto, Integer produtoInicial, Integer produtoFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select  c.identificador as identificador,  c.dataEntradaSaida as dataEntradaSaida,  c.dataCadastro as dataCadastro,  g.quantidade as quantidade,  g.loteFabricacao.loteFabricacao as loteFabricacao,  'Comunicado de Producao' as tipoDoc,  g.gradeCor.produtoGrade.produto.identificador as idProduto,  g.gradeCor.produtoGrade.produto.nome as nomeProduto,  g.gradeCor.cor.nome as nomeCor  from ComunicadoProducao c  inner join c.itemComunicadoProducao i  inner join i.gradeItemComunicadoProducao g  where g.loteFabricacao.identificador = :idLote  and c.dataEntradaSaida between :dataInicial and :dataFinal  and (:filtrarProduto <> 1 or g.gradeCor.produtoGrade.produto.identificador between :produtoInicial and :produtoFinal ) ");
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setLong("idLote", idLote.longValue());
        q.setInteger("filtrarProduto", filtrarProduto.intValue());
        if (filtrarProduto == 1) {
            q.setInteger("produtoInicial", produtoInicial.intValue());
            q.setInteger("produtoFinal", produtoFinal.intValue());
        } else {
            q.setInteger("produtoInicial", 0);
            q.setInteger("produtoFinal", 999999999);
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private Collection getRastreabilidadeImplantacaoSaldo(Date dataInicial, Date dataFinal, Long idLote, Integer filtrarProduto, Integer produtoInicial, Integer produtoFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select  c.identificador as identificador, c.dataEntradaSaida as dataEntradaSaida, c.dataCadastro as dataCadastro, g.quantidade as quantidade, g.loteFabricacao.loteFabricacao as loteFabricacao, g.gradeCor.produtoGrade.produto.identificador as idProduto,  g.gradeCor.produtoGrade.produto.nome as nomeProduto, 'Implantacao de Saldo' as tipoDoc,  g.gradeCor.cor.nome as nomeCor from ImplantacaoSaldos c inner join c.itemImplantaSaldo i inner join i.gradeItem g where g.loteFabricacao.identificador = :idLote  and c.dataEntradaSaida between :dataInicial and :dataFinal  and (:filtrarProduto <> 1 or g.gradeCor.produtoGrade.produto.identificador between :produtoInicial and :produtoFinal )");
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setLong("idLote", idLote.longValue());
        q.setInteger("filtrarProduto", filtrarProduto.intValue());
        if (filtrarProduto == 1) {
            q.setInteger("produtoInicial", produtoInicial.intValue());
            q.setInteger("produtoFinal", produtoFinal.intValue());
        } else {
            q.setInteger("produtoInicial", 0);
            q.setInteger("produtoFinal", 999999999);
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private Collection getRastreabilidadeSaidas(Date dataInicial, Date dataFinal, Long idLote, Short tipoEstoque, Integer filtrarProduto, Integer produtoInicial, Integer produtoFinal) {
        ArrayList saidas = new ArrayList();
        saidas.addAll(this.getRastreabilidadeNotaPropria(dataInicial, dataFinal, idLote, filtrarProduto, produtoInicial, produtoFinal));
        saidas.addAll(this.getRastreabilidadeRequisicao(dataInicial, dataFinal, idLote, filtrarProduto, produtoInicial, produtoFinal));
        return saidas;
    }

    private Collection getRastreabilidadeNotaPropria(Date dataInicial, Date dataFinal, Long idLote, Integer filtrarProduto, Integer produtoInicial, Integer produtoFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select  g.itemNotaFiscalPropria.notaFiscalPropria.identificador as identificador,  g.itemNotaFiscalPropria.notaFiscalPropria.naturezaOperacao.entradaSaida as entradaSaida,  g.quantidade as quantidade,  g.loteFabricacao.loteFabricacao as loteFabricacao,  g.itemNotaFiscalPropria.notaFiscalPropria.dataEmissaoNota as dataEmissao,  g.itemNotaFiscalPropria.notaFiscalPropria.dataEntradaSaida as dataEntradaSaida,  g.gradeCor.produtoGrade.produto.identificador as idProduto,  g.gradeCor.produtoGrade.produto.nome as nomeProduto,  g.gradeCor.cor.nome as nomeCor  from GradeItemNotaFiscalPropria g  where g.itemNotaFiscalPropria.notaFiscalPropria.identificador in  (select  np.identificador  from NotaFiscalPropria np)  and g.loteFabricacao.identificador = :idLote  and g.itemNotaFiscalPropria.notaFiscalPropria.dataEntradaSaida between :dataInicial and :dataFinal  and (:filtrarProduto <> 1 or g.gradeCor.produtoGrade.produto.identificador between :produtoInicial and :produtoFinal) ");
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setLong("idLote", idLote.longValue());
        q.setInteger("filtrarProduto", filtrarProduto.intValue());
        if (filtrarProduto == 1) {
            q.setInteger("produtoInicial", produtoInicial.intValue());
            q.setInteger("produtoFinal", produtoFinal.intValue());
        } else {
            q.setInteger("produtoInicial", 0);
            q.setInteger("produtoFinal", 999999999);
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List gradesGeais = q.list();
        ArrayList<HashMap> saidasNotaPropria = new ArrayList<HashMap>();
        for (Object o : gradesGeais) {
            HashMap hash = (HashMap)o;
            Long identificador = (Long)hash.get("identificador");
            Query q2 = s.createQuery("select np.serie as serie,  np.numeroNota as numeroNota  from NotaFiscalPropria np  where np.identificador = :identificador ");
            q2.setLong("identificador", identificador.longValue());
            q2.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List notas = q2.list();
            for (Object ob : notas) {
                HashMap map = (HashMap)ob;
                hash.put("numeroNota", map.get("numeroNota"));
                hash.put("serie", map.get("serie"));
                hash.put("tipoDoc", "Nota Propria");
            }
            saidasNotaPropria.add(hash);
        }
        return saidasNotaPropria;
    }

    private Collection getRastreabilidadeRequisicao(Date dataInicial, Date dataFinal, Long idLote, Integer filtrarProduto, Integer produtoInicial, Integer produtoFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select  c.identificador as identificador, c.dataRequisicao as dataEntradaSaida, c.dataCadastro as dataCadastro, g.quantidade as quantidade, g.loteFabricacao.loteFabricacao as loteFabricacao, g.gradeCor.produtoGrade.produto.identificador as idProduto,  g.gradeCor.produtoGrade.produto.nome as nomeProduto, 'Requisicao' as tipoDoc,  g.gradeCor.cor.nome as nomeCor from Requisicao c inner join c.itensRequisicao i inner join i.gradeItemRequisicao g where g.loteFabricacao.identificador = :idLote  and c.dataRequisicao between :dataInicial and :dataFinal  and (:filtrarProduto <> 1 or g.gradeCor.produtoGrade.produto.identificador between :produtoInicial and :produtoFinal )");
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setLong("idLote", idLote.longValue());
        q.setInteger("filtrarProduto", filtrarProduto.intValue());
        if (filtrarProduto == 1) {
            q.setInteger("produtoInicial", produtoInicial.intValue());
            q.setInteger("produtoFinal", produtoFinal.intValue());
        } else {
            q.setInteger("produtoInicial", 0);
            q.setInteger("produtoFinal", 999999999);
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private Collection getListaOrdencada(List rastreabilidade) {
        if (rastreabilidade != null) {
            Collections.sort(rastreabilidade, new Comparator(this){

                public int compare(Object o1, Object o2) {
                    HashMap hash = (HashMap)o1;
                    HashMap hash2 = (HashMap)o2;
                    return ((Date)hash.get("dataEntradaSaida")).compareTo((Date)hash2.get("dataEntradaSaida"));
                }
            });
            return rastreabilidade;
        }
        return null;
    }

    public LoteFabricacao findMelhorLote(GradeCor gradeCor, Date data, Empresa empresa) throws ExceptionDatabase {
        Session s = CoreBdUtil.getInstance().getSession();
        NativeQuery q = s.createSQLQuery("SELECT FIRST 1 p.ID_LOTE_FABRICACAO FROM SALDO_PRODUTO_DETALHADO(null, null,:produto, :produto, :data, :grade, :grade, null, null, null, null, null, null, null, null, :idEmp, :idEmp, null, null,null,:tipoSaldo,:tipoSaldoQtde,:tipoCarregamento,null,:tipoCentroEstoque,null) P inner join lote_fabricacao l on p.id_lote_fabricacao=l.id_lote_fabricacao order by l.data_fabricacao");
        q.setDate("data", data != null ? data : new Date());
        q.setParameter("idEmp", (Object)(empresa != null ? empresa.getIdentificador() : null));
        q.setParameter("grade", (Object)(gradeCor != null ? gradeCor.getIdentificador() : null));
        q.setParameter("produto", gradeCor != null ? gradeCor.getProdutoGrade().getProduto().getIdentificador() : null);
        q.setInteger("tipoSaldo", 4);
        q.setInteger("tipoSaldoQtde", 2);
        q.setInteger("tipoCarregamento", 2);
        q.setShort("tipoCentroEstoque", EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue().shortValue());
        Integer identificadorLote = (Integer)q.uniqueResult();
        if (identificadorLote != null) {
            return (LoteFabricacao)CoreDAOFactory.getInstance().getDAOLoteFabricacao().findByPrimaryKey(identificadorLote.longValue());
        }
        return null;
    }

    public LoteFabricacao findFirstLote(GradeCor gradeCor, Date data, Empresa empresa) throws ExceptionDatabase {
        Session s = CoreBdUtil.getInstance().getSession();
        NativeQuery q = s.createSQLQuery("SELECT FIRST 1 p.ID_LOTE_FABRICACAO FROM SALDO_PRODUTO_DETALHADO(null, null,:produto, :produto, :data, :grade, :grade, null, null, null, null, null, null, null, null, :idEmp, :idEmp, null, null,null,:tipoSaldo,:tipoSaldoQtde,:tipoCarregamento null, :tipoCentroEstoque, null) P inner join lote_fabricacao l on p.id_lote_fabricacao=l.id_lote_fabricacao order by l.data_fabricacao");
        q.setDate("data", data != null ? data : new Date());
        q.setParameter("idEmp", (Object)(empresa != null ? empresa.getIdentificador() : null));
        q.setParameter("grade", (Object)(gradeCor != null ? gradeCor.getIdentificador() : null));
        q.setParameter("produto", gradeCor != null ? gradeCor.getProdutoGrade().getProduto().getIdentificador() : null);
        q.setInteger("tipoSaldo", 4);
        q.setInteger("tipoSaldoQtde", 1);
        q.setInteger("tipoCarregamento", 2);
        q.setInteger("tipoCentroEstoque", (int)EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue().shortValue());
        Integer identificadorLote = (Integer)q.uniqueResult();
        if (identificadorLote != null) {
            return (LoteFabricacao)CoreDAOFactory.getInstance().getDAOLoteFabricacao().findByPrimaryKey(identificadorLote.longValue());
        }
        return null;
    }
}

