/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EventoEncerramentoManifestoCte;
import com.touchcomp.basementor.model.vo.LoteFaturamentoManifestoCte;
import com.touchcomp.basementor.model.vo.ManifestoCteEletronico;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.TipoCTE;
import com.touchcomp.basementor.model.vo.TipoOperacao;
import com.touchcomp.basementor.model.vo.TipoOperacaoCte;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class DAOManifestoCteEletronicoCore
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return ManifestoCteEletronico.class;
    }

    public List<Cte> pesquisarCteNaoManifestoCte(TipoCTE tipoCte, TipoOperacaoCte tipoOperacaoCte, Date dataEmissaoInicial, Date dataEmissaoFinal, Empresa empresa, List<TipoOperacao> listTipoOperacao) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "FROM Cte c WHERE c.tipoCte = :tipoCte AND c.cteInfo.status = :status AND c.tipoOperacaoCte = :tipoOperacaoCte AND c.dataEmissao BETWEEN :dataEmissaoInicial AND :dataEmissaoFinal AND c.empresa = :empresa AND c.gerarManifestoAut = :gerarManifestoAut AND NOT EXISTS (SELECT t.identificador FROM ManifestoCteEletronico m INNER JOIN m.cte mm INNER JOIN mm.cte t WHERE t.identificador = c.identificador)";
        if (listTipoOperacao != null && !listTipoOperacao.isEmpty()) {
            hql = (String)hql + " AND (";
            int count = 1;
            for (TipoOperacao t : listTipoOperacao) {
                hql = count == 1 ? (String)hql + " c.tipoOperacaoFrete = :tipoOperacao" + String.valueOf(count) : (String)hql + " OR c.tipoOperacaoFrete = :tipoOperacao" + String.valueOf(count);
                ++count;
            }
            hql = (String)hql + ")";
        }
        Query q = s.createQuery((String)hql);
        q.setEntity("tipoCte", (Object)tipoCte);
        q.setEntity("tipoOperacaoCte", (Object)tipoOperacaoCte);
        q.setDate("dataEmissaoInicial", dataEmissaoInicial);
        q.setDate("dataEmissaoFinal", dataEmissaoFinal);
        q.setShort("status", (short)100);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("gerarManifestoAut", EnumConstantsMentorSimNao.SIM.value);
        int countQuery = 1;
        for (TipoOperacao t : listTipoOperacao) {
            q.setEntity("tipoOperacao" + String.valueOf(countQuery), (Object)t);
            ++countQuery;
        }
        return q.list();
    }

    public List<ManifestoCteEletronico> pesquisarManifestoCteParaEncerrar(List<TipoOperacao> listTipoOperacao, Date dataEmissaoInicial, Date dataEmissaoFinal, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "SELECT DISTINCT m FROM ManifestoCteEletronico m INNER JOIN m.cte mc INNER JOIN mc.cte c WHERE m.status = :status AND c.dataEmissao BETWEEN :dataEmissaoInicial AND :dataEmissaoFinal AND m.empresa = :empresa AND (";
        int count = 1;
        for (TipoOperacao t : listTipoOperacao) {
            hql = count == 1 ? (String)hql + " c.tipoOperacaoFrete = :tipoOperacao" + String.valueOf(count) : (String)hql + " OR c.tipoOperacaoFrete = :tipoOperacao" + String.valueOf(count);
            ++count;
        }
        hql = (String)hql + ")";
        Query q = s.createQuery((String)hql);
        q.setShort("status", (short)100);
        q.setDate("dataEmissaoInicial", dataEmissaoInicial);
        q.setDate("dataEmissaoFinal", dataEmissaoFinal);
        q.setEntity("empresa", (Object)empresa);
        int countQuery = 1;
        for (TipoOperacao t : listTipoOperacao) {
            q.setEntity("tipoOperacao" + String.valueOf(countQuery), (Object)t);
            ++countQuery;
        }
        return q.list();
    }

    public List<LoteFaturamentoManifestoCte> pesquisarManifestoCteAutNaoEnviado(Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("FROM LoteFaturamentoManifestoCte l INNER JOIN FETCH l.manifestoCte m WHERE m.status <> :autorizado AND m.status <> :encerrado AND m.status <> :cancelado AND m.empresa = :empresa AND m.enviarManifestoAut = :enviarManifestoAut");
        q.setShort("autorizado", (short)100);
        q.setShort("encerrado", (short)132);
        q.setShort("cancelado", (short)101);
        q.setShort("enviarManifestoAut", EnumConstantsMentorSimNao.SIM.value);
        q.setEntity("empresa", (Object)empresa);
        return q.list();
    }

    public EventoEncerramentoManifestoCte pesquisarExisteEncerramentoManifestoCte(ManifestoCteEletronico manifestoCte) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("FROM EventoEncerramentoManifestoCte e WHERE e.manifestoCteEletronico = :manifestoCte");
        q.setEntity("manifestoCte", (Object)manifestoCte);
        return (EventoEncerramentoManifestoCte)q.uniqueResult();
    }

    public List<ManifestoCteEletronico> pesquisarManifestoCte(Cte cte) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("FROM ManifestoCteEletronico m INNER JOIN FETCH m.cte c INNER JOIN FETCH c.cte ct WHERE ct = :cte");
        q.setEntity("cte", (Object)cte);
        return q.list();
    }

    public List<ManifestoCteEletronico> pesquisarManifestoNotaPropria(NotaFiscalPropria notaPropria) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("FROM ManifestoCteEletronico m INNER JOIN FETCH m.nfe n INNER JOIN FETCH n.nfe nf WHERE nf = :notaPropria");
        q.setEntity("notaPropria", (Object)notaPropria);
        return q.list();
    }

    public List<ManifestoCteEletronico> pesquisarManifestoClienteTomadorServico(UnidadeFatCliente unidadeFatCliente) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT DISTINCT m FROM ManifestoCteEletronico m LEFT JOIN m.nfe n LEFT JOIN n.nfe nf LEFT JOIN m.cte c LEFT JOIN c.cte ct WHERE nf.unidadeFatCliente = :unidadeFatCliente OR ct.clienteTomador = :unidadeFatCliente");
        q.setEntity("unidadeFatCliente", (Object)unidadeFatCliente);
        return q.list();
    }
}

