/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemMovimentoFolha;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.Recisao;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.tools.DateUtil;

public class DAOMovimentoFolha
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return MovimentoFolha.class;
    }

    public void atualizarArquivoDocumento(MovimentoFolha mov) {
        String hql = " update MovimentoFolha mov  set mov.arquivoDoc = null  where  mov = :movimentoFolha ";
        CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("movimentoFolha", (Object)mov).executeUpdate();
    }

    public Integer validarFolhaComplementarComPagamento(Date periodoApuracao, Empresa empresa) {
        String hql = " select coalesce(count(ab.identificador),0)  from AberturaPeriodo ab  where  ab.tipoCalculo.tipoFolha = :folhaPagamento  and  ab.periodoApuracao = :periodoApuracao  and  ab.empresa = :empresa  ";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).setDate("periodoApuracao", periodoApuracao).setEntity("empresa", (Object)empresa).uniqueResult();
        if (ret == null || ret == 0L) {
            return 0;
        }
        return 1;
    }

    public Integer validarExistenciaFolhaPagamento(Date periodoApuracao, Empresa empresa) {
        String hql = " select coalesce(count(ab.identificador),0)  from AberturaPeriodo ab  where  ab.tipoCalculo.tipoFolha = :folhaPagamento  and  ab.periodoApuracao = :periodoApuracao  and  ab.empresa = :empresa  ";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).setDate("periodoApuracao", periodoApuracao).setEntity("empresa", (Object)empresa).uniqueResult();
        if (ret == null || ret == 0L) {
            return 0;
        }
        return 1;
    }

    public List findApuracaoBancoHoras(Colaborador colaborador, Short numeroMeses, Date periodoFolha) {
        Date periodoInicial = DateUtil.nextMonth(periodoFolha, -numeroMeses.shortValue());
        String hql = " select distinct(ap)  from ApuracaoQuantidadeBancoHoras ap  where  ap.colaborador = :colaborador  and  not exists(from ItemIntegracaoBdHoras i             where             i.apuracaoHoras = ap )  and  ap.periodo between :periodoInicial and :periodoFinal ";
        List retorno = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setDate("periodoInicial", periodoInicial).setDate("periodoFinal", periodoFolha).list();
        if (retorno == null || retorno.isEmpty()) {
            return new ArrayList();
        }
        return retorno;
    }

    public MovimentoFolha findMovFolhaDec(MovimentoFolha movPagamento) {
        String hql = " from MovimentoFolha mov  where  mov.colaborador = :colaborador  and  mov.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaDec  and   mov.aberturaPeriodo.dataInicio = :dataInicio ";
        MovimentoFolha movDec = (MovimentoFolha)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)movPagamento.getColaborador()).setShort("folhaDec", EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue().shortValue()).setDate("dataInicio", movPagamento.getAberturaPeriodo().getDataInicio()).uniqueResult();
        return movDec;
    }

    public void deletarIntegracaoPonto(ItemMovimentoFolha item) {
        String hql = " delete from ItemIntegracaoPontoFolha i  where  i.itemFolha = :item ";
        CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("item", (Object)item).executeUpdate();
    }

    public void desvincularItensRecisao(Recisao r) {
        String hql = " update ItemMovimentoRescisao i  set i.lancado = null  where  i.recisao = :r ";
        CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("r", (Object)r).executeUpdate();
    }
}

