/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.MovimentoPneu;
import com.touchcomp.basementor.model.vo.Pneu;
import com.touchcomp.basementor.model.vo.PosicaoTipoVeiculo;
import com.touchcomp.basementor.model.vo.Veiculo;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class DAOMovimentoPneu
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return MovimentoPneu.class;
    }

    public MovimentoPneu getUltimoMovimento(Pneu pneu) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "SELECT distinct(m)    FROM MovimentoPneu m   WHERE m.pneu=:pneu   ORDER BY m.identificador DESC ";
        Query q = s.createQuery(hql);
        q.setEntity("pneu", (Object)pneu);
        q.setMaxResults(1);
        return (MovimentoPneu)q.uniqueResult();
    }

    public MovimentoPneu getUltimoMovimentoPorVeiculo(Veiculo veiculo, PosicaoTipoVeiculo posicaoTipoVeiculo) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "SELECT distinct(m)    FROM MovimentoPneu m   WHERE m.veiculo =:veiculo   AND   m.posicaoTipoVeiculo =:posicaoTipoVeiculo   ORDER BY m.identificador DESC ";
        Query q = s.createQuery(hql);
        q.setEntity("veiculo", (Object)veiculo);
        q.setEntity("posicaoTipoVeiculo", (Object)posicaoTipoVeiculo);
        q.setMaxResults(1);
        MovimentoPneu mov = (MovimentoPneu)q.uniqueResult();
        return mov;
    }

    public MovimentoPneu getMovimentoAterior(Long idMovimento) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "SELECT distinct(m) FROM MovimentoPneu m  WHERE m.identificador!=:idMovimento  ORDER BY m.identificador DESC ";
        Query q = s.createQuery(hql);
        q.setLong("idMovimento", idMovimento.longValue());
        q.setMaxResults(1);
        return (MovimentoPneu)q.uniqueResult();
    }

    public Object getMovimentosPorPneu(Pneu vo) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "FROM MovimentoPneu m  WHERE m.pneu = :pneu  ORDER BY m.identificador ASC ";
        Query q = s.createQuery(hql);
        q.setEntity("pneu", (Object)vo);
        return q.list();
    }

    public List<MovimentoPneu> getUltimoMovimentoPneuVeiculo(Veiculo veiculo) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "SELECT m    FROM MovimentoPneu m   WHERE m.veiculo = :veiculo   AND m.tipoMovimentoPneu.identificador =:movimentoPneu   ORDER BY m.identificador ASC ";
        Query q = s.createQuery(hql);
        q.setLong("movimentoPneu", 2L);
        q.setEntity("veiculo", (Object)veiculo);
        return q.list();
    }

    public Double getTotalOdometroRodadoPorPneu(Pneu pneu) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "SELECT SUM(m.odometroRodado)    FROM MovimentoPneu m   WHERE m.pneu = :pneu";
        Query q = s.createQuery(hql);
        q.setEntity("pneu", (Object)pneu);
        return (Double)q.uniqueResult();
    }
}

