/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CotacaoCompra;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GrupoNecCompra;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OrdemCompra;
import com.touchcomp.basementor.model.vo.PlanejamentoProdLinhaProd;
import com.touchcomp.basementor.model.vo.PlanejamentoProdSobEnc;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.tools.DateUtil;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.hibernate.sql.JoinType;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DAONecessidadeCompra
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return NecessidadeCompra.class;
    }

    public List<HashMap> findNecessidadesCompraAbertas(Usuario usuario, Empresa empresa, OpcoesCompraSuprimentos opcoesCompraSuprimentos, Short filtrarNaturezaOperacao, NaturezaOperacao naturezaOperacao, Short filtrarCentroCusto, CentroCusto centroCusto, Short filtrarUsuarioSolicitante, Usuario usuarioSolicitante, Short filtrarProduto, Produto produto) {
        Criteria criteria = CoreBdUtil.getInstance().getSession().createCriteria(NecessidadeCompra.class);
        criteria.createAlias("liberacaoNecCompraItem", "libItem", JoinType.LEFT_OUTER_JOIN);
        criteria.createAlias("libItem.liberacaoNecCompra", "lib", JoinType.LEFT_OUTER_JOIN);
        criteria.createAlias("gradeCor", "gc", JoinType.INNER_JOIN);
        criteria.createAlias("gc.produtoGrade", "pg", JoinType.INNER_JOIN);
        criteria.createAlias("pg.produto", "pr", JoinType.INNER_JOIN);
        criteria.createAlias("pr.unidadeMedida", "un", JoinType.INNER_JOIN);
        criteria.createAlias("centroCusto", "cc", JoinType.LEFT_OUTER_JOIN);
        criteria.createAlias("grupoNecCompra", "gnc", JoinType.LEFT_OUTER_JOIN);
        criteria.createAlias("usuarioComprador", "uc", JoinType.LEFT_OUTER_JOIN);
        criteria.createAlias("uc.usuarioBasico", "ub", JoinType.LEFT_OUTER_JOIN);
        criteria.createAlias("ub.pessoa", "pe", JoinType.LEFT_OUTER_JOIN);
        ProjectionList projections = Projections.projectionList();
        projections.add(Projections.property((String)"identificador").as("idNecessidadeCompra"));
        projections.add(Projections.property((String)"gc.identificador").as("idGradeCor"));
        projections.add(Projections.property((String)"pr.identificador").as("idProduto"));
        projections.add(Projections.property((String)"pr.codigoAuxiliar").as("codigoAuxiliar"));
        projections.add(Projections.property((String)"pr.nome").as("nomeProduto"));
        projections.add(Projections.property((String)"un.sigla").as("unidadeMedida"));
        projections.add(Projections.property((String)"quantidadeNecessidade").as("quantidadeNecessidade"));
        projections.add(Projections.property((String)"dataCadastro").as("dataCadastro"));
        projections.add(Projections.property((String)"dataNecessidade").as("dataNecessidade"));
        projections.add(Projections.property((String)"tipoNecessidade").as("tipoNecessidade"));
        projections.add(Projections.property((String)"cc.codigo").as("codigoCentroCusto"));
        projections.add(Projections.property((String)"cc.nome").as("nomeCentroCusto"));
        projections.add(Projections.property((String)"gnc.identificador").as("idGrupoNecCompra"));
        projections.add(Projections.property((String)"observacao").as("observacao"));
        projections.add(Projections.property((String)"pe.nome").as("nomeUsuarioComprador"));
        projections.add(Projections.property((String)"lib.dataCadastro").as("dataLiberacaoNecessidade"));
        criteria.setProjection((Projection)projections);
        Disjunction disjunction = Restrictions.disjunction();
        if (opcoesCompraSuprimentos.getExibirNecCompraOutrosUs().equals(EnumConstantsMentorSimNao.NAO.value)) {
            disjunction.add((Criterion)Restrictions.eq((String)"usuarioComprador", (Object)usuario));
            disjunction.add(Restrictions.isNull((String)"usuarioComprador"));
        }
        criteria.add((Criterion)disjunction);
        if (ToolMethods.isEquals((Object)filtrarNaturezaOperacao, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            criteria.add((Criterion)Restrictions.eq((String)"naturezaOperacao", (Object)naturezaOperacao));
        }
        if (ToolMethods.isEquals((Object)filtrarCentroCusto, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            criteria.add((Criterion)Restrictions.eq((String)"centroCusto", (Object)centroCusto));
        }
        if (ToolMethods.isEquals((Object)filtrarUsuarioSolicitante, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            criteria.add((Criterion)Restrictions.eq((String)"usuarioSolicitante", (Object)usuarioSolicitante));
        }
        if (ToolMethods.isEquals((Object)filtrarProduto, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            criteria.add((Criterion)Restrictions.eq((String)"pg.produto", (Object)produto));
        }
        criteria.add(Restrictions.isNull((String)"itemCotacaoCompraGerada"));
        criteria.add((Criterion)Restrictions.eq((String)"empresa", (Object)empresa));
        Disjunction disjunction1 = Restrictions.disjunction();
        disjunction1.add((Criterion)Restrictions.ne((String)"desativarNecessidade", (Object)1));
        disjunction1.add(Restrictions.isNull((String)"desativarNecessidade"));
        criteria.add((Criterion)disjunction1);
        criteria.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return criteria.list();
    }

    public List<HashMap> findNecessidadesCompraAbertasLiberadas(Usuario usuario, Empresa empresa, OpcoesCompraSuprimentos opcoesCompraSuprimentos, Short filtrarNaturezaOperacao, NaturezaOperacao naturezaOperacao, Short filtrarCentroCusto, CentroCusto centroCusto, Short filtrarUsuarioSolicitante, Usuario usuarioSolicitante, Short filtrarProduto, Produto produto) {
        Criteria criteria = CoreBdUtil.getInstance().getSession().createCriteria(NecessidadeCompra.class);
        criteria.createAlias("liberacaoNecCompraItem", "lib", JoinType.INNER_JOIN);
        criteria.createAlias("lib.liberacaoNecCompra", "libNec", JoinType.INNER_JOIN);
        criteria.createAlias("gradeCor", "gc", JoinType.INNER_JOIN);
        criteria.createAlias("gc.produtoGrade", "pg", JoinType.INNER_JOIN);
        criteria.createAlias("pg.produto", "pr", JoinType.INNER_JOIN);
        criteria.createAlias("pr.unidadeMedida", "un", JoinType.INNER_JOIN);
        criteria.createAlias("centroCusto", "cc", JoinType.LEFT_OUTER_JOIN);
        criteria.createAlias("grupoNecCompra", "gnc", JoinType.LEFT_OUTER_JOIN);
        criteria.createAlias("usuarioComprador", "uc", JoinType.LEFT_OUTER_JOIN);
        criteria.createAlias("uc.usuarioBasico", "ub", JoinType.LEFT_OUTER_JOIN);
        criteria.createAlias("ub.pessoa", "pe", JoinType.LEFT_OUTER_JOIN);
        ProjectionList projections = Projections.projectionList();
        projections.add(Projections.property((String)"identificador").as("idNecessidadeCompra"));
        projections.add(Projections.property((String)"gc.identificador").as("idGradeCor"));
        projections.add(Projections.property((String)"pr.identificador").as("idProduto"));
        projections.add(Projections.property((String)"pr.codigoAuxiliar").as("codigoAuxiliar"));
        projections.add(Projections.property((String)"pr.nome").as("nomeProduto"));
        projections.add(Projections.property((String)"un.sigla").as("unidadeMedida"));
        projections.add(Projections.property((String)"quantidadeNecessidade").as("quantidadeNecessidade"));
        projections.add(Projections.property((String)"dataCadastro").as("dataCadastro"));
        projections.add(Projections.property((String)"dataNecessidade").as("dataNecessidade"));
        projections.add(Projections.property((String)"tipoNecessidade").as("tipoNecessidade"));
        projections.add(Projections.property((String)"cc.codigo").as("codigoCentroCusto"));
        projections.add(Projections.property((String)"cc.nome").as("nomeCentroCusto"));
        projections.add(Projections.property((String)"gnc.identificador").as("idGrupoNecCompra"));
        projections.add(Projections.property((String)"observacao").as("observacao"));
        projections.add(Projections.property((String)"pe.nome").as("nomeUsuarioComprador"));
        projections.add(Projections.property((String)"libNec.dataCadastro").as("dataLiberacaoNecessidade"));
        criteria.setProjection((Projection)projections);
        Disjunction disjunction = Restrictions.disjunction();
        if (opcoesCompraSuprimentos.getExibirNecCompraOutrosUs().equals(EnumConstantsMentorSimNao.NAO.value)) {
            disjunction.add((Criterion)Restrictions.eq((String)"usuarioComprador", (Object)usuario));
            disjunction.add(Restrictions.isNull((String)"usuarioComprador"));
        }
        criteria.add((Criterion)disjunction);
        if (ToolMethods.isEquals((Object)filtrarNaturezaOperacao, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            criteria.add((Criterion)Restrictions.eq((String)"naturezaOperacao", (Object)naturezaOperacao));
        }
        if (ToolMethods.isEquals((Object)filtrarCentroCusto, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            criteria.add((Criterion)Restrictions.eq((String)"centroCusto", (Object)centroCusto));
        }
        if (ToolMethods.isEquals((Object)filtrarUsuarioSolicitante, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            criteria.add((Criterion)Restrictions.eq((String)"usuarioSolicitante", (Object)usuarioSolicitante));
        }
        if (ToolMethods.isEquals((Object)filtrarProduto, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            criteria.add((Criterion)Restrictions.eq((String)"pg.produto", (Object)produto));
        }
        criteria.add(Restrictions.isNull((String)"itemCotacaoCompraGerada.identificador"));
        criteria.add(Restrictions.isNotNull((String)"lib.identificador"));
        criteria.add((Criterion)Restrictions.eq((String)"empresa", (Object)empresa));
        Disjunction disjunction1 = Restrictions.disjunction();
        disjunction1.add((Criterion)Restrictions.ne((String)"desativarNecessidade", (Object)1));
        disjunction1.add(Restrictions.isNull((String)"desativarNecessidade"));
        criteria.add((Criterion)disjunction1);
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        criteria.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return criteria.list();
    }

    public Double findSaldoCompraAbertoGradeCor(GradeCor gradeCor, Empresa empresa) {
        Double saldoCompraAberto = 0.0;
        saldoCompraAberto = saldoCompraAberto + this.findSaldoCompraAbertoNecessidadeCompra(gradeCor, empresa);
        saldoCompraAberto = saldoCompraAberto + this.findSaldoCompraAbertoCotacaoCompra(gradeCor, empresa);
        saldoCompraAberto = saldoCompraAberto + this.findSaldoCompraAbertoOrdemCompra(gradeCor, empresa);
        return saldoCompraAberto;
    }

    public Double findSaldoCompraAbertoNecessidadeCompra(GradeCor gradeCor, Empresa empresa) {
        Criteria criteria = CoreBdUtil.getInstance().getSession().createCriteria(NecessidadeCompra.class);
        criteria = criteria.createAlias("gradeCor", "gradeCor");
        criteria = criteria.createAlias("empresa", "empresa");
        criteria.setProjection((Projection)Projections.sum((String)"quantidadeNecessidade"));
        criteria.add(Restrictions.isNull((String)"itemCotacaoCompraGerada"));
        criteria.add((Criterion)Restrictions.eq((String)"gradeCor.identificador", (Object)gradeCor.getIdentificador()));
        criteria.add((Criterion)Restrictions.ne((String)"desativarNecessidade", (Object)1));
        criteria.add((Criterion)Restrictions.eq((String)"empresa.identificador", (Object)empresa.getIdentificador()));
        Double ret = (Double)criteria.uniqueResult();
        return ret != null ? ret : 0.0;
    }

    public Double findSaldoCompraAbertoCotacaoCompra(GradeCor gradeCor, Empresa empresa) {
        Criteria criteria = CoreBdUtil.getInstance().getSession().createCriteria(CotacaoCompra.class);
        criteria = criteria.createAlias("itensCotacaoCompra", "itemCotacaoCompra");
        criteria = criteria.createAlias("itemCotacaoCompra.gradeCor", "gradeCor");
        criteria = criteria.createAlias("empresa", "empresa");
        criteria.setProjection((Projection)Projections.sum((String)"itemCotacaoCompra.quantidade"));
        criteria.add(Restrictions.isEmpty((String)"ordensCompra"));
        criteria.add((Criterion)Restrictions.eq((String)"fechada", (Object)0));
        criteria.add((Criterion)Restrictions.eq((String)"gradeCor.identificador", (Object)gradeCor.getIdentificador()));
        criteria.add((Criterion)Restrictions.eq((String)"empresa.identificador", (Object)empresa.getIdentificador()));
        Double ret = (Double)criteria.uniqueResult();
        return ret != null ? ret : 0.0;
    }

    public Double findSaldoCompraAbertoOrdemCompra(GradeCor gradeCor, Empresa empresa) {
        Criteria criteria = CoreBdUtil.getInstance().getSession().createCriteria(OrdemCompra.class);
        criteria = criteria.createAlias("itemOrdemCompra", "itemOrdemCompra");
        criteria = criteria.createAlias("itemOrdemCompra.gradeItemOrdemCompra", "gradeItemOrdemCompra");
        criteria = criteria.createAlias("gradeItemOrdemCompra.gradeCor", "gradeCor");
        criteria = criteria.createAlias("itemOrdemCompra.itemRecepcaoMercadorias", "itemRecepcaoMercadorias", JoinType.LEFT_OUTER_JOIN);
        criteria = criteria.createAlias("itemRecepcaoMercadorias.gradeItemRecMercadorias", "gradeItemRecMercadorias", JoinType.LEFT_OUTER_JOIN);
        criteria = criteria.createAlias("statusOrdemCompra", "statusOrdemCompra");
        criteria = criteria.createAlias("empresa", "empresa");
        ProjectionList projections = Projections.projectionList();
        projections.add(Projections.sum((String)"itemOrdemCompra.quantidadeTotal").as("quantidadeTotal"));
        projections.add(Projections.sum((String)"gradeItemRecMercadorias.quantidade").as("quantidadeRecebida"));
        criteria.setProjection((Projection)projections);
        criteria.add((Criterion)Restrictions.eq((String)"statusOrdemCompra.status", (Object)0));
        criteria.add((Criterion)Restrictions.eq((String)"itemOrdemCompra.fechado", (Object)0));
        criteria.add((Criterion)Restrictions.eq((String)"gradeCor.identificador", (Object)gradeCor.getIdentificador()));
        criteria.add((Criterion)Restrictions.eq((String)"empresa.identificador", (Object)empresa.getIdentificador()));
        criteria.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        HashMap ret = (HashMap)criteria.uniqueResult();
        Double quantidadeTotal = ret.get("quantidadeTotal") != null ? (Double)ret.get("quantidadeTotal") : 0.0;
        Double quantidadeRecebida = ret.get("quantidadeRecebida") != null ? (Double)ret.get("quantidadeRecebida") : 0.0;
        return quantidadeTotal - quantidadeRecebida;
    }

    public Integer findPrazoMedioEntregaProdutoNotaFiscalTerceiros(GradeCor gradeCor) {
        Integer ret = 0;
        Criteria criteria = CoreBdUtil.getInstance().getSession().createCriteria(ItemNotaTerceiros.class);
        criteria = criteria.createAlias("notaFiscalTerceiros", "notaFiscalTerceiros");
        criteria = criteria.createAlias("grade", "grade");
        criteria = criteria.createAlias("grade.gradeCor", "gradeCor");
        ProjectionList projections = Projections.projectionList();
        projections.add(Projections.property((String)"notaFiscalTerceiros.dataEmissao").as("dataEmissao"));
        projections.add(Projections.property((String)"notaFiscalTerceiros.dataEntrada").as("dataEntrada"));
        criteria.setProjection((Projection)projections);
        criteria.add((Criterion)Restrictions.eq((String)"gradeCor.identificador", (Object)gradeCor.getIdentificador()));
        criteria.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List results = criteria.list();
        if (results != null && !results.isEmpty()) {
            for (HashMap map : results) {
                Date dataEmissao = (Date)map.get("dataEmissao");
                Date dataEntrada = (Date)map.get("dataEntrada");
                ret = ret + DateUtil.diferenceDayBetweenDates(dataEmissao, dataEntrada);
            }
            ret = ret / results.size();
        }
        return ret != null && ret > 0 ? ret : null;
    }

    public List pesquisarNecCompraNaoLiberadas(Date dataInicial, Date dataFinal, Empresa empresa, Short filtrarGrupoNecessidadeCompra, GrupoNecCompra grupoNecessidadeCompra, Short filtrarUsuarioSolicitante, Usuario usuarioSolicitante, Short filtrarCentroCusto, CentroCusto centroCusto) {
        Criteria criteria = CoreBdUtil.getInstance().getSession().createCriteria(NecessidadeCompra.class);
        criteria.createAlias("liberacaoNecCompraItem", "lib", JoinType.LEFT_OUTER_JOIN);
        criteria.add(Restrictions.between((String)"dataNecessidade", (Object)dataInicial, (Object)dataFinal));
        criteria.add((Criterion)Restrictions.eq((String)"empresa", (Object)empresa));
        if (ToolMethods.isEquals((Object)filtrarGrupoNecessidadeCompra, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            criteria.add((Criterion)Restrictions.eq((String)"grupoNecCompra", (Object)grupoNecessidadeCompra));
        }
        if (ToolMethods.isEquals((Object)filtrarUsuarioSolicitante, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            criteria.add((Criterion)Restrictions.eq((String)"usuarioSolicitante", (Object)usuarioSolicitante));
        }
        if (ToolMethods.isEquals((Object)filtrarCentroCusto, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            criteria.add((Criterion)Restrictions.eq((String)"centroCusto", (Object)centroCusto));
        }
        criteria.add(Restrictions.isNull((String)"lib.identificador"));
        Disjunction disjunction1 = Restrictions.disjunction();
        disjunction1.add((Criterion)Restrictions.ne((String)"desativarNecessidade", (Object)1));
        disjunction1.add(Restrictions.isNull((String)"desativarNecessidade"));
        criteria.add((Criterion)disjunction1);
        return criteria.list();
    }

    public List<PlanejamentoProdLinhaProd> pesqPlanejProdLinProdParaGerarNecCompra() {
        Criteria criteria = CoreBdUtil.getInstance().getSession().createCriteria(PlanejamentoProdLinhaProd.class);
        criteria.add((Criterion)Restrictions.eq((String)"liberarCompras", (Object)1));
        criteria.add(Restrictions.isNull((String)"grupoNecCompra"));
        return criteria.list();
    }

    public List<PlanejamentoProdLinhaProd> pesqPlanejProdLinProdParaGerarNecCompraSobEnc() {
        Criteria criteria = CoreBdUtil.getInstance().getSession().createCriteria(PlanejamentoProdSobEnc.class);
        criteria.add((Criterion)Restrictions.eq((String)"liberarCompras", (Object)1));
        criteria.add(Restrictions.isNull((String)"grupoNecCompra"));
        return criteria.list();
    }

    public List<HashMap> pesquisarUltimosEmailSolicitanteGrupo(Usuario usuarioSolicitante) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT e.email AS EMAIL FROM GrupoNecCompra g INNER JOIN g.emailGrupoNecCompra e WHERE g.identificador = ( SELECT MAX(n.identificador) FROM GrupoNecCompra n INNER JOIN n.emailGrupoNecCompra c WHERE n.usuarioSolicitante = :usuarioSolicitante AND c IS NOT NULL)");
        q.setEntity("usuarioSolicitante", (Object)usuarioSolicitante);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public List<HashMap> pesquisarUltimosEmailSolicitanteNecessidade(Usuario usuarioSolicitante) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT e.email AS EMAIL FROM NecessidadeCompra g INNER JOIN g.emailGrupoNecCompra e WHERE g.identificador = ( SELECT MAX(n.identificador) FROM NecessidadeCompra n INNER JOIN n.emailGrupoNecCompra c WHERE n.usuarioSolicitante = :usuarioSolicitante AND c IS NOT NULL)");
        q.setEntity("usuarioSolicitante", (Object)usuarioSolicitante);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }
}

