/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.VersaoMentorControle;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DAONodo
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return Nodo.class;
    }

    public Nodo findNodoPrincipal() {
        Session s = null;
        s = CoreBdUtil.getInstance().getSession();
        Criteria c = s.createCriteria(this.getVOClass());
        c.setMaxResults(1);
        c.add((Criterion)Restrictions.eq((String)"principal", (Object)1));
        return (Nodo)c.uniqueResult();
    }

    public List getNodosModificados(VersaoMentorControle v) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("from Nodo n where cast(n.dataAtualizacao as date)>= :dataIn  and cast(n.dataAtualizacao as date)<=:dataFim");
        q.setDate("dataIn", v.getVersaoDisponibilizada().getDataFinal());
        q.setDate("dataFim", v.getDataFinal());
        return q.list();
    }

    public List findTopicosAjudaModificados(VersaoMentorControle v) {
        Session s = CoreBdUtil.getInstance().getSession();
        String st = "select t.identificador as ID_TOPICO_AJUDA,t.url as URL_TOPICO_AJUDA,t.descricao as DESCRICAO,t.modoAbrir as MODO_ABRIR,n.identificador as ID_NODO from Nodo n  inner join n.topicoAjuda t  where t.dataAtualizacao >=:data";
        Query q = s.createQuery(st);
        q.setDate("data", v.getVersaoDisponibilizada().getDataInicial());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }
}

