/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import java.util.Date;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DAONotaFiscalPropria
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return NotaFiscalPropria.class;
    }

    public Object getItensNotaPropriaIMASICCA(Date dataInicial, Date dataFinal, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT n.empresa.pessoa.complemento.cnpj AS CNPJ, n.naturezaOperacao.entradaSaida AS TIPO_MOVIMENTACAO, n.numeroNota AS NUMERO_NOTA, n.serie AS SERIE_NOTA, n.dataEmissaoNota AS DATA_ENTRADA_SAIDA, n.unidadeFatCliente.pessoa.nome AS RAZAO_SOCIAL, n.unidadeFatCliente.pessoa.complemento.cnpj AS CPF_CNPJ, n.unidadeFatCliente.pessoa.endereco.logradouro AS ENDERECO, CONCAT(n.unidadeFatCliente.pessoa.endereco.cidade.uf.codIbge, n.unidadeFatCliente.pessoa.endereco.cidade.codIbge) AS CODIGO_MUNICIPIO, n.unidadeFatCliente.pessoa.nomeFantasia AS NOME_PROPRIEDADE, n.unidadeFatCliente.pessoa.complemento.inscEst AS INSCRICAO_ESTADUAL_PROPRIEDADE, CONCAT(n.unidadeFatCliente.pessoa.endereco.cidade.uf.codIbge, n.unidadeFatCliente.pessoa.endereco.cidade.codIbge) AS CODIGO_MUNICIPIO_PROPRIEDADE, i.produto.defensivo.numeroRegMAPA AS NR_REGISTRO_AGROTOXICO_MAPA, i.quantidadeTotal AS QUANTIDADE, i.produto.defensivo.embalagem AS EMBALAGEM FROM NotaFiscalPropria n INNER JOIN n.itensNotaPropria i WHERE n.dataEmissaoNota BETWEEN :dataInicial AND :dataFinal AND n.empresa = :empresa AND i.produto.ativo = 1");
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public Double searchMeiosPagamento(Date data) {
        Query query = CoreBdUtil.getInstance().getSession().createQuery("select sum(n.valoresNfPropria.valorTotal) as VALOR_TOTAL from NotaFiscalPropria n where n.dataEmissaoNota = :data ");
        query.setDate("data", data);
        return (Double)query.uniqueResult();
    }
}

