/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.constants.enums.confnfterceiros.EnumConstTipoConfNFTercItens;
import com.touchcomp.basementor.constants.enums.relacionamentopessoa.EnumConstTipoConfNFProduto;
import com.touchcomp.basementor.model.vo.ConsultaNFeDestNFe;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.Produto;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.CoreRequestContext;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.hibernate.sql.JoinType;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DAONotaFiscalTerceiros
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return NotaFiscalTerceiros.class;
    }

    public Object getItensNotaTerceirosIMASICCA(Date dataInicial, Date dataFinal, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT n.empresa.pessoa.complemento.cnpj AS CNPJ, n.numeroNota AS NUMERO_NOTA, n.serie AS SERIE_NOTA, n.dataEntrada AS DATA_ENTRADA_SAIDA, n.unidadeFatFornecedor.fornecedor.pessoa.nome AS RAZAO_SOCIAL, n.unidadeFatFornecedor.fornecedor.pessoa.complemento.cnpj AS CPF_CNPJ, n.unidadeFatFornecedor.fornecedor.pessoa.endereco.logradouro AS ENDERECO, CONCAT(n.unidadeFatFornecedor.fornecedor.pessoa.endereco.cidade.uf.codIbge, n.unidadeFatFornecedor.fornecedor.pessoa.endereco.cidade.codIbge) AS CODIGO_MUNICIPIO, n.unidadeFatFornecedor.pessoa.nome AS NOME_PROPRIEDADE, n.unidadeFatFornecedor.pessoa.complemento.inscEst AS INSCRICAO_ESTADUAL_PROPRIEDADE, CONCAT(n.unidadeFatFornecedor.pessoa.endereco.cidade.codIbge, n.unidadeFatFornecedor.pessoa.endereco.cidade.uf.codIbge) AS CODIGO_MUNICIPIO_PROPRIEDADE, i.produto.defensivo.numeroRegMAPA AS NR_REGISTRO_AGROTOXICO_MAPA, i.quantidadeTotal AS QUANTIDADE, i.produto.defensivo.embalagem AS EMBALAGEM FROM NotaFiscalTerceiros n INNER JOIN n.itemNotaTerceiros i WHERE n.dataEntrada BETWEEN :dataInicial AND :dataFinal AND n.empresa = :empresa AND i.produto.ativo = 1");
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public Object findUltimaNaturezaFreteUsada(Produto produto, Fornecedor fornecedor, ModeloFiscal modelo) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT distinct n.naturezaFrete FROM NotaFiscalTerceiros n INNER JOIN n.itemNotaTerceiros i WHERE i.produto = :produto AND i.modeloFiscal = :modelo AND n.unidadeFatFornecedor.fornecedor = :fornecedor");
        q.setEntity("produto", (Object)produto);
        q.setEntity("fornecedor", (Object)fornecedor);
        q.setEntity("modelo", (Object)modelo);
        q.setMaxResults(1);
        return q.uniqueResult();
    }

    public HashMap findUltPrecoCustoData(Long idProduto, Long empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "select coalesce(g.valorCusto,0) as ULT_VALOR_CUSTO, g.dataEntradaSaida as DATA_ULT_CUSTO, n.numeroNota as NUMERO_NOTA from NotaFiscalTerceiros n  inner join n.empresa e  inner join n.itemNotaTerceiros it  inner join it.grade g where  e.identificador=:empresa and it.produto.identificador=:produto and  n.dataEntrada=(select max( n1.dataEntrada) from NotaFiscalTerceiros n1  inner join n1.itemNotaTerceiros it1 where  it1.produto =it.produto and  n1.empresa =:empresa) order by g.identificador desc";
        Query q = s.createQuery(query);
        q.setLong("produto", idProduto.longValue());
        q.setLong("empresa", empresa.longValue());
        q.setMaxResults(1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        HashMap<String, Double> res = (HashMap<String, Double>)q.uniqueResult();
        if (res == null) {
            res = new HashMap<String, Double>();
            res.put("ULT_VALOR_CUSTO", 0.0);
        }
        return res;
    }

    public List findItemNotaBem(CoreRequestContext request) {
        Long fornecedorInicial = (Long)request.getAttribute("fornecedorInicial");
        Long fornecedorFinal = (Long)request.getAttribute("fornecedorFinal");
        Long produtoInicial = (Long)request.getAttribute("produtoInicial");
        Long produtoFinal = (Long)request.getAttribute("produtoFinal");
        Short filtrarFornecedor = (Short)request.getAttribute("filtrarFornecedor");
        Short filtrarProduto = (Short)request.getAttribute("filtrarProduto");
        Date dataInicial = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        Integer nrInicial = (Integer)request.getAttribute("nrInicial");
        Integer nrFinal = (Integer)request.getAttribute("nrFinal");
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "select i from NotaFiscalTerceiros n inner join n.itemNotaTerceiros i where n.numeroNota between :nrInicial and :nrFinal and (:filtrarFornecedor <> 1 or n.unidadeFatFornecedor.fornecedor.identificador between :fornecedorInicial and :fornecedorFinal )and (:filtrarProduto <> 1 or i.produto.identificador between :produtoInicial and :produtoFinal ) and n.dataEntrada between :dataInicial and :dataFinal";
        Query q = s.createQuery(query);
        q.setShort("filtrarFornecedor", filtrarFornecedor.shortValue());
        q.setShort("filtrarProduto", filtrarProduto.shortValue());
        q.setLong("fornecedorInicial", fornecedorInicial.longValue());
        q.setLong("fornecedorFinal", fornecedorFinal.longValue());
        q.setLong("produtoInicial", produtoInicial.longValue());
        q.setLong("produtoFinal", produtoFinal.longValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setInteger("nrInicial", nrInicial.intValue());
        q.setInteger("nrFinal", nrFinal.intValue());
        return q.list();
    }

    public Object findUltimosPrecosCustoProdutos(Long idProduto, Long empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "select coalesce(g.valorCusto,0) as ULT_VALOR_CUSTO, g.dataEntradaSaida as DATA_ULT_CUSTO , it.naturezaOperacao.descricao as NATUREZA_OPERACAO, n.unidadeFatFornecedor.fornecedor.pessoa.nome as FORNECEDOR, n.numeroNota as NUMERO_NF, e.identificador as ID_EMPRESA, p.nome as EMPRESA from NotaFiscalTerceiros n  inner join n.empresa e  inner join e.pessoa p  inner join n.itemNotaTerceiros it  inner join it.grade g where  e.identificador=:empresa and it.produto.identificador=:produto  order by g.dataEntradaSaida desc";
        Query q = s.createQuery(query);
        q.setLong("produto", idProduto.longValue());
        q.setLong("empresa", empresa.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        q.setMaxResults(30);
        return q.list();
    }

    public Object findUltimosPrecosCustoProdutosIndEmp(Long produto) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "select coalesce(g.valorCusto,0) as ULT_VALOR_CUSTO, g.dataEntradaSaida as DATA_ULT_CUSTO,  it.naturezaOperacao.descricao as NATUREZA_OPERACAO, n.unidadeFatFornecedor.fornecedor.pessoa.nome as FORNECEDOR, n.numeroNota as NUMERO_NF, e.identificador as ID_EMPRESA, p.nome as EMPRESA from NotaFiscalTerceiros n  inner join n.itemNotaTerceiros it  inner join n.empresa e  inner join e.pessoa p  inner join it.grade g where  it.produto.identificador=:produto  order by g.dataEntradaSaida desc";
        Query q = s.createQuery(query);
        q.setLong("produto", produto.longValue());
        q.setMaxResults(30);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public List findNotasNaoManifestadas() {
        Criteria c = CoreBdUtil.getInstance().getSession().createCriteria(ConsultaNFeDestNFe.class);
        c.createAlias("situacaoManifestoNFe", "s", JoinType.LEFT_OUTER_JOIN);
        c.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"situacaoManifestoNFe"), (Criterion)Restrictions.eq((String)"s.codEvento", (Object)0)));
        return c.list();
    }

    public List<NotaFiscalTerceiros> findNotasNaoLiberadasQualidade(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesCompraSuprimentos opcoesCompras) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "select n FROM NotaFiscalTerceiros n  LEFT JOIN n.liberacaoNFTerceiros l  WHERE n.dataEntrada between :dataInicial and :dataFinal  AND (l is null or l.liberacaoQualidade is null) ";
        if (opcoesCompras.getTipoConfNFTerceirosItens() == EnumConstTipoConfNFTercItens.CONF_CADASTRO_PROD.value) {
            hql = (String)hql + " AND EXISTS (select i.identificador  from ItemNotaTerceiros i  inner join i.produto p  where i.notaFiscalTerceiros = n  and p.tipoConfNFTerceirosProduto.tipo = :conferir)";
        }
        hql = (String)hql + " AND n.empresa = :empresa ";
        Query q = s.createQuery((String)hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        if (opcoesCompras.getTipoConfNFTerceirosItens() == EnumConstTipoConfNFTercItens.CONF_CADASTRO_PROD.value) {
            q.setShort("conferir", EnumConstTipoConfNFProduto.CONFERIR.value);
        }
        return q.list();
    }

    public List<NotaFiscalTerceiros> findNotasNaoLiberadasFinanceiro(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesCompraSuprimentos opcoesCompras) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "select n FROM NotaFiscalTerceiros n  LEFT JOIN n.liberacaoNFTerceiros l  WHERE n.dataEntrada between :dataInicial and :dataFinal  AND (l is null or l.liberacaoFinanceira is null) ";
        if (opcoesCompras.getTipoConfNFTerceirosItens() == EnumConstTipoConfNFTercItens.CONF_CADASTRO_PROD.value) {
            hql = (String)hql + " AND EXISTS (select i.identificador  from ItemNotaTerceiros i  inner join i.produto p  where i.notaFiscalTerceiros = n  and p.tipoConfNFTerceirosProduto.tipo = :conferir)";
        }
        hql = (String)hql + " AND n.empresa = :empresa ";
        Query q = s.createQuery((String)hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        if (opcoesCompras.getTipoConfNFTerceirosItens() == EnumConstTipoConfNFTercItens.CONF_CADASTRO_PROD.value) {
            q.setShort("conferir", EnumConstTipoConfNFProduto.CONFERIR.value);
        }
        return q.list();
    }

    public List<NotaFiscalTerceiros> findNotasNaoLiberadasEstoque(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesCompraSuprimentos opcoesCompras) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "select n FROM NotaFiscalTerceiros n  LEFT JOIN n.liberacaoNFTerceiros l  WHERE n.dataEntrada between :dataInicial and :dataFinal  AND (l is null or l.liberacaoEstoque is null) ";
        if (opcoesCompras.getTipoConfNFTerceirosItens() == EnumConstTipoConfNFTercItens.CONF_CADASTRO_PROD.value) {
            hql = (String)hql + " AND EXISTS (select i.identificador  from ItemNotaTerceiros i  inner join i.produto p  where i.notaFiscalTerceiros = n  and p.tipoConfNFTerceirosProduto.tipo = :conferir)";
        }
        hql = (String)hql + " AND n.empresa = :empresa ";
        Query q = s.createQuery((String)hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        if (opcoesCompras.getTipoConfNFTerceirosItens() == EnumConstTipoConfNFTercItens.CONF_CADASTRO_PROD.value) {
            q.setShort("conferir", EnumConstTipoConfNFProduto.CONFERIR.value);
        }
        return q.list();
    }

    public List<NotaFiscalTerceiros> findNotasNaoLiberadasFiscal(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesCompraSuprimentos opcoesCompras) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "select n FROM NotaFiscalTerceiros n  LEFT JOIN n.liberacaoNFTerceiros l  WHERE n.dataEntrada between :dataInicial and :dataFinal  AND (l is null or l.liberacaoFiscal is null) ";
        if (opcoesCompras.getTipoConfNFTerceirosItens() == EnumConstTipoConfNFTercItens.CONF_CADASTRO_PROD.value) {
            hql = (String)hql + " AND EXISTS (select i.identificador  from ItemNotaTerceiros i  inner join i.produto p  where i.notaFiscalTerceiros = n  and p.tipoConfNFTerceirosProduto.tipo = :conferir)";
        }
        hql = (String)hql + " AND n.empresa = :empresa ";
        Query q = s.createQuery((String)hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        if (opcoesCompras.getTipoConfNFTerceirosItens() == EnumConstTipoConfNFTercItens.CONF_CADASTRO_PROD.value) {
            q.setShort("conferir", EnumConstTipoConfNFProduto.CONFERIR.value);
        }
        return q.list();
    }

    public List<NotaFiscalTerceiros> findNotasLivroFiscalProvisionado(Date dataInicial, Date dataFinal, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select n FROM NotaFiscalTerceiros n  INNER JOIN n.livrosFiscais lv  WHERE n.dataEntrada between :dataInicial and :dataFinal  AND n.empresa = :empresa AND lv.cancelado = :sim";
        Query q = s.createQuery(hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("sim", (short)1);
        return q.list();
    }
}

