/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.constants.enums.ordemcompra.EnumConstOrdemCompraStatus;
import com.touchcomp.basementor.model.vo.LiberacaoOrdemCompra;
import com.touchcomp.basementor.model.vo.OrdemCompra;
import java.util.List;
import java.util.Map;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DAOOrdemCompra
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return OrdemCompra.class;
    }

    public Object putDadosOrdemCompra(Number idGradeCor) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = " select   i.identificador as ID_GRADE,  ioc.fatorConversao AS FATOR_CONVERSAO, coalesce(i.quantidade - coalesce(sum(g.quantidade),0),0) as QUANTIDADE_COMPRADA  from GradeItemOrdemCompra i   left join i.gradeItemRecepcaoMercadorias g  inner join i.itemOrdemCompra ioc where i.gradeCor.identificador=:id_grade_cor  and ioc.ordemCompra.statusOrdemCompra.status = :status  group by  i.identificador ,  i.quantidade, ioc.fatorConversao having  coalesce(i.quantidade - coalesce(sum(g.quantidade),0),0)>0 ";
        Query q = s.createQuery(query);
        q.setLong("id_grade_cor", idGradeCor.longValue());
        q.setShort("status", EnumConstOrdemCompraStatus.ABERTO.value);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List list = q.list();
        Double d = 0.0;
        for (Map m : list) {
            d = d + (Double)m.get("QUANTIDADE_COMPRADA") * (Double)m.get("FATOR_CONVERSAO");
        }
        return d;
    }

    public LiberacaoOrdemCompra getLiberacaoOCIdMobile(Long identificadorMobile) {
        Criteria c = CoreBdUtil.getInstance().getSession().createCriteria(LiberacaoOrdemCompra.class);
        c.add((Criterion)Restrictions.eq((String)"identificadorLibMobile", (Object)identificadorMobile));
        c.setMaxResults(1);
        return (LiberacaoOrdemCompra)c.uniqueResult();
    }
}

