/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ParametrizacaoCtbProduto;
import com.touchcomp.basementor.model.vo.ParametrizacaoCtbRequisicao;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.SubEspecie;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class DAOParametrizacaoCtbProduto
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return ParametrizacaoCtbProduto.class;
    }

    public List findNaturezaRequisicaoProduto(GrupoEmpresa grupoEmpresa, Produto produto) {
        List natRequisicao = this.getNaturezasProduto(grupoEmpresa, produto);
        natRequisicao.addAll(this.getNaturezasSubespecie(grupoEmpresa, produto.getSubEspecie()));
        return natRequisicao;
    }

    private List getNaturezasProduto(GrupoEmpresa grupoEmpresa, Produto produto) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct p.parametrizacaoCtbRequisicao.naturezaRequisicao from ParametrizacaoCtbProduto p where p.parametrizacaoCtbRequisicao.grupoEmpresa=:grupo and p.produto=:produto");
        q.setEntity("grupo", (Object)grupoEmpresa);
        q.setEntity("produto", (Object)produto);
        return q.list();
    }

    private List getNaturezasSubespecie(GrupoEmpresa grupoEmpresa, SubEspecie subEspecie) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct p.parametrizacaoCtbRequisicao.naturezaRequisicao from ParametrizacaoCtbSubEspecie p where p.parametrizacaoCtbRequisicao.grupoEmpresa=:grupo and p.subEspecie=:subEspecie");
        q.setEntity("grupo", (Object)grupoEmpresa);
        q.setEntity("subEspecie", (Object)subEspecie);
        return q.list();
    }

    public Boolean existsProdutoParametrizacao(ParametrizacaoCtbRequisicao parametrizacaoCtbRequisicao, Produto produto) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct p from ParametrizacaoCtbProduto p where     p.parametrizacaoCtbRequisicao =:parametrizacaoCtbRequisicao and     p.produto =:produto");
        q.setEntity("parametrizacaoCtbRequisicao", (Object)parametrizacaoCtbRequisicao);
        q.setEntity("produto", (Object)produto);
        List lista = q.list();
        if (lista == null || lista.isEmpty()) {
            return false;
        }
        return true;
    }
}

