/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.Expedicao;
import com.touchcomp.basementor.model.vo.LiberacaoPedido;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.SituacaoPedidos;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DAOPedido
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return Pedido.class;
    }

    public Pedido findPedidoMobile(Long idPedidoMobile, Integer usuario) {
        BigInteger b = new BigInteger(String.valueOf(idPedidoMobile));
        Criteria c = CoreBdUtil.getInstance().getSession().createCriteria(Pedido.class);
        c.createAlias("usuario", "usu");
        c.add((Criterion)Restrictions.eq((String)"usu.identificador", (Object)usuario.longValue()));
        c.add((Criterion)Restrictions.eq((String)"idPedidoMobile", (Object)b));
        return (Pedido)c.uniqueResult();
    }

    public HashMap findInfoSitPedido(Long idPedido) {
        Criteria c = CoreBdUtil.getInstance().getSession().createCriteria(Pedido.class);
        c.createAlias("situacaoPedido", "s");
        ProjectionList pl = Projections.projectionList();
        pl.add(Projections.alias((Projection)Projections.property((String)"s.identificador"), (String)"ID_SIT_PEDIDOS"));
        pl.add(Projections.alias((Projection)Projections.property((String)"s.descricao"), (String)"DESCRICAO_SIT_PEDIDOS"));
        pl.add(Projections.alias((Projection)Projections.property((String)"identificador"), (String)"ID_PEDIDO"));
        c.setProjection((Projection)pl);
        c.add((Criterion)Restrictions.eq((String)"identificador", (Object)idPedido));
        c.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return (HashMap)c.uniqueResult();
    }

    public Object findDadosComissaoRep(Expedicao expedicao) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select p.representante as representante,coalesce(p.percComissao,0) as percComissao,coalesce(p.valorTotal,0) as valorTotal,p.percDescFinanceiro as percDescFinanceiro from Pedido p  where p = :pedido and p.situacaoPedido.cancelarTitulos = :nao");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        q.setEntity("pedido", (Object)expedicao.getPedido());
        q.setShort("nao", (short)0);
        HashMap<String, Double> h = (HashMap<String, Double>)q.uniqueResult();
        if (h == null) {
            h = new HashMap<String, Double>();
            h.put("percComissao", 0.0);
            h.put("valorTotal", 0.0);
            h.put("percDescFinanceiro", 0.0);
        }
        return h;
    }

    public List<LiberacaoPedido> getPreLiberacaoClientePed(UnidadeFatCliente unidadeFatCliente) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct l from LiberacaoPedido l where l.unidadeFatCliente=:unidade and (l.liberacaoUtilizada = :nao or l.liberacaoUtilizada is null) and l.tipoLiberacaoPedido = :pre");
        q.setEntity("unidade", (Object)unidadeFatCliente);
        q.setShort("nao", (short)0);
        q.setShort("pre", (short)0);
        return q.list();
    }

    public void atualizaArquivoDocumento(Pedido pedido) {
        Query q = CoreBdUtil.getInstance().getSession().createQuery("update Pedido p set p.arquivoDoc = null where p = :pedido");
        q.setEntity("pedido", (Object)pedido);
        q.executeUpdate();
    }

    public List findPedidoFilhos(Long idPedido) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select p from Pedido p  left join p.pedidoPai ppai where  ppai.identificador = :idPedido ");
        q.setLong("idPedido", idPedido.longValue());
        return q.list();
    }

    public List findPedidosNaoFaturadosCliente(UnidadeFatCliente u) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select p  from Pedido p  inner join p.situacaoPedido sit  where not exists (select e.identificador                      from Expedicao e                      inner join e.notaFiscalPropria np                      where e.pedido = p)  and p.unidadeFatCliente = :unidadeFatCli  and sit.cancelarTitulos <> :ativo");
        q.setEntity("unidadeFatCli", (Object)u);
        q.setShort("ativo", (short)1);
        return q.list();
    }

    public void voltarSituacaoPedidoPlan(Set<Pedido> pedidos) {
        this.getSession().flush();
        Query q = this.getSession().createQuery("select count(p.identificador) from Pedido p inner join p.itemPedido i inner join i.gradeItemPedido g left join g.itensPlanProdLinProd it left join g.itensPlanProdEncProd enc where (it is null and enc is null)  and p=:ped");
        Query upd = this.getSession().createQuery("update Pedido p set p.situacaoPedido = p.situacaoPedAnt where p=:ped");
        for (Pedido ped : pedidos) {
            q.setEntity("ped", (Object)ped);
            Long ret = (Long)q.uniqueResult();
            if (ret <= 0L) continue;
            upd.setEntity("ped", (Object)ped);
            upd.executeUpdate();
        }
    }

    public Object findDadosPedidosObs(NotaFiscalPropria nf) {
        HashMap h = null;
        if (nf.getExpedicao() != null && nf.getExpedicao().getPedido() != null) {
            Session s = CoreBdUtil.getInstance().getSession();
            Query q = s.createQuery("select n.identificador as ID_PEDIDO,n.nrPedidoCliente as NR_PED_CLIENTE,n.codigoPedido as COD_PEDIDO,n.nrSequencialPedido as NR_SEQUENCIAL,n.observacao as OBSERVACAO_PEDIDO,n.representante.pessoa.nome as NOME_REPRESENTANTE,n.representante.identificador as ID_REPRESENTANTE ,n.dataEmissao as DATA_EMISSAO, n.volumeTotal as VOLUME_TOTAL from Pedido n where n=:pedido");
            q.setEntity("pedido", (Object)nf.getExpedicao().getPedido());
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            h = (HashMap)q.uniqueResult();
        } else {
            h = new HashMap();
            h.put("NR_PED_CLIENTE", "");
            h.put("ID_PEDIDO", null);
            h.put("NOME_REPRESENTANTE", "");
            h.put("ID_REPRESENTANTE", null);
            h.put("DATA_EMISSAO", null);
        }
        return h;
    }

    public void atualizarSituacaoPedido(Pedido pedido, SituacaoPedidos sit) {
        Session s = CoreBdUtil.getInstance().getSession();
        NativeQuery q = s.createSQLQuery("update pedido p set p.id_situacao_pedido =:sit where p.id_pedido=:pedido");
        q.setEntity("sit", (Object)sit);
        q.setEntity("pedido", (Object)pedido);
        q.executeUpdate();
    }
}

