/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.PedidoAlmoxarifado;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class DAOPedidoAlmoxarifado
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return PedidoAlmoxarifado.class;
    }

    public Object findPedidosEntreDatasNaoAtendidos(Date dataIn, Date dataFim, Empresa empresa, Empresa empresaAtendimento, NaturezaOperacao naturezaOperacao) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = "select distinct p from PedidoAlmoxarifado p  inner join p.itensPedido i left join i.atendPedidoAlmoxItem a where a.identificador is null and p.dataAgendamento between :dataIn and :dataFim";
        if (empresa != null) {
            query = (String)query + " and p.empresa = :empresa";
        }
        if (empresaAtendimento != null) {
            query = (String)query + " and p.empresaAtendimento = :empresaAtendimento";
        }
        if (naturezaOperacao != null) {
            query = (String)query + " and p.naturezaOperacao = :naturezaOperacao";
        }
        Query q = s.createQuery((String)query);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        if (empresa != null) {
            q.setEntity("empresa", (Object)empresa);
        }
        if (empresaAtendimento != null) {
            q.setEntity("empresaAtendimento", (Object)empresaAtendimento);
        }
        if (naturezaOperacao != null) {
            q.setEntity("naturezaOperacao", (Object)naturezaOperacao);
        }
        return q.list();
    }

    public Object findAtendimentoPedidoAlmoxarifado(PedidoAlmoxarifado p) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct a.grupoAtendPedidoAlmox  from AtendPedidoAlmox a where a.pedidoAlmoxarifado = :pedido");
        q.setEntity("pedido", (Object)p);
        return q.uniqueResult();
    }

    public List findAtendimentosCompra(Date dataInicial, Date dataFinal, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct a  from AtendPedidoAlmoxItemGrade a inner join a.atendPedidoAlmoxItem ai inner join ai.atendPedidoAlmox aa inner join aa.grupoAtendPedidoAlmox g left join a.atendPedItemGradeNecCompra n where n is null  and g.dataAtendimento between :dataIn and :dataFim and g.empresa = :emp and a.quantidadeCotar>0");
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setEntity("emp", (Object)emp);
        return q.list();
    }
}

