/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemPedidoComercio;
import com.touchcomp.basementor.model.vo.PedidoComercio;
import com.touchcomp.basementor.model.vo.SituacaoItemPedido;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import org.hibernate.query.Query;

public class DAOPedidoComercio
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return PedidoComercio.class;
    }

    public List getItensPedidoSituacaoItem(SituacaoItemPedido situacao, Short tipoFiltro, Date dataIn, Date dataFim) {
        Object st = "select distinct i from ItemPedidoComercio i inner join i.produto p inner join i.pedidoComercio ped inner join ped.cliente cl inner join i.situacaoItemPedido sit left join i.logItemPedido l left join ped.fechamentoPedidoComercio f where (i.itemCancelado <>:sim or i.itemCancelado is null)  and (f is null or ped.statusPedido is null or ped.statusPedido<>:sim) ";
        st = tipoFiltro == 0 ? (String)st + " and cast(ped.dataEmissao as date) between :dataIn and :dataFim and sit = :situacao" : (String)st + " and cast(ped.dataPrevSaida as date) between :dataIn and :dataFim";
        st = (String)st + " order by l.dataLog";
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)st);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("situacao", (Object)situacao);
        q.setShort("sim", (short)1);
        return q.list();
    }

    public void atualizarSitItensPedidoComercio(List itensPedido) throws ExceptionDatabase {
        for (Object o : itensPedido) {
            HashMap h = (HashMap)o;
            ItemPedidoComercio item = (ItemPedidoComercio)h.get("item");
            SituacaoItemPedido nova = (SituacaoItemPedido)h.get("situacaoItemPedido");
            item.setSituacaoItemPedido(nova);
            this.saveOrUpdate(item);
        }
    }

    public List pesquisarPedidoAberto(Empresa empresa) {
        Query q = CoreBdUtil.getInstance().getSession().createQuery("from PedidoComercio p  where  p.empresa = :empresa and (p.statusPedido is null or p.statusPedido=:statusPedido)");
        q.setShort("statusPedido", (short)0);
        q.setEntity("empresa", (Object)empresa);
        return q.list();
    }

    public Object findPedidoBloqueados(Short filtraData, Date dataInicial, Date dataFinal, Short filtraCliente, Long idClienteInicial, Long idClienteFinal, Empresa empresa) {
        Object hql = "from PedidoComercio p  where  p.empresa = :empresa and p.pedidoBloqueado = :bloqueado";
        if (filtraData == 1) {
            hql = (String)hql + " and p.dataEmissao between :dataInicial and :dataFinal";
        }
        if (filtraCliente == 1) {
            hql = (String)hql + " and p.cliente.identificador between :idClienteInicial and :idClienteFinal";
        }
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
        q.setShort("bloqueado", (short)1);
        q.setEntity("empresa", (Object)empresa);
        if (filtraData == 1) {
            q.setDate("dataInicial", dataInicial);
            q.setDate("dataFinal", dataFinal);
        }
        if (filtraCliente == 1) {
            q.setLong("idClienteInicial", idClienteInicial.longValue());
            q.setLong("idClienteFinal", idClienteFinal.longValue());
        }
        return q.list();
    }

    public List findControleEntregaPedidoComercio(Long idPedidoComercio) {
        Query q = CoreBdUtil.getInstance().getSession().createQuery("from ControleEntregaPedidoComercio p  where  p.pedidoComercio.identificador = :idPedidoComercio");
        q.setLong("idPedidoComercio", idPedidoComercio.longValue());
        return q.list();
    }

    public List pesquisarPedidoVendaFinanceira(Empresa empresa, Date dataInicial, Date dataFinal) {
        Query q = CoreBdUtil.getInstance().getSession().createQuery(" select distinct p  from PedidoComercio p  where  p.empresa = :empresa and cast(p.dataEmissao as date) between :dataInicial and :dataFinal and p.statusPedido = :fechado and p.tipoPedido = :vendaFinanceira");
        q.setShort("fechado", (short)1);
        q.setShort("vendaFinanceira", (short)2);
        q.setEntity("empresa", (Object)empresa);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        return q.list();
    }
}

