/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.ClassificacaoPlanoConta;
import com.touchcomp.basementor.model.vo.NaturezaOperacaPC;
import com.touchcomp.basementor.model.vo.PlanoConta;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.service.CoreRequestContext;
import mentorcore.tools.ClearUtil;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;

public class DAOPlanoConta
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return PlanoConta.class;
    }

    public boolean existeContasDependentes(String beginCount, String endCount, String currentCod) {
        Session s = CoreBdUtil.getInstance().getSession();
        Criteria crit = s.createCriteria(this.getVOClass());
        crit.add(Restrictions.between((String)"codigo", (Object)beginCount, (Object)endCount));
        crit.add((Criterion)Restrictions.ne((String)"codigo", (Object)currentCod));
        crit.setMaxResults(1);
        List lista = crit.list();
        return !lista.isEmpty();
    }

    public String getNextReduzida() throws ExceptionDatabase {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select max(P.reduzida) from PlanoConta P");
        Object obj = q.uniqueResult();
        return obj.toString();
    }

    public String getNextSequencial(String grupo) throws ExceptionDatabase {
        String cod = grupo.substring(0, 5);
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select max(P.codigo)from PlanoConta P where P.codigo like :codigo");
        q.setParameter("codigo", (Object)(cod + "%"));
        Object obj = q.uniqueResult();
        if (obj != null) {
            return obj.toString();
        }
        return cod + "00000";
    }

    public Object atualizarNatOPContas(CoreRequestContext request) {
        String prefixoConta = (String)request.getAttribute("codigo");
        NaturezaOperacaPC naturezaOp = (NaturezaOperacaPC)request.getAttribute("naturezaOP");
        prefixoConta = ClearUtil.refina(prefixoConta);
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("update PlanoConta pc set pc.naturezaOperacaoPC=:natureza where pc.codigo like :codigo");
        q.setEntity("natureza", (Object)naturezaOp);
        q.setString("codigo", prefixoConta + "%");
        q.executeUpdate();
        return true;
    }

    public Boolean atualizarDataCadastroPC(Date dataBase, Date dataAlt) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("update PlanoConta p set p.dataCadastro=:dataAlt where p.dataCadastro >=:dataBase");
        q.setDate("dataBase", dataBase);
        q.setDate("dataAlt", dataAlt);
        q.executeUpdate();
        return true;
    }

    public Object atualizarClassificacaoContas(CoreRequestContext request) {
        String prefixoConta = (String)request.getAttribute("codigo");
        ClassificacaoPlanoConta classificacao = (ClassificacaoPlanoConta)request.getAttribute("classificacao");
        prefixoConta = ClearUtil.refina(prefixoConta);
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("update PlanoConta pc set pc.classificacaoPlanoConta=:classificacao where pc.codigo like :codigo");
        q.setEntity("classificacao", (Object)classificacao);
        q.setString("codigo", prefixoConta + "%");
        q.executeUpdate();
        return true;
    }
}

