/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Localizacao;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorlogger.TLogger;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DAOProduto
extends CoreBaseDAO {
    private static final TLogger logger = TLogger.get(DAOProduto.class);
    String periodo = null;

    @Override
    public Class getVOClass() {
        return Produto.class;
    }

    public List getFatorConversaoItem(Long idProduto, Long idFornecedor) {
        Session s = CoreBdUtil.getInstance().getSession();
        NativeQuery q = s.createSQLQuery("select d.codigo from depara_item_est_fornecedor d where d.id_fornecedor = :idFornecedor and d.id_produto = :idProduto ");
        q.setLong("idFornecedor", idFornecedor.longValue());
        q.setLong("idProduto", idProduto.longValue());
        return q.list();
    }

    public Produto pesquisarProduto(String codigoAuxiliar) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("FROM Produto p WHERE p.codigoAuxiliar = :codigoAuxiliar");
        q.setString("codigoAuxiliar", codigoAuxiliar);
        return (Produto)q.uniqueResult();
    }

    public Produto pesquisarProdutoCodigoReferencia(String codigoReferencia) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("FROM Produto p WHERE p.codigoReferencia = :codigoReferencia");
        q.setString("codigoReferencia", codigoReferencia);
        return (Produto)q.uniqueResult();
    }

    public Collection findProdutosBalanco(CoreRequestContext r) {
        Long produtoInicial = (Long)r.getAttribute("produtoInicial");
        Long produtoFinal = (Long)r.getAttribute("produtoFinal");
        Long locInicial = (Long)r.getAttribute("localizacaoInicial");
        Long locFinal = (Long)r.getAttribute("localizacaoFinal");
        Long especieInicial = (Long)r.getAttribute("especieInicial");
        Long especieFinal = (Long)r.getAttribute("especieFinal");
        Long subEspecieInicial = (Long)r.getAttribute("subespecieInicial");
        Long subEspecieFinal = (Long)r.getAttribute("subespecieFinal");
        Session s = null;
        s = CoreBdUtil.getInstance().getSession();
        String query = "select p.identificador as idProduto,  p.nome as nome,  p.unidadeMedida.sigla as sigla,  p.empresa.identificador as empresa, p.localizacao.identificador as localizacao, p.especie.identificador as Especie, p.subEspecie.identificador as subEspecie from Produto p where p.identificador between :prodInicial and :prodFinal and p.localizacao.identificador between :locInicial and :locFinal and p.especie.identificador between :espInicial and :espFinal and p.subEspecie.identificador between :subEspInicial and :subEspFinal order by p.identificador";
        Query q = s.createQuery(query);
        q.setLong("prodInicial", produtoInicial.longValue());
        q.setLong("prodFinal", produtoFinal.longValue());
        q.setLong("locInicial", locInicial.longValue());
        q.setLong("locFinal", locFinal.longValue());
        q.setLong("espInicial", especieInicial.longValue());
        q.setLong("espFinal", especieFinal.longValue());
        q.setLong("subEspInicial", subEspecieInicial.longValue());
        q.setLong("subEspFinal", subEspecieFinal.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public void deleteLogsProduto(Produto p) {
        Session s = CoreBdUtil.getInstance().getSession();
        s.createQuery("delete from LogProduto l where l.produto=:produto").setEntity("produto", (Object)p).executeUpdate();
    }

    public Object findProdutoPorCodigoBarras(String codBarra) throws ExceptionService {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct p from CodigoBarras c  inner join c.produto p where c.codigoBarras=:codigoBarra and p.ativo = :ativo");
        q.setString("codigoBarra", codBarra);
        q.setShort("ativo", (short)1);
        List ret = q.list();
        if (ret != null && !ret.isEmpty()) {
            if (ret.size() > 1) {
                this.throwExceptionMultipleProductsWithOneBarCode(ret);
            } else {
                return ret.get(0);
            }
        }
        return null;
    }

    private void throwExceptionMultipleProductsWithOneBarCode(List<Produto> list) throws ExceptionService {
        StringBuilder message = new StringBuilder();
        message.append("Erro ao pesquisar os produtos pelo codigo de barras, os produtos: ");
        for (Produto produto : list) {
            message.append(produto.getIdentificador());
            message.append(" - ");
        }
        message.append(" possuem o mesmo codigo de barras!");
        throw new ExceptionService(message.toString());
    }

    public Object findProdutosSincronizacaoDadosCupom(Timestamp ultimaSincronizacao) {
        Object hql = "select distinct un.identificador as ID_PRODUTO, un.nome as NOME, un.pesoUnitario as PESO_UNITARIO, un.aliquotaIcms as ALIQUOTA_ICMS, un.aliquotaIss as ALIQUOTA_ISS, un.aliquotaCofins as ALIQUOTA_COFINS, un.aliquotaPis as ALIQUOTA_PIS, un.qtdMin as QTD_MIN, un.qtdMax as QTD_MAX, un.unidadeMedida.identificador as ID_UNID_MEDIDA_CP, un.codigoAuxiliar as COD_AUX, un.nomeAuxiliar as NOME_AUXILIAR from Produto un  where un.entradaSaida = 1  and un.ativo = :ativo ";
        if (ultimaSincronizacao != null) {
            hql = (String)hql + " and un.dataAtualizacao >= :ultimaSincronizacao";
        }
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
        q.setShort("ativo", (short)1);
        if (ultimaSincronizacao != null) {
            q.setTimestamp("ultimaSincronizacao", (Date)ultimaSincronizacao);
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        if (lista != null && !lista.isEmpty()) {
            for (Object o : lista) {
                HashMap h = (HashMap)o;
                Long idProduto = (Long)h.get("ID_PRODUTO");
                hql = "from CodigoBarras c where c.produto.identificador = :idProduto";
                q = CoreBdUtil.getInstance().getSession().createQuery((String)hql).setLong("idProduto", idProduto.longValue());
                List result = q.list();
                h.put("CODIGO_BARRAS", result);
            }
        }
        return lista;
    }

    public List findProdutosParaExportacao() {
        Session s = CoreBdUtil.getInstance().getSession();
        NativeQuery q = s.createSQLQuery("SELECT P.ID_PRODUTO             AS CODIGO_BARRAS,        P.ID_ESPECIE           AS CODIGO_GRUPO,        P.NOME_AUXILIAR        AS DESC_ABREVIADA,        TPBP.VALOR_VENDA       AS UNITARIO,        UM.SIGLA               AS UNIDADE,        TIP.ID_TRIBUTACAO_ITEM AS ALIQUOTA_ECF,        '0000000000'           AS PROMOCAO,        P.ID_PRODUTO           AS COD_INTERNO,        F.NOME                 AS FORNEC_FABRIC,        ' '                     AS REFERENCIA,        'N'                     AS CESTA_KIT,        SEP.VALOR_PRECO_MEDIO  AS CUSTO,        P.NOME                 AS DESCRICAO,        '000000'               AS COD_CESTA,        '00000000'             AS INICIO_PROMOCAO,        '00000000'             AS VALIDADE_PROMOCAO,        SEP.SALDO_QTD          AS ESTOQUE_ATUAL,        'T'                    AS ARREDONDAMENTO,        'T'                    AS PRODUCAO FROM       PRODUTO                 P INNER JOIN PRODUTO_GRADE           PG   ON PG.ID_PRODUTO        = P.ID_PRODUTO INNER JOIN GRADE_COR               GC   ON GC.ID_PRODUTO_GRADE  = PG.ID_PRODUTO_GRADE INNER JOIN TABELA_PRECO_BASE_PROD  TPBP ON TPBP.ID_PRODUTO      = P.ID_PRODUTO INNER JOIN UNIDADE_MEDIDA          UM   ON UM.ID_UNIDADE_MEDIDA = P.ID_UNIDADE_MEDIDA INNER JOIN TRIBUTACAO_ITEM_PRODUTO TIP  ON TIP.ID_PRODUTO       = P.ID_PRODUTO INNER JOIN FABRICANTE              F    ON F.ID_FABRICANTE      = P.ID_FABRICANTE INNER JOIN SALDO_EST_PROPRIO       SEP  ON SEP.ID_GRADE_COR     = GC.ID_GRADE_COR WHERE SEP.DATA = (SELECT MAX(SEP1.DATA)                    FROM       SALDO_EST_PROPRIO SEP1                    INNER JOIN GRADE_COR         GC1 ON GC1.ID_GRADE_COR = SEP1.ID_GRADE_COR                    WHERE SEP1.DATA <= CURRENT_DATE                    AND   GC1.ID_GRADE_COR = GC.ID_GRADE_COR) ");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public Object getProdutosByTexto(String texto, OpcoesFaturamento opcoesFaturamento) throws ExceptionService {
        LinkedList ret = new LinkedList();
        ret.addAll(this.findProdutoDescricao(texto));
        ret.addAll(this.findProdutoIdCodigoBarras(texto, opcoesFaturamento));
        this.orderLista(ret);
        return ret;
    }

    private void orderLista(List ret) {
        Collections.sort(ret, new Comparator<Object[]>(this){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                String s1 = (String)o1[1];
                String s2 = (String)o2[1];
                return s1.compareToIgnoreCase(s2);
            }
        });
    }

    private List findProdutoDescricao(String text) throws ExceptionService {
        if (text.length() > 115) {
            return new LinkedList();
        }
        if (text.length() < 3) {
            return new LinkedList();
        }
        Query q = CoreBdUtil.getInstance().getSession().createQuery("select distinct p.identificador as ID_PRODUTO,  p.nome as PRODUTO,  u.sigla as UN, p.codigoAuxiliar as COD_AUXILIAR  from Produto p  inner join p.unidadeMedida u where upper(p.nome) like :nome  and p.entradaSaida = :saida and p.ativo = :ativo");
        q.setString("nome", "%" + text.toUpperCase() + "%");
        q.setShort("ativo", (short)1);
        q.setShort("saida", (short)1);
        List l = q.list();
        l = this.setFlag(l, (short)0);
        return l;
    }

    private List findProdutoIdCodigoBarras(String text, OpcoesFaturamento opcoesFaturamento) {
        if (text.trim().length() > 60) {
            return new LinkedList();
        }
        Long idPRod = 0L;
        try {
            idPRod = new Long(text);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Object query = "select distinct p.identificador as ID_PRODUTO,  p.nome as PRODUTO,  u.sigla as UN, p.codigoAuxiliar as COD_AUXILIAR  from  Produto p inner join p.unidadeMedida u left join p.codigoBarras c where (p.codigoAuxiliar = :nome  or c.codigoBarras = :codigo ";
        if (idPRod > 0L && text.trim().length() < 10) {
            query = (String)query + " or p.identificador=:identificador ";
        }
        query = (String)query + ") and p.ativo = :ativo and p.entradaSaida = :saida";
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)query);
        q.setString("nome", text.toUpperCase());
        q.setString("codigo", text);
        q.setShort("ativo", (short)1);
        q.setShort("saida", (short)1);
        if (idPRod > 0L && text.trim().length() < 10) {
            q.setParameter("identificador", (Object)idPRod);
        }
        List l = q.list();
        l = this.setFlag(l, (short)0);
        return l;
    }

    private List setFlag(List l, short flag) {
        LinkedList<Object[]> toRet = new LinkedList<Object[]>();
        for (Object o : l) {
            Object[] ar = (Object[])o;
            Object[] ar1 = new Object[6];
            ar1[0] = ar[0];
            ar1[1] = ar[1];
            ar1[2] = ar[2];
            ar1[3] = flag;
            ar1[4] = ar[3];
            toRet.add(ar1);
        }
        return toRet;
    }

    public Localizacao buscarLocalizacaoProduto(Produto produto, CentroEstoque centroEstoque) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = " select l  from ProdLocCentroEstoque pl  inner join pl.centroEstoque ce  inner join pl.itens i  inner join i.gradeCor gc  inner join gc.produtoGrade pg  inner join pg.produto prod  inner join i.localizacao l  where prod.identificador = :idProduto  and ce.identificador = :idCentroEstoque  order by pl.identificador desc ";
        Query q = s.createQuery(query);
        q.setLong("idProduto", produto.getIdentificador().longValue());
        q.setLong("idCentroEstoque", centroEstoque.getIdentificador().longValue());
        q.setMaxResults(1);
        return (Localizacao)q.uniqueResult();
    }
}

