/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.constants.enums.procedenciasolicitacao.EnumProcedenciaSolicitacao;
import com.touchcomp.basementor.model.vo.ClassificacaoMarketing;
import com.touchcomp.basementor.model.vo.LocalTicketAtendTouch;
import com.touchcomp.basementor.model.vo.ProcedenciaSolicitacao;
import com.touchcomp.basementor.model.vo.ProcedenciaSolicitacaoContato;
import com.touchcomp.basementor.model.vo.RelPessoaContato;
import com.touchcomp.basementor.model.vo.RelPessoaContatoLog;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementor.model.vo.VersaoMentor;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.sql.JoinType;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DAORelPessoaContato
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return RelPessoaContato.class;
    }

    public Object findRelacionadosAbertos(Date dataIn, Date dataFim, ClassificacaoMarketing cl, Usuario u, Short tipoPesq, Short sugestao) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object qu = tipoPesq == 0 ? "select r.nrProtocolo as NR_PROTOCOLO, p.descricao as PROCEDENCIA,  prior.descricao as PRIORIDADE, v.descricao as VERSAO, pesAgend.nome as USUARIO_RELACIONAMENTO, l.dataAgendamento as DATA_AGENDAMENTO, pesAgend.nome as USUARIO_AGEND, pes.nome as CLIENTE, pes.nomeFantasia as CLIENTE_FANTASIA, r.identificador as ID_RELACIONAMENTO, r.dataPrevFinalizacao as DATA_PREV_FINALIZACAO_CLIENTE, r.dataPrevFinalizacao as DATA_PREV_FINALIZACAO, r.dataPrevFinalizacaoInterna as DATA_PREV_FINALIZACAO_INTERNA, r.assunto as ASSUNTO, ua.nome as USUARIO_CLIENTE, stat.descricao as STATUS from RelPessoaContatoLog l  inner join l.relPessoaContato r inner join r.procedenciaSolicitacaoContato p inner join r.usuario uCad inner join uCad.usuarioBasico ubC  inner join ubC.pessoa pesCad  inner join l.usuario uAgend inner join uAgend.usuarioBasico ubA  inner join ubA.pessoa pesAgend  inner join r.clienteContSistemas c inner join c.tomadorPrestadorRps t inner join t.pessoa pes left join r.versaoSerDisponibilizada v  inner join r.usuarioCliContSistemas u inner join u.pessoa ua left  join r.statusRelPessoaContato stat left  join r.prioridadeAtendimento prior where (l.finalizado = 0  or l.finalizado is null) and (r.usuarioResponsavel = :usuario ) " : "select r.nrProtocolo as NR_PROTOCOLO, p.descricao as PROCEDENCIA, prior.descricao as PRIORIDADE, prior.identificador as ID_PRIORIDADE, v.descricao as VERSAO,  pesAgend.nome as USUARIO_RELACIONAMENTO, l.dataAgendamento as DATA_AGENDAMENTO, pesAgend.nome as USUARIO_AGEND,  pes.nome as CLIENTE, pes.nomeFantasia as CLIENTE_FANTASIA, r.identificador as ID_RELACIONAMENTO, r.dataPrevFinalizacao as DATA_PREV_FINALIZACAO_CLIENTE, r.dataPrevFinalizacao as DATA_PREV_FINALIZACAO, r.dataPrevFinalizacaoInterna as DATA_PREV_FINALIZACAO_INTERNA, r.assunto as ASSUNTO, ua.nome as USUARIO_CLIENTE, stat.descricao as STATUS  from RelPessoaContatoLog l  inner join l.relPessoaContato r inner join r.procedenciaSolicitacaoContato p inner join r.usuario uCad inner join uCad.usuarioBasico ubC  inner join ubC.pessoa pesCad  inner join l.usuario uAgend inner join uAgend.usuarioBasico ubA  inner join ubA.pessoa pesAgend  inner join r.clienteContSistemas c inner join c.tomadorPrestadorRps t inner join t.pessoa pes left  join r.versaoSerDisponibilizada v  inner join r.usuarioCliContSistemas u inner join u.pessoa ua left  join r.statusRelPessoaContato stat left  join r.prioridadeAtendimento prior where (l.finalizado = 0  or l.finalizado is null) and (l.usuarioAgendamento = :usuario or l.usuarioAgendamento is null) ";
        if (sugestao.equals((short)0)) {
            qu = (String)qu + " and p.sugestao = :nao";
        }
        if (dataIn != null && dataFim != null) {
            qu = (String)qu + " and l.dataAgendamento between :dataIn and :dataFim ";
        }
        Query q = s.createQuery((String)qu);
        if (dataIn != null && dataFim != null) {
            q.setDate("dataIn", dataIn);
            q.setDate("dataFim", dataFim);
        }
        if (sugestao.equals((short)0)) {
            q.setShort("nao", (short)0);
        }
        q.setEntity("usuario", (Object)u);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (HashMap h : lista) {
            Date dataPrevFinalizacaoInterna = (Date)h.get("DATA_PREV_FINALIZACAO_INTERNA");
            if (dataPrevFinalizacaoInterna == null) continue;
            h.put("DATA_PREV_FINALIZACAO", dataPrevFinalizacaoInterna);
        }
        return lista;
    }

    public Object findRelacionadosVersao(VersaoMentor v) {
        Criteria criteria = CoreBdUtil.getInstance().getSession().createCriteria(RelPessoaContato.class);
        criteria.createAlias("versaoSerDisponibilizada", "versao");
        criteria.createAlias("procedenciaSolicitacaoContato", "proc");
        criteria.add((Criterion)Restrictions.eq((String)"versao.identificador", (Object)v.getIdentificador()));
        criteria.add((Criterion)Restrictions.eq((String)"finalizado", (Object)1));
        Disjunction dis = Restrictions.or((Criterion[])new Criterion[0]);
        dis.add((Criterion)Restrictions.eq((String)"proc.tipoProcedencia", (Object)EnumProcedenciaSolicitacao.IMPLEMENTACAO.getValue()));
        dis.add((Criterion)Restrictions.eq((String)"proc.tipoProcedencia", (Object)EnumProcedenciaSolicitacao.ERRO_SISTEMA.getValue()));
        criteria.add((Criterion)dis);
        return criteria.list();
    }

    public Object findProximoNrProtocolo() {
        NativeQuery q = CoreBdUtil.getInstance().getSession().createSQLQuery("select gen_id(gen_numero_protocolo_contato,1) from rdb$database");
        BigInteger b = (BigInteger)q.uniqueResult();
        return b.longValue();
    }

    public Object findRelacionadosMarketingAbertos(Date dataIn, Date dataFim, ClassificacaoMarketing cl, ProcedenciaSolicitacao pr, Usuario u, Short filtrarSetor) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object qu = "select r.usuario.usuarioBasico.pessoa.nome as NOME_USUARIO, rp.dataRelacionamento as DATA_RELACIONAMENTO, r.dataAgendamento as DATA_AGENDAMENTO, r.dataInicial as DATA_INICIAL, r.dataFinalizacao as DATA_FINALIZACAO, rp.nrProtocolo as NR_PROTOCOLO, rp.pessoa.nome as NOME_PESSOA, rp.prioridadeMarketing.descricao as PRIORIDADE, rp.procedenciaSolicitacao.descricao as DESCRICAO, rp.identificador as ID_RELACIONAMENTO, rp.agendamento as AGENDAMENTO, rp.solucionado as SOLUCIONADO, r.observacao as OBSERVACAO_LOG, rp.origemRel as ORIGEM_RELACIONAMENTO, r.identificador as ID_RELACIONAMENTO_LOG from RelacionamentoPessoa rp left join rp.agendamentos r where (r.finalizado = :nao  or r.finalizado is null)  and ((r.usuarioAgendamento = :usuario)        or (:filtrarSetor <> 1 and r.usuarioAgendamento is null)        or (:filtrarSetor <> 0 and rp.setor = :setorUsuario and r.usuarioAgendamento is null)       or (:filtrarSetor <> 0 and rp.setor = :setorUsuario and r is null))  and (rp.solucionado<>:sim or rp.solucionado is null)";
        if (dataIn != null && dataFim != null) {
            qu = (String)qu + " and r.dataAgendamento between :dataIn and :dataFim ";
        }
        if (cl != null) {
            qu = (String)qu + " and rp.classificacaoMarketing = :classificacao ";
        }
        if (pr != null) {
            qu = (String)qu + " and rp.procedenciaSolicitacao = :procedencia ";
        }
        qu = (String)qu + "order by r.dataAgendamento";
        Query q = s.createQuery((String)qu);
        if (dataIn != null && dataFim != null) {
            q.setDate("dataIn", dataIn);
            q.setDate("dataFim", dataFim);
        }
        if (cl != null) {
            q.setEntity("classificacao", (Object)cl);
        }
        if (pr != null) {
            q.setEntity("procedencia", (Object)pr);
        }
        q.setShort("sim", (short)1);
        q.setShort("nao", (short)0);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        q.setEntity("usuario", (Object)u);
        q.setEntity("setorUsuario", (Object)u.getSetorUsuario());
        q.setShort("filtrarSetor", filtrarSetor.shortValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public List getEventosUsuarioData(Usuario u, Date d, Date dFim) {
        Query q = CoreBdUtil.getInstance().getSession().createQuery("from RelPessoaContatoLog r where r.usuarioAgendamento=:usu and cast(r.dataFinal as date) between :dataInicial and :dataFinal and r.relPessoaContato.finalizado=:sim and r.itemApuPontosRelContato is null");
        q.setEntity("usu", (Object)u);
        q.setDate("dataInicial", d);
        q.setDate("dataFinal", dFim);
        q.setShort("sim", (short)1);
        return q.list();
    }

    public List getListagemRelacionamentoPorProcedencia(Integer filtrarData, Date dataInicial, Date dataFinal, Integer filtrarProcedencia, Integer procedenciaInicial, Integer procedenciaFinal, Integer filtrarCliente, Integer clienteInicial, Integer clienteFinal) {
        Object hql = " select  rpc.procedenciaSolicitacaoContato.identificador as idProcedencia, rpc.procedenciaSolicitacaoContato.descricao as Procedencia,  rpc.nrProtocolo as nProtocolo,  rpc.clienteContSistemas.tomadorPrestadorRps.pessoa.nome as Cliente,  rpc.dataCadastro as dataCadastro, rpc.dataFinalizacao as dataFinalizacao, rpc.assunto as Assunto  from RelPessoaContato rpc ";
        if (filtrarData == 1) {
            hql = (String)hql + " where  rpc.dataFinalizacao between :dataInicial and :dataFinal ";
        }
        if (filtrarProcedencia == 1) {
            hql = filtrarData == 1 ? (String)hql + " and " : (String)hql + " where ";
            hql = (String)hql + " rpc.procedenciaSolicitacaoContato.identificador between :procedenciaInicial and :procedenciaFinal ";
        }
        if (filtrarCliente == 1) {
            hql = filtrarData == 1 || filtrarProcedencia == 1 ? (String)hql + " and " : (String)hql + " where ";
            hql = (String)hql + " rpc.clienteContSistemas.identificador between :clienteInicial and :clienteFinal ";
        }
        hql = filtrarCliente == 1 || filtrarData == 1 || filtrarProcedencia == 1 ? (String)hql + " and " : (String)hql + " where ";
        hql = (String)hql + " rpc.finalizado = 1";
        hql = (String)hql + " order by  rpc.procedenciaSolicitacaoContato.identificador,  rpc.dataFinalizacao ";
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
        if (filtrarData == 1) {
            q.setDate("dataInicial", dataInicial);
            q.setDate("dataFinal", dataFinal);
        }
        if (filtrarProcedencia == 1) {
            q.setInteger("procedenciaInicial", procedenciaInicial.intValue());
            q.setInteger("procedenciaFinal", procedenciaFinal.intValue());
        }
        if (filtrarCliente == 1) {
            q.setInteger("clienteInicial", clienteInicial.intValue());
            q.setInteger("clienteFinal", clienteFinal.intValue());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public Object findRelacionamentosAgendados(List tipos, Short filtrarUsuario, Usuario usuario, Date dataInicial, Date dataFinal) {
        Criteria c = CoreBdUtil.getInstance().getSession().createCriteria(RelPessoaContatoLog.class);
        c.createAlias("relPessoaContato", "r", JoinType.INNER_JOIN);
        c.createAlias("r.procedenciaSolicitacaoContato", "p", JoinType.INNER_JOIN);
        Disjunction d = Restrictions.disjunction();
        for (Object o : tipos) {
            d.add((Criterion)Restrictions.eq((String)"p.tipoProcedencia", o));
        }
        if (filtrarUsuario != null && filtrarUsuario == 1) {
            c.add((Criterion)Restrictions.eq((String)"usuarioAgendamento", (Object)usuario));
        }
        c.add(Restrictions.between((String)"dataAgendamento", (Object)dataInicial, (Object)dataFinal));
        c.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"finalizado", (Object)0), (Criterion)Restrictions.isNull((String)"finalizado")));
        c.add((Criterion)d);
        return c.list();
    }

    public List getAtendimentosNotaAtendimento(Usuario usuario) {
        Criteria c = CoreBdUtil.getInstance().getSession().createCriteria(LocalTicketAtendTouch.class);
        c.createAlias("notaAtendimento", "n", JoinType.LEFT_OUTER_JOIN);
        c.add(Restrictions.isNull((String)"notaAtendimento"));
        c.add((Criterion)Restrictions.ge((String)"versaoTicket", (Object)2));
        c.add((Criterion)Restrictions.eq((String)"status", (Object)1));
        c.add((Criterion)Restrictions.eq((String)"usuario", (Object)usuario));
        return c.list();
    }

    public Boolean existeAtendimentosNotaAtendimento(Usuario usuario) {
        Criteria c = CoreBdUtil.getInstance().getSession().createCriteria(LocalTicketAtendTouch.class);
        c.createAlias("notaAtendimento", "n", JoinType.LEFT_OUTER_JOIN);
        c.add(Restrictions.isNull((String)"notaAtendimento"));
        c.add((Criterion)Restrictions.ge((String)"versaoTicket", (Object)2));
        c.add((Criterion)Restrictions.eq((String)"status", (Object)1));
        c.add((Criterion)Restrictions.eq((String)"usuario", (Object)usuario));
        c.setProjection(Projections.rowCount());
        Long nr = (Long)c.uniqueResult();
        return nr != null ? nr > 0L : false;
    }

    public ProcedenciaSolicitacaoContato findMaxFilhoProcedencia(ProcedenciaSolicitacaoContato proc) {
        Criteria c = CoreBdUtil.getInstance().getSession().createCriteria(ProcedenciaSolicitacaoContato.class);
        if (proc == null) {
            c.add((Criterion)Restrictions.eq((String)"procSolContatoPai", (Object)proc));
        } else {
            c.add(Restrictions.isNull((String)"procSolContatoPai"));
        }
        c.addOrder(Order.desc((String)"sequencia"));
        return (ProcedenciaSolicitacaoContato)c.uniqueResult();
    }
}

