/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoa;
import com.touchcomp.basementor.model.vo.SetorUsuario;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;

public class DAORelacionamentoPessoa
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return RelacionamentoPessoa.class;
    }

    public List getRelacionamentosAT(Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct gc from RelacionamentoPessoaGC gc inner join gc.relacionamentoPessoa r left join gc.planejamentoProdSobEnc p where p is null and cast(r.dataRelacionamento as date) between :dataIn and :dataFim");
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        return q.list();
    }

    public Object findNrProtocolo() {
        NativeQuery q = CoreBdUtil.getInstance().getSession().createSQLQuery("select gen_id(GEN_REL_PESSOA_PROTOCOLO,1) from rdb$database");
        BigInteger b = (BigInteger)q.uniqueResult();
        return b.longValue();
    }

    public List findCotacoes(Date dataIn, Date dataFim, Pessoa pessoa, Empresa empresa, Short pedidosGrupoPessoa) {
        Object query = "select distinct c from CotacaoCompra c  inner join c.itensCotacaoCompra i inner join i.fornecedoresItemCotacaoCompra f  inner join f.unidadeFaturamentoFornecedor u inner join u.fornecedor f inner join f.pessoa p left join p.grupoPessoas gp where c.dataCotacaoCompra between :dataIn and :dataFim and ((0 = :pedidosGrupoPessoa and p.identificador = :pessoa) ";
        query = pessoa.getGrupoPessoas() != null && pedidosGrupoPessoa == 1 ? (String)query + " or (1 = :pedidosGrupoPessoa and gp.identificador = :grupoPessoa))" : (pessoa.getGrupoPessoas() == null && pedidosGrupoPessoa == 1 ? (String)query + " or (1 = :pedidosGrupoPessoa and  p.identificador = :pessoa))" : (String)query + " )");
        if (ToolMethods.isNotNull((Object)empresa).booleanValue()) {
            query = (String)query + " and c.empresa = :empresa";
        }
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)query);
        q.setShort("pedidosGrupoPessoa", pedidosGrupoPessoa.shortValue());
        q.setEntity("pessoa", (Object)pessoa);
        if (pessoa.getGrupoPessoas() != null && pedidosGrupoPessoa == 1) {
            q.setEntity("grupoPessoa", (Object)pessoa.getGrupoPessoas());
        }
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        if (ToolMethods.isNotNull((Object)empresa).booleanValue()) {
            q.setEntity("empresa", (Object)empresa);
        }
        return q.list();
    }

    public List findOrdensCompra(Date dataIn, Date dataFim, Pessoa pessoa, Empresa empresa, Short pedidosGrupoPessoa) {
        Object hql = "select distinct c from OrdemCompra c  inner join c.unidadeFatFornecedor u inner join u.fornecedor f inner join f.pessoa p left join p.grupoPessoas gp where c.dataEmissao between :dataIn and :dataFim and c.empresa = :empresa and ((0 = :pedidosGrupoPessoa and p.identificador = :pessoa) ";
        hql = pessoa.getGrupoPessoas() != null && pedidosGrupoPessoa == 1 ? (String)hql + " or (1 = :pedidosGrupoPessoa and gp.identificador = :grupoPessoa))" : (pessoa.getGrupoPessoas() == null && pedidosGrupoPessoa == 1 ? (String)hql + " or (1 = :pedidosGrupoPessoa and  p.identificador = :pessoa))" : (String)hql + " )");
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
        q.setShort("pedidosGrupoPessoa", pedidosGrupoPessoa.shortValue());
        q.setEntity("pessoa", (Object)pessoa);
        if (pessoa.getGrupoPessoas() != null && pedidosGrupoPessoa == 1) {
            q.setEntity("grupoPessoa", (Object)pessoa.getGrupoPessoas());
        }
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)empresa);
        return q.list();
    }

    public List findNotasTerceiro(Date dataIn, Date dataFim, Pessoa pessoa, Empresa empresa, Short pedidosGrupoPessoa) {
        Object query = "select distinct c from NotaFiscalTerceiros c  inner join c.unidadeFatFornecedor u inner join u.fornecedor f inner join f.pessoa p left join p.grupoPessoas gp where c.dataEntrada between :dataIn and :dataFim and ((0 = :pedidosGrupoPessoa and p.identificador = :pessoa) ";
        query = pessoa.getGrupoPessoas() != null && pedidosGrupoPessoa == 1 ? (String)query + " or (1 = :pedidosGrupoPessoa and gp.identificador = :grupoPessoa))" : (pessoa.getGrupoPessoas() == null && pedidosGrupoPessoa == 1 ? (String)query + " or (1 = :pedidosGrupoPessoa and  p.identificador = :pessoa))" : (String)query + " )");
        if (ToolMethods.isNotNull((Object)empresa).booleanValue()) {
            query = (String)query + " and c.empresa = :empresa";
        }
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)query);
        q.setShort("pedidosGrupoPessoa", pedidosGrupoPessoa.shortValue());
        q.setEntity("pessoa", (Object)pessoa);
        if (pessoa.getGrupoPessoas() != null && pedidosGrupoPessoa == 1) {
            q.setEntity("grupoPessoa", (Object)pessoa.getGrupoPessoas());
        }
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        if (ToolMethods.isNotNull((Object)empresa).booleanValue()) {
            q.setEntity("empresa", (Object)empresa);
        }
        return q.list();
    }

    public List findNotasProprias(Date dataIn, Date dataFim, Pessoa pessoa, Empresa empresa, Short pedidosGrupoPessoa) {
        Object query = "select distinct c from NotaFiscalPropria c  inner join c.unidadeFatCliente u inner join u.cliente f inner join f.pessoa p left join p.grupoPessoas gp where c.dataEmissaoNota between :dataIn and :dataFim and ((0 = :pedidosGrupoPessoa and p.identificador = :pessoa) ";
        query = pessoa.getGrupoPessoas() != null && pedidosGrupoPessoa == 1 ? (String)query + " or (1 = :pedidosGrupoPessoa and gp.identificador = :grupoPessoa))" : (pessoa.getGrupoPessoas() == null && pedidosGrupoPessoa == 1 ? (String)query + " or (1 = :pedidosGrupoPessoa and  p.identificador = :pessoa))" : (String)query + " )");
        if (ToolMethods.isNotNull((Object)empresa).booleanValue()) {
            query = (String)query + " and c.empresa = :empresa";
        }
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)query);
        q.setShort("pedidosGrupoPessoa", pedidosGrupoPessoa.shortValue());
        q.setEntity("pessoa", (Object)pessoa);
        if (pessoa.getGrupoPessoas() != null && pedidosGrupoPessoa == 1) {
            q.setEntity("grupoPessoa", (Object)pessoa.getGrupoPessoas());
        }
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        if (ToolMethods.isNotNull((Object)empresa).booleanValue()) {
            q.setEntity("empresa", (Object)empresa);
        }
        return q.list();
    }

    public List findRps(Date dataIn, Date dataFim, Pessoa pessoa, Empresa empresa, Short pedidosGrupoPessoa) {
        Object query = "select distinct r from Rps r  inner join r.unidadeTomPrestRPS u inner join u.tomadorPrestadorRPS t inner join t.pessoa p left join p.grupoPessoas gp where r.dataEmissao between :dataIn and :dataFim and ((0 = :pedidosGrupoPessoa and p.identificador = :pessoa) ";
        query = pessoa.getGrupoPessoas() != null && pedidosGrupoPessoa == 1 ? (String)query + " or (1 = :pedidosGrupoPessoa and gp.identificador = :grupoPessoa))" : (pessoa.getGrupoPessoas() == null && pedidosGrupoPessoa == 1 ? (String)query + " or (1 = :pedidosGrupoPessoa and  p.identificador = :pessoa))" : (String)query + " )");
        if (ToolMethods.isNotNull((Object)empresa).booleanValue()) {
            query = (String)query + " and r.empresa = :empresa";
        }
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)query);
        q.setShort("pedidosGrupoPessoa", pedidosGrupoPessoa.shortValue());
        q.setEntity("pessoa", (Object)pessoa);
        if (pessoa.getGrupoPessoas() != null && pedidosGrupoPessoa == 1) {
            q.setEntity("grupoPessoa", (Object)pessoa.getGrupoPessoas());
        }
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        if (ToolMethods.isNotNull((Object)empresa).booleanValue()) {
            q.setEntity("empresa", (Object)empresa);
        }
        return q.list();
    }

    public List findRecepcoes(Date dataIn, Date dataFim, Pessoa pessoa, Empresa empresa, Short pedidosGrupoPessoa) {
        Object hql = "select distinct r from RecepcaoMercadorias r  inner join r.notaFiscalTerceiros c inner join c.unidadeFatFornecedor u inner join u.fornecedor f inner join f.pessoa p left join p.grupoPessoas gp where c.dataEntrada between :dataIn and :dataFim and ((0 = :pedidosGrupoPessoa and p.identificador = :pessoa) ";
        hql = pessoa.getGrupoPessoas() != null && pedidosGrupoPessoa == 1 ? (String)hql + " or (1 = :pedidosGrupoPessoa and gp.identificador = :grupoPessoa))" : (pessoa.getGrupoPessoas() == null && pedidosGrupoPessoa == 1 ? (String)hql + " or (1 = :pedidosGrupoPessoa and  p.identificador = :pessoa))" : (String)hql + " )");
        if (ToolMethods.isNotNull((Object)empresa).booleanValue()) {
            hql = (String)hql + " and r.empresa = :empresa";
        }
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
        q.setShort("pedidosGrupoPessoa", pedidosGrupoPessoa.shortValue());
        q.setEntity("pessoa", (Object)pessoa);
        if (pessoa.getGrupoPessoas() != null && pedidosGrupoPessoa == 1) {
            q.setEntity("grupoPessoa", (Object)pessoa.getGrupoPessoas());
        }
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        if (ToolMethods.isNotNull((Object)empresa).booleanValue()) {
            q.setEntity("empresa", (Object)empresa);
        }
        return q.list();
    }

    public List findTitulos(Date dataIn, Date dataFim, Pessoa pessoa, Usuario usuario, Empresa empresa, Short pesquisarTitOutrasEmp, Short pagRec, Short pedidosGrupoPessoa) {
        Object hql = "select distinct t from Titulo t  inner join t.pessoa p left join p.grupoPessoas gp where t.dataVencimento between :dataIn and :dataFim and ((0 = :pedidosGrupoPessoa and p.identificador = :pessoa) ";
        hql = pessoa.getGrupoPessoas() != null && pedidosGrupoPessoa == 1 ? (String)hql + " or (1 = :pedidosGrupoPessoa and gp.identificador = :grupoPessoa))" : (pessoa.getGrupoPessoas() == null && pedidosGrupoPessoa == 1 ? (String)hql + " or (1 = :pedidosGrupoPessoa and  p.identificador = :pessoa))" : (String)hql + " )");
        hql = (String)hql + " and t.provisao = :realizado and t.pagRec = :pagRec and  exists( select u.identificador          from Usuario u           inner join u.usuarioBasico ub          inner join ub.empresas e         inner join e.grupo g          inner join g.grupoUsuarioConfiguracoes gc         inner join gc.tiposDoc gtd         inner join gtd.tipoDoc td          where u = :usuario and td = t.tipoDoc)";
        if (pesquisarTitOutrasEmp != 1) {
            hql = (String)hql + " and t.empresa = :empresa";
        }
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
        q.setShort("pedidosGrupoPessoa", pedidosGrupoPessoa.shortValue());
        q.setEntity("pessoa", (Object)pessoa);
        if (pessoa.getGrupoPessoas() != null && pedidosGrupoPessoa == 1) {
            q.setEntity("grupoPessoa", (Object)pessoa.getGrupoPessoas());
        }
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("usuario", (Object)usuario);
        q.setShort("pagRec", pagRec.shortValue());
        q.setShort("realizado", (short)1);
        if (pesquisarTitOutrasEmp != 1) {
            q.setEntity("empresa", (Object)empresa);
        }
        return q.list();
    }

    public List findTitulosBaixados(Date dataIn, Date dataFim, Pessoa pessoa, Usuario usuario, Empresa empresa, Short pesquisarTitOutrasEmp, Short pagRec, Short pedidosGrupoPessoa) {
        Object hql = "select distinct t    from Titulo t  inner join t.pessoa p left join p.grupoPessoas gp   where t.dataVencimento between :dataIn and :dataFim and ((0 = :pedidosGrupoPessoa and p.identificador = :pessoa) ";
        hql = pessoa.getGrupoPessoas() != null && pedidosGrupoPessoa == 1 ? (String)hql + " or (1 = :pedidosGrupoPessoa and gp.identificador = :grupoPessoa))" : (pessoa.getGrupoPessoas() == null && pedidosGrupoPessoa == 1 ? (String)hql + " or (1 = :pedidosGrupoPessoa and  p.identificador = :pessoa))" : (String)hql + " )");
        hql = (String)hql + "   and t.valorSaldo <> t.valor   and t.provisao = :realizado   and t.pagRec = :pagRec and  exists( select u.identificador          from Usuario u           inner join u.usuarioBasico ub          inner join ub.empresas e         inner join e.grupo g          inner join g.grupoUsuarioConfiguracoes gc         inner join gc.tiposDoc gtd         inner join gtd.tipoDoc td          where u = :usuario and td = t.tipoDoc)";
        if (pesquisarTitOutrasEmp != 1) {
            hql = (String)hql + "   and t.empresa = :empresa";
        }
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
        q.setShort("pedidosGrupoPessoa", pedidosGrupoPessoa.shortValue());
        q.setEntity("pessoa", (Object)pessoa);
        if (pessoa.getGrupoPessoas() != null && pedidosGrupoPessoa == 1) {
            q.setEntity("grupoPessoa", (Object)pessoa.getGrupoPessoas());
        }
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setShort("realizado", (short)1);
        q.setShort("pagRec", pagRec.shortValue());
        q.setEntity("usuario", (Object)usuario);
        if (pesquisarTitOutrasEmp != 1) {
            q.setEntity("empresa", (Object)empresa);
        }
        return q.list();
    }

    public List findPedidos(Date dataIn, Date dataFim, Pessoa pessoa, Empresa empresa, Short pedidosGrupoPessoa) {
        Object query = "select distinct c from Pedido c  inner join c.unidadeFatCliente u inner join u.cliente f inner join f.pessoa p     left join p.grupoPessoas gp\n where c.dataEmissao between :dataIn and :dataFim\n and ((0 = :pedidosGrupoPessoa and p.identificador = :pessoa) ";
        query = pessoa.getGrupoPessoas() != null && pedidosGrupoPessoa == 1 ? (String)query + " or (1 = :pedidosGrupoPessoa and gp.identificador = :grupoPessoa))" : (pessoa.getGrupoPessoas() == null && pedidosGrupoPessoa == 1 ? (String)query + " or (1 = :pedidosGrupoPessoa and  p.identificador = :pessoa))" : (String)query + " )");
        if (ToolMethods.isNotNull((Object)empresa).booleanValue()) {
            query = (String)query + " and c.empresa = :empresa";
        }
        query = (String)query + " and c.unificacaoPedido is null";
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)query);
        q.setShort("pedidosGrupoPessoa", pedidosGrupoPessoa.shortValue());
        q.setEntity("pessoa", (Object)pessoa);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        if (ToolMethods.isNotNull((Object)empresa).booleanValue()) {
            q.setEntity("empresa", (Object)empresa);
        }
        if (pessoa.getGrupoPessoas() != null && pedidosGrupoPessoa == 1) {
            q.setEntity("grupoPessoa", (Object)pessoa.getGrupoPessoas());
        }
        List list = q.list();
        return list;
    }

    public List findMovimentosFinanceiros(Date dataIn, Date dataFim, Pessoa pessoa, Empresa empresa, Short pedidosGrupoPessoa) {
        Object hql = "select distinct c from MovimentoBancario c inner join c.contaValor cc inner join cc.agenciaValor a inner join a.pessoa p left join p.grupoPessoas gp where c.dataLancamento between :dataIn and :dataFim  and c.empresa = :empresa and ((0 = :pedidosGrupoPessoa and p.identificador = :pessoa) ";
        hql = pessoa.getGrupoPessoas() != null && pedidosGrupoPessoa == 1 ? (String)hql + " or (1 = :pedidosGrupoPessoa and gp.identificador = :grupoPessoa))" : (pessoa.getGrupoPessoas() == null && pedidosGrupoPessoa == 1 ? (String)hql + " or (1 = :pedidosGrupoPessoa and  p.identificador = :pessoa))" : (String)hql + " )");
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
        q.setShort("pedidosGrupoPessoa", pedidosGrupoPessoa.shortValue());
        q.setEntity("pessoa", (Object)pessoa);
        if (pessoa.getGrupoPessoas() != null && pedidosGrupoPessoa == 1) {
            q.setEntity("grupoPessoa", (Object)pessoa.getGrupoPessoas());
        }
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)empresa);
        return q.list();
    }

    public List findUltimosRelacionamentos(Date dataIn, Date dataFim, Pessoa pessoa, Short pedidosGrupoPessoa) {
        Object hql = "select distinct c from RelacionamentoPessoa c  inner join c.pessoa p left join p.grupoPessoas gp where c.dataRelacionamento between :dataIn and :dataFim  and ((0 = :pedidosGrupoPessoa and p.identificador = :pessoa) ";
        hql = pessoa.getGrupoPessoas() != null && pedidosGrupoPessoa == 1 ? (String)hql + " or (1 = :pedidosGrupoPessoa and gp.identificador = :grupoPessoa))" : (pessoa.getGrupoPessoas() == null && pedidosGrupoPessoa == 1 ? (String)hql + " or (1 = :pedidosGrupoPessoa and  p.identificador = :pessoa))" : (String)hql + " )");
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
        q.setShort("pedidosGrupoPessoa", pedidosGrupoPessoa.shortValue());
        q.setEntity("pessoa", (Object)pessoa);
        if (pessoa.getGrupoPessoas() != null && pedidosGrupoPessoa == 1) {
            q.setEntity("grupoPessoa", (Object)pessoa.getGrupoPessoas());
        }
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        return q.list();
    }

    public Object findClassificacoesSetores(SetorUsuario vo) {
        Query q = CoreBdUtil.getInstance().getSession().createQuery(" select distinct m  from ClassificacaoMarketing m inner join m.setoresUsuario s  where s = :setor and m.ativo = :sim  ORDER BY m.descricao");
        q.setEntity("setor", (Object)vo);
        q.setShort("sim", (short)1);
        return q.list();
    }

    public Object findProcedenciasSetores(SetorUsuario setorUsuario) {
        Query q = CoreBdUtil.getInstance().getSession().createQuery(" select distinct p  from ProcedenciaSolicitacao p inner join p.procedenciaSolicitacaoSetorUsuario s  where s.setorUsuario = :setorUsuario ORDER BY p.descricao");
        q.setEntity("setorUsuario", (Object)setorUsuario);
        return q.list();
    }

    public void atualizaArquivoDocumento(RelacionamentoPessoa rel) {
        Query q = CoreBdUtil.getInstance().getSession().createQuery("update RelacionamentoPessoa r set r.arquivamentoDoc = null where r = :rel");
        q.setEntity("rel", (Object)rel);
        q.executeUpdate();
    }

    public List findCotacoesVenda(Date dataIn, Date dataFim, Pessoa pessoa, Empresa empresa, Short pedidosGrupoPessoa) {
        Object query = "select distinct c from CotacaoVendas c  inner join c.unidadeFatCliente u inner join u.cliente f inner join f.pessoa p left join p.grupoPessoas gp where c.dataEmissao between :dataIn and :dataFim and ((0 = :pedidosGrupoPessoa and p.identificador = :pessoa) ";
        query = pessoa.getGrupoPessoas() != null && pedidosGrupoPessoa == 1 ? (String)query + " or (1 = :pedidosGrupoPessoa and gp.identificador = :grupoPessoa))" : (pessoa.getGrupoPessoas() == null && pedidosGrupoPessoa == 1 ? (String)query + " or (1 = :pedidosGrupoPessoa and  p.identificador = :pessoa))" : (String)query + " )");
        if (ToolMethods.isNotNull((Object)empresa).booleanValue()) {
            query = (String)query + " and c.empresa = :empresa";
        }
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)query);
        q.setShort("pedidosGrupoPessoa", pedidosGrupoPessoa.shortValue());
        q.setEntity("pessoa", (Object)pessoa);
        if (pessoa.getGrupoPessoas() != null && pedidosGrupoPessoa == 1) {
            q.setEntity("grupoPessoa", (Object)pessoa.getGrupoPessoas());
        }
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        if (ToolMethods.isNotNull((Object)empresa).booleanValue()) {
            q.setEntity("empresa", (Object)empresa);
        }
        return q.list();
    }

    public List findRotaClientePedidos(Date dataIn, Date dataFim, Pessoa pessoa, Empresa empresa, Short pedidosGrupoPessoa) {
        Object hql = "select distinct rc  from RotaClientePedidoPedido rc  inner join rc.pedido c inner join c.unidadeFatCliente u inner join u.cliente f inner join f.pessoa p left join p.grupoPessoas gp where rc.rotaClientePedido.dataEmissao between :dataIn and :dataFim and c.empresa = :empresa and ((0 = :pedidosGrupoPessoa and p.identificador = :pessoa) ";
        hql = pessoa.getGrupoPessoas() != null && pedidosGrupoPessoa == 1 ? (String)hql + " or (1 = :pedidosGrupoPessoa and gp.identificador = :grupoPessoa))" : (pessoa.getGrupoPessoas() == null && pedidosGrupoPessoa == 1 ? (String)hql + " or (1 = :pedidosGrupoPessoa and  p.identificador = :pessoa))" : (String)hql + " )");
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
        q.setShort("pedidosGrupoPessoa", pedidosGrupoPessoa.shortValue());
        q.setEntity("pessoa", (Object)pessoa);
        if (pessoa.getGrupoPessoas() != null && pedidosGrupoPessoa == 1) {
            q.setEntity("grupoPessoa", (Object)pessoa.getGrupoPessoas());
        }
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)empresa);
        return q.list();
    }

    public Double findPrazoMedioEntrega(Date dataIn, Date dataFim, Pessoa pessoa, Empresa empresa) {
        Query q = CoreBdUtil.getInstance().getSession().createQuery(" select AVG(CAST(ss.dataEntrega - np.dataEmissaoNota as double)) from SaidaNotasSaida ss  inner join ss.notaFiscalPropria np inner join np.unidadeFatCliente un inner join un.cliente cl inner join cl.pessoa p where np.dataEmissaoNota between :dataIn and :dataFim and p = :pessoa and np.empresa = :empresa  and ss.identificador is not null ");
        q.setEntity("pessoa", (Object)pessoa);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)empresa);
        return q.uniqueResult() != null ? (Double)q.uniqueResult() : 0.0;
    }
}

