/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.GrupoCidadesCidade;
import com.touchcomp.basementor.model.vo.RotaClientes;
import com.touchcomp.basementor.model.vo.RotaClientesItem;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import java.util.List;
import java.util.Optional;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class DAORotaClienteItem
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return RotaClientesItem.class;
    }

    public String sincronizaRotaClienteGrCidades() throws ExceptionDatabase {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct u from Cliente c inner join c.unidadeFatClientes u  where not exists  (select r.identificador from RotaClientesItem r where u=r.unidadeFatCliente)");
        List u = q.list();
        List rotas = (List)CoreDAOFactory.getInstance().getDAORotaClientes().findAll();
        StringBuilder sb = new StringBuilder();
        for (UnidadeFatCliente u1 : u) {
            RotaClientes r = null;
            for (RotaClientes rota : rotas) {
                Optional<GrupoCidadesCidade> found = rota.getGrupoCidades().getCidades().stream().filter(cid -> cid.getCidade().equals((Object)u1.getPessoa().getEndereco().getCidade())).findFirst();
                if (!found.isPresent()) continue;
                r = rota;
                break;
            }
            if (r != null) {
                RotaClientesItem rr = new RotaClientesItem();
                rr.setRotaClientes(r);
                rr.setUnidadeFatCliente(u1);
                rr.setNrSequencial(this.getMaxSeq(r));
                r.getItens().add(rr);
                sb.append("Cliente adicionado a rota: " + String.valueOf(u1) + " -> " + r.getDescricao() + "\n");
            } else {
                sb.append("(Cidade nao encontrada) Cliente n\u00e3o adicionado a rota: " + String.valueOf(u1) + " -> " + u1.getPessoa().getEndereco().getCidade().getDescricao() + "\n");
            }
            r = null;
        }
        this.saveOrUpdateCollection(rotas);
        return sb.toString();
    }

    private Integer getMaxSeq(RotaClientes r) {
        if (r.getItens().isEmpty()) {
            return 1;
        }
        int max = 1;
        for (RotaClientesItem ob : r.getItens()) {
            if (ob.getNrSequencial() <= max) continue;
            max = ob.getNrSequencial();
        }
        return max + 1;
    }
}

