/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoDeSituacoes;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.RotaClientePedido;
import com.touchcomp.basementor.model.vo.RotaClientePedidoPedido;
import com.touchcomp.basementor.model.vo.SituacaoPedidos;
import com.touchcomp.basementor.model.vo.Transportador;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class DAORotaClientePedido
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return RotaClientePedido.class;
    }

    public Object findPedidosPorFiltros(Short filtrarData, Date dataInicial, Date dataFinal, GrupoDeSituacoes grupoSituacoesPed, Short tipoData, Empresa empresa, Short filtrarTransportador, Transportador transportador) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = " SELECT DISTINCT p FROM Pedido p inner join p.liberacaoPedidoPed l inner join p.situacaoPedido s inner join s.grupoDeSituacoes gd inner join gd.grupoDeSituacoes g WHERE g = :grupo and p.empresa = :empresa and p.unificacaoPedido is null  and p.situacaoPedido.cancelarTitulos = :nao";
        if (filtrarData == 1) {
            hql = tipoData == 0 ? (String)hql + " and p.dataPrevisaoSaida between :dataInicial and :dataFinal" : (tipoData == 1 ? (String)hql + " and p.dataEmissao between :dataInicial and :dataFinal" : (String)hql + " and p.dataPrevisaoFat between :dataInicial and :dataFinal");
        }
        if (filtrarTransportador == 1) {
            hql = (String)hql + " and p.transportador = :transportador";
        }
        hql = (String)hql + " and not exists (select r.identificador from RotaClientePedidoPedido r where r.pedido.identificador = p.identificador )";
        Query q = s.createQuery((String)hql);
        if (filtrarData == 1) {
            q.setDate("dataInicial", dataInicial);
            q.setDate("dataFinal", dataFinal);
        }
        if (filtrarTransportador == 1) {
            q.setEntity("transportador", (Object)transportador);
        }
        q.setEntity("grupo", (Object)grupoSituacoesPed);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("nao", (short)0);
        return q.list();
    }

    public List findRotasPorPedido(Short filtrarData, Date dataInicial, Date dataFinal, SituacaoPedidos situacaoPedido, Short tipoData, Empresa empresa, Short filtrarTransportador, Transportador transportador) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object filtroData = " ";
        Object filtroTransportador = " ";
        if (filtrarData == 1) {
            filtroData = tipoData == 0 ? (String)filtroData + " and p.dataPrevisaoSaida between :dataInicial and :dataFinal" : (tipoData == 1 ? (String)filtroData + " and p.dataEmissao between :dataInicial and :dataFinal" : (String)filtroData + " and p.dataPrevisaoFat between :dataInicial and :dataFinal");
        }
        if (filtrarTransportador == 1) {
            filtroTransportador = (String)filtroTransportador + " and p.transportador = :transportador";
        }
        String hql = " select distinct rota  from RotaClientes rota  inner join rota.itens itemRota  where  not exists (             select rotaClientePedido.identificador             from RotaClientePedido rotaClientePedido             where rotaClientePedido.rotaClientes = rota) and exists(select p.identificador         from Pedido p         where         p.situacaoPedido = :situacaoPedido         and         p.unidadeFatCliente = itemRota.unidadeFatCliente        and         p.empresa = :empresa " + (String)filtroData + (String)filtroTransportador + " )";
        Query q = s.createQuery(hql);
        if (filtrarData == 1) {
            q.setDate("dataInicial", dataInicial);
            q.setDate("dataFinal", dataFinal);
        }
        if (filtrarTransportador == 1) {
            q.setEntity("transportador", (Object)transportador);
        }
        q.setEntity("situacaoPedido", (Object)situacaoPedido);
        q.setEntity("empresa", (Object)empresa);
        return q.list();
    }

    public RotaClientePedidoPedido findRotaClientePedidoPedidoPorPedido(Pedido pedido) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = " SELECT DISTINCT r FROM RotaClientePedidoPedido r  WHERE r.pedido = :pedido";
        Query q = s.createQuery(hql);
        q.setEntity("pedido", (Object)pedido);
        q.setMaxResults(1);
        return (RotaClientePedidoPedido)q.uniqueResult();
    }
}

